# Actors and Capabilities - AU eRequesting Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* **Actors and Capabilities**

## Actors and Capabilities

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

This page includes the ActorDefinitions and CapabilityStatements for AU eRequesting.

The ActorDefinitions define the systems that play a role in data exchange, and that have obligations associated with the role the actor plays, in AU eRequesting.

The CapabilityStatements define the specific capabilities that different types of systems are expected to have in order to comply with this implementation guide. Systems conforming to this implementation guide are expected to declare conformance to one or more capability statements.

| | | |
| :--- | :--- | :--- |
| [AU eRequesting Placer actor](ActorDefinition-au-erequesting-actor-placer.md) | The AU eRequesting Placer is a system that is responsible for creating diagnostic requests. | [AU eRequesting Placer CapabilityStatement](CapabilityStatement-au-erequesting-placer.md) |
| [AU eRequesting Filler actor](ActorDefinition-au-erequesting-actor-filler.md) | The AU eRequesting Filler is a system that is responsible for finding and retrieving diagnostic request fulfilments so that service providers can fulfil them. | [AU eRequesting Filler CapabilityStatement](CapabilityStatement-au-erequesting-filler.md) |
| [AU eRequesting Patient actor](ActorDefinition-au-erequesting-actor-patient.md) | The AU eRequesting Patient is a system that allows patients or their representatives to view diagnostic requests and fulfilment of diagnostic requests. | [AU eRequesting Patient CapabilityStatement](CapabilityStatement-au-erequesting-patient.md) |
| [AU eRequesting Server actor](ActorDefinition-au-erequesting-actor-server.md) | The AU eRequesting Server is a system that accepts diagnostic service requests and makes diagnostic service requests accessible. | [AU eRequesting Server CapabilityStatement](CapabilityStatement-au-erequesting-server.md) |

