# Task - Pathology Fulfilment Task - AU eRequesting Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Task - Pathology Fulfilment Task**

## Example Task: Task - Pathology Fulfilment Task

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU eRequesting Task Diagnostic Request](StructureDefinition-au-erequesting-task-diagnosticrequest.md)

Tag: fulfilment of a task (Details: Resource Tag code fulfilment-task = 'fulfilment of a task')

**identifier**: Placer Identifier/EMC4542244-5625-01

**groupIdentifier**: Placer Group Number/EMC4542244-5625

**partOf**: [Task Fulfill the focal request](Task-taskgroup-pathology-1.md)

**status**: Requested

**intent**: order

**priority**: Routine

**code**: Fulfill the focal request

**focus**: [ServiceRequest Complete blood count](ServiceRequest-order-fbc-1.md)

**for**: [Fred Roberts Male, DoB: 1961-06-16 ( IHI: Austalian Healthcare Identifier - Individual#8003608500314661)](Patient-roberts-fred.md)

**authoredOn**: 2024-05-11

**requester**: [PractitionerRole General practitioner](PractitionerRole-generalpractitioner-guthridge-jarred.md)

**owner**: [Organization Kioma Pathology](Organization-kioma-pathology.md)



## Resource Content

```json
{
  "resourceType" : "Task",
  "id" : "taskfulfilment-pathology-1",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-task-diagnosticrequest"
    ],
    "tag" : [
      {
        "system" : "http://terminology.hl7.org.au/CodeSystem/resource-tag",
        "code" : "fulfilment-task"
      }
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "PLAC",
            "display" : "Placer Identifier"
          }
        ]
      },
      "system" : "http://ns.electronichealth.net.au/id/hpio-scoped/order/1.0/8003622500032165",
      "value" : "EMC4542244-5625-01",
      "assigner" : {
        "display" : "Elimbah Medical Centre"
      }
    }
  ],
  "groupIdentifier" : {
    "type" : {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
          "code" : "PGN"
        }
      ],
      "text" : "Placer Group Number"
    },
    "system" : "http://ns.electronichealth.net.au/id/hpio-scoped/order/1.0/8003622500032165",
    "value" : "EMC4542244-5625",
    "assigner" : {
      "reference" : "Organization/elimbah-medical-centre",
      "display" : "Elimbah Medical Centre"
    }
  },
  "partOf" : [
    {
      "reference" : "Task/taskgroup-pathology-1"
    }
  ],
  "status" : "requested",
  "intent" : "order",
  "priority" : "routine",
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/CodeSystem/task-code",
        "code" : "fulfill"
      }
    ]
  },
  "focus" : {
    "reference" : "ServiceRequest/order-fbc-1"
  },
  "for" : {
    "reference" : "Patient/roberts-fred"
  },
  "authoredOn" : "2024-05-11",
  "requester" : {
    "reference" : "PractitionerRole/generalpractitioner-guthridge-jarred"
  },
  "owner" : {
    "reference" : "Organization/kioma-pathology"
  }
}

```
