# AU eRequesting Task Group - AU eRequesting Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **AU eRequesting Task Group**

## Resource Profile: AU eRequesting Task Group 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-task-group | *Version*:1.0.0 | |
| * Standards status: *[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](https://build.fhir.org/ig/hl7au/au-fhir-base/generalguidance.html#maturity-levels): 1 | *Computable Name*:AUeRequestingTaskGroup |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2024+; Licensed Under Creative Commons No Rights Reserved. | | |

 
This profile sets minimum expectations for a Task resource that is used to record, search, and fetch information about a group of tasks that are part of the same fulfilment group. It is based on the [AU eRequesting Task](StructureDefinition-au-erequesting-task.md) profile and identifies the additional constraints, extensions, vocabularies and value sets that **SHALL** be present in the Task resource when conforming to this profile. 

### Profile Specific Implementation Guidance

* See [AU eRequesting Task Profile Specific Implementation Guidance](StructureDefinition-au-erequesting-task.md#profile-specific-implementation-guidance) for general guidance applicable to profiles based on AU eRequesting Task.

**Usages:**

* Refer to this Profile: [AU eRequesting Task Communication Request](StructureDefinition-au-erequesting-task-communicationrequest.md) and [AU eRequesting Task Diagnostic Request](StructureDefinition-au-erequesting-task-diagnosticrequest.md)
* Examples for this Profile: [Task/taskgroup-imaging-1](Task-taskgroup-imaging-1.md) and [Task/taskgroup-pathology-1](Task-taskgroup-pathology-1.md)
* CapabilityStatements using this Profile: [AU eRequesting Filler CapabilityStatement](CapabilityStatement-au-erequesting-filler.md), [AU eRequesting Patient CapabilityStatement](CapabilityStatement-au-erequesting-patient.md), [AU eRequesting Placer CapabilityStatement](CapabilityStatement-au-erequesting-placer.md) and [AU eRequesting Server CapabilityStatement](CapabilityStatement-au-erequesting-server.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.au.ereq|current/StructureDefinition/au-erequesting-task-group)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-au-erequesting-task-group.csv), [Excel](StructureDefinition-au-erequesting-task-group.xlsx), [Schematron](StructureDefinition-au-erequesting-task-group.sch) 

### Notes:

Below is an overview of the mandatory and optional search parameters and combined search parameters. See the [AU eRequesting CapabilityStatements](capability-statements.md) for a complete list of supported RESTful interactions for this IG.

FHIR search operations are described [here](http://hl7.org/fhir/R4/search.html) and the syntax used to describe AU eRequesting interactions is defined [here](https://hl7.org.au/fhir/core/2.0.0/general-guidance.html#readsearch-syntax).

Any search parameter defined in FHIR may be 'allowed' by the system unless explicitly marked as "**SHALL NOT**".

* Parameter(s): _id
  * Server Conformance: **SHALL**
  * Placer Conformance: **MAY**
  * Filler Conformance: **MAY**
  * Patient Conformance: **MAY**
  * Type(s): `token`
  * Requirements (when used alone or in combination): 
* Parameter(s): _lastUpdated
  * Server Conformance: **SHALL**
  * Placer Conformance: **MAY**
  * Filler Conformance: **MAY**
  * Patient Conformance: **MAY**
  * Type(s): `date`
  * Requirements (when used alone or in combination): The Server**SHALL**support`multipleAnd`. The Server**SHALL**support search comparators`gt`,`lt`,`ge`,`le`.The AU eRequesting Placer, Filler and Patient actors**MAY**support`multipleAnd`.The AU eRequesting Placer, Filler and Patient actors**MAY**support search comparators`gt`,`lt`,`ge`,`le`.
* Parameter(s): _lastUpdated+status+owner
  * Server Conformance: **SHALL**
  * Placer Conformance: **MAY**
  * Filler Conformance: **MAY**
  * Patient Conformance: **MAY**
  * Type(s): `date`+`token`+`reference`
  * Requirements (when used alone or in combination): 
* Parameter(s): _tag
  * Server Conformance: **SHALL**
  * Placer Conformance: **MAY**
  * Filler Conformance: **MAY**
  * Patient Conformance: **MAY**
  * Type(s): `token`
  * Requirements (when used alone or in combination): 
* Parameter(s): focus
  * Server Conformance: **SHALL**
  * Placer Conformance: **MAY**
  * Filler Conformance: **MAY**
  * Patient Conformance: **MAY**
  * Type(s): `reference`
  * Requirements (when used alone or in combination): 
* Parameter(s): group-identifier
  * Server Conformance: **SHALL**
  * Placer Conformance: **MAY**
  * Filler Conformance: **MAY**
  * Patient Conformance: **MAY**
  * Type(s): `token`
  * Requirements (when used alone or in combination): 
* Parameter(s): owner
  * Server Conformance: **SHALL**
  * Placer Conformance: **MAY**
  * Filler Conformance: **MAY**
  * Patient Conformance: **MAY**
  * Type(s): `reference`
  * Requirements (when used alone or in combination): The same conformance rules apply to the chained search owner.identifier using HPI-O and ABN identifiers as defined in the AU Core Organization profile.
* Parameter(s): owner+status
  * Server Conformance: **SHALL**
  * Placer Conformance: **MAY**
  * Filler Conformance: **MAY**
  * Patient Conformance: **MAY**
  * Type(s): `reference`+`token`
  * Requirements (when used alone or in combination): 
* Parameter(s): part-of
  * Server Conformance: **SHALL**
  * Placer Conformance: **MAY**
  * Filler Conformance: **MAY**
  * Patient Conformance: **MAY**
  * Type(s): `reference`
  * Requirements (when used alone or in combination): 
* Parameter(s): patient
  * Server Conformance: **SHALL**
  * Placer Conformance: **MAY**
  * Filler Conformance: **MAY**
  * Patient Conformance: **MAY**
  * Type(s): `reference`
  * Requirements (when used alone or in combination): The same conformance rules apply to the chained search patient.identifier using IHI, Medicare Number, and DVA Number identifiers as defined in the AU Core Patient profile.
* Parameter(s): patient+status
  * Server Conformance: **SHALL**
  * Placer Conformance: **MAY**
  * Filler Conformance: **MAY**
  * Patient Conformance: **MAY**
  * Type(s): `reference`+`token`
  * Requirements (when used alone or in combination): 
* Parameter(s): requester
  * Server Conformance: **SHALL**
  * Placer Conformance: **MAY**
  * Filler Conformance: **MAY**
  * Patient Conformance: **MAY**
  * Type(s): `reference`
  * Requirements (when used alone or in combination): The same conformance rules apply to the chained search requester.identifier using Medicare Provider Number identifier as defined in the AU Core PractitionerRole profile.
* Parameter(s): requester+status
  * Server Conformance: **SHALL**
  * Placer Conformance: **MAY**
  * Filler Conformance: **MAY**
  * Patient Conformance: **MAY**
  * Type(s): `reference`+`token`
  * Requirements (when used alone or in combination): 
* Parameter(s): status
  * Server Conformance: **SHALL**
  * Placer Conformance: **MAY**
  * Filler Conformance: **MAY**
  * Patient Conformance: **MAY**
  * Type(s): `token`
  * Requirements (when used alone or in combination): The Server**SHALL**support`multipleOr`.The AU eRequesting Placer, Filler and Patient actors**MAY**support`multipleOr`.
* Parameter(s): _include=Task:focus
  * Server Conformance: **SHALL**
  * Placer Conformance: **MAY**
  * Filler Conformance: **MAY**
  * Patient Conformance: **MAY**
  * Type(s): `reference`
  * Requirements (when used alone or in combination): 
* Parameter(s): _include=Task:owner
  * Server Conformance: **SHALL**
  * Placer Conformance: **MAY**
  * Filler Conformance: **MAY**
  * Patient Conformance: **MAY**
  * Type(s): `reference`
  * Requirements (when used alone or in combination): 
* Parameter(s): _include=Task:patient
  * Server Conformance: **SHALL**
  * Placer Conformance: **MAY**
  * Filler Conformance: **MAY**
  * Patient Conformance: **MAY**
  * Type(s): `reference`
  * Requirements (when used alone or in combination): 
* Parameter(s): _include=Task:requester
  * Server Conformance: **SHALL**
  * Placer Conformance: **MAY**
  * Filler Conformance: **MAY**
  * Patient Conformance: **MAY**
  * Type(s): `reference`
  * Requirements (when used alone or in combination): 
* Parameter(s): _revinclude=Task:part-of
  * Server Conformance: **SHALL**
  * Placer Conformance: **MAY**
  * Filler Conformance: **MAY**
  * Patient Conformance: **MAY**
  * Type(s): `reference`
  * Requirements (when used alone or in combination): 

#### Search Parameters:

The following search parameters and search parameter combinations are supported. Conformance obligations are detailed in the table above.

1. **[`_id`](https://hl7.org/fhir/R4/task.html#search)**search parameter
* including support for these **[`_include`](http://hl7.org/fhir/R4/search.html#include)** parameters: `Task:focus`, `Task:owner`, `Task:patient`, and `Task:requester`
* including support for **[`_revinclude`](https://hl7.org/fhir/R4/search.html#revinclude)** parameter: `Task:part-of`
`GET [base]/Task?_id=[id]`Example:
1. GET [base]/Task?_id=2169591
1. GET [base]/Task?_id=2169591&_include=Task:patient&_include=Task:requester&_include=Task:owner&_include=Task:focus
1. GET [base]/Task?_id=2169591&_revinclude=Task:part-of
**Implementation Notes:** Fetches a bundle with the requested Task, instead of just the resource itself, and allows for the inclusion of additional search parameters such as _include, _revinclude, or _lastUpdated ([how to search by id of the resource](https://hl7.org/fhir/r4/search.html#id))
1. **[`_lastUpdated`](https://hl7.org/fhir/R4/resource.html#search)**search parameter
* including support for these **[`_include`](http://hl7.org/fhir/R4/search.html#include)** parameters: `Task:focus`, `Task:owner`, `Task:patient`, and `Task:requester`
* including support for **[`_revinclude`](https://hl7.org/fhir/R4/search.html#revinclude)** parameter: `Task:part-of`
* including support for **[`multipleAnd`](http://hl7.org/fhir/R4/searchparameter-definitions.html#SearchParameter.multipleAnd)**
* including support for comparators `gt`, `lt`, `ge`, `le`
`GET [base]/Task?_lastUpdated={gt|lt|ge|le}[date]{&_lastUpdated={gt|lt|ge|le}[date]&...}`Example:
1. GET [base]/Task?_lastUpdated=gt2010-10-01
1. GET [base]/Task?_lastUpdated=lt2010-10-31&_lastUpdated=gt2010-10-01
1. GET [base]/Task?_lastUpdated=gt2010-10-01&_include=Task:patient&_include=Task:requester&_include=Task:owner&_include=Task:focus
1. GET [base]/Task?_lastUpdated=gt2010-10-01&_revinclude=Task:part-of
**Implementation Notes:** Fetches a bundle matching the _lastUpdated date ([how to search by date](http://hl7.org/fhir/R4/search.html#date))
1. Combined**[`_lastUpdated`](https://hl7.org/fhir/R4/resource.html#search)**and**[`status`](https://hl7.org/fhir/R4/task.html#search)**and**[`owner`](https://hl7.org/fhir/R4/task.html#search)**search parameters
* including support for these **[`_include`](http://hl7.org/fhir/R4/search.html#include)** parameters: `Task:focus`, `Task:owner`, `Task:patient`, and `Task:requester`
* including support for **[`_revinclude`](https://hl7.org/fhir/R4/search.html#revinclude)** parameter: `Task:part-of`
* including support for chained searching of owner canonical identifier `owner.identifier` (e.g. `owner{:Type}.identifier=[system|][code]`)
* including support for **[`multipleOr`](http://hl7.org/fhir/R4/searchparameter-definitions.html#SearchParameter.multipleOr)** search on `status`
* including support for **[`multipleAnd`](http://hl7.org/fhir/R4/searchparameter-definitions.html#SearchParameter.multipleAnd)** search on `_lastUpdated`
* including support for search comparators `gt`, `lt`, `ge`, `le` on `_lastUpdated`
`GET [base]/Task?_lastUpdated={gt|lt|ge|le}[date]&status={system|}[code]&owner={Type/}[id]` or optionally `GET [base]/Task?_lastUpdated={gt|lt|ge|le}[date]&status={system|}[code]&owner{:Type}.identifier=[system|][code]`Example:
1. GET [base]/Task?_lastUpdated=gt2010-10-01&status=completed&owner=Organization/1234
1. GET [base]/Task?_lastUpdated=gt2010-10-01&status=completed&owner:Organization.identifier=http://ns.electronichealth.net.au/id/hi/hpio/1.0|8003621566684455
1. GET [base]/Task?_lastUpdated=gt2010-10-01&status=accepted,in-progress&owner.identifier=https://elimbahmedicalcentre.example.com.au/orders/practitioner-identifier|EMC1234567-1234&_include=Task:patient&_include=Task:requester&_include=Task:owner&_include=Task:focus
1. GET [base]/Task?_lastUpdated=gt2010-10-01&status=completed&owner.identifier=https://elimbahmedicalcentre.example.com.au/orders/practitioner-identifier|EMC1234567-1234&_revinclude=Task:part-of
**Implementation Notes:** Fetches a bundle containing Task resources matching the _lastUpdated date, owner and status ([how to search by date](http://hl7.org/fhir/R4/search.html#date), [how to search by token](http://hl7.org/fhir/R4/search.html#token), [how to search by reference](http://hl7.org/fhir/R4/search.html#reference))
1. **[`_tag`](https://hl7.org/fhir/R4/resource.html#search)**search parameter
* including support for these **[`_include`](http://hl7.org/fhir/R4/search.html#include)** parameters: `Task:focus`, `Task:owner`, `Task:patient`, and `Task:requester`
* including support for **[`_revinclude`](https://hl7.org/fhir/R4/search.html#revinclude)** parameter: `Task:part-of`
`GET [base]/Task?_tag={system|}[code]`Example:
1. GET [base]/Task?_tag=fulfilment-task-group
1. GET [base]/Task?_tag=http://terminology.hl7.org.au/CodeSystem/resource-tag|fulfilment-task-group
1. GET [base]/Task?_tag=fulfilment-task&_include=Task:patient&_include=Task:requester&_include=Task:owner&_include=Task:focus
1. GET [base]/Task?_tag=fulfilment-task&_revinclude=Task:part-of
**Implementation Notes:** Fetches a bundle containing Task resources matching the tag ([how to search by token](http://hl7.org/fhir/R4/search.html#token))
1. **[`focus`](https://hl7.org/fhir/R4/task.html#search)**search parameter
* including support for these **[`_include`](http://hl7.org/fhir/R4/search.html#include)** parameters: `Task:focus`, `Task:owner`, `Task:patient`, and `Task:requester`
* including support for **[`_revinclude`](https://hl7.org/fhir/R4/search.html#revinclude)** parameter: `Task:part-of`
`GET [base]/Task?focus={Type/}[id]`Example:
1. GET [base]/Task?focus=ServiceRequest/1234
1. GET [base]/Task?focus=ServiceRequest/1234&_include=Task:patient&_include=Task:requester&_include=Task:owner&_include=Task:focus
1. GET [base]/Task?focus=ServiceRequest/1234&_revinclude=Task:part-of
**Implementation Notes:** Fetches a bundle containing Task resources matching the focus ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference))
1. **[`group-identifier`](https://hl7.org/fhir/R4/task.html#search)**search parameter
* including support for these **[`_include`](http://hl7.org/fhir/R4/search.html#include)** parameters: `Task:focus`, `Task:owner`, `Task:patient`, and `Task:requester`
* including support for **[`_revinclude`](https://hl7.org/fhir/R4/search.html#revinclude)** parameter: `Task:part-of`
`GET [base]/Task?group-identifier={system|}[code]`Example:
1. GET [base]/Task?group-identifier=https://elimbahmedicalcentre.example.com.au/orders/task-identifier|EMC1234567-1234
1. GET [base]/Task?group-identifier=https://elimbahmedicalcentre.example.com.au/orders/task-identifier|EMC1234567-1234&_include=Task:patient&_include=Task:requester&_include=Task:owner&_include=Task:focus
1. GET [base]/Task?group-identifier=https://elimbahmedicalcentre.example.com.au/orders/task-identifier|EMC1234567-1234&_revinclude=Task:part-of
**Implementation Notes:** Fetches a bundle containing Task resources matching the group identifier ([how to search by token](http://hl7.org/fhir/R4/search.html#token))
1. **[`owner`](https://hl7.org/fhir/R4/task.html#search)**search parameter
* including support for these **[`_include`](http://hl7.org/fhir/R4/search.html#include)** parameters: `Task:focus`, `Task:owner`, `Task:patient`, and `Task:requester`
* including support for **[`_revinclude`](https://hl7.org/fhir/R4/search.html#revinclude)** parameter: `Task:part-of`
* including support for chained searching of owner canonical identifier `owner.identifier` (e.g. `owner{:Type}.identifier=[system|][code]`)
`GET [base]/Task?owner={Type/}[id]` or optionally `GET [base]/Task?owner{:Type}.identifier=[system|][code]`Example:
1. GET [base]/Task?owner=5678
1. GET [base]/Task?owner:Organization.identifier=http://ns.electronichealth.net.au/id/hi/hpio/1.0|8003621566684455
1. GET [base]/Task?owner=5678&_include=Task:patient&_include=Task:requester&_include=Task:owner&_include=Task:focus
1. GET [base]/Task?owner=5678&_revinclude=Task:part-of
**Implementation Notes:** Fetches a bundle containing Task resources matching the owner ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference))
1. Combined**[`owner`](https://hl7.org/fhir/R4/task.html#search)**and**[`status`](https://hl7.org/fhir/R4/task.html#search)**search parameters:
* including support for these **[`_include`](http://hl7.org/fhir/R4/search.html#include)** parameters: `Task:focus`, `Task:owner`, `Task:patient`, and `Task:requester`
* including support for **[`_revinclude`](https://hl7.org/fhir/R4/search.html#revinclude)** parameter: `Task:part-of`
* including support for chained searching of owner canonical identifier `owner.identifier` (e.g. `owner{:Type}.identifier=[system|][code]`)
* including support for **[`multipleOr`](http://hl7.org/fhir/R4/searchparameter-definitions.html#SearchParameter.multipleOr)** search on `status`
`GET [base]/Task?owner={Type/}[id]&status={system|}[code]{,{system|}[code],...}` or optionally `GET [base]/Task?owner{:Type}.identifier=[system|][code]&status={system|}[code]{,{system|}[code],...}`Example:
1. GET [base]/Task?owner=5678&status=completed
1. GET [base]/Task?owner:Organization.identifier=http://ns.electronichealth.net.au/id/hi/hpio/1.0|8003621566684455&status=completed
1. GET [base]/Task?owner=5678&status=completed&_include=Task:patient&_include=Task:requester&_include=Task:owner&_include=Task:focus
1. GET [base]/Task?owner=5678&status=accepted,in-progress
1. GET [base]/Task?owner=5678&status=completed&_revinclude=Task:part-of
**Implementation Notes:** Fetches a bundle containing Task resources matching the owner and status ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference), [how to search by token](http://hl7.org/fhir/R4/search.html#token))
1. **[`part-of`](https://hl7.org/fhir/R4/task.html#search)**search parameter
* including support for these **[`_include`](http://hl7.org/fhir/R4/search.html#include)** parameters: `Task:focus`, `Task:owner`, `Task:patient`, and `Task:requester`
* including support for **[`_revinclude`](https://hl7.org/fhir/R4/search.html#revinclude)** parameter: `Task:part-of`
`GET [base]/Task?part-of={Type/}[id]`Example:
1. GET [base]/Task?part-of=Task/678
1. GET [base]/Task?part-of=Task/678&_include=Task:patient&_include=Task:requester&_include=Task:owner&_include=Task:focus
1. GET [base]/Task?part-of=Task/678&_include=Task:patient&_include=Task:requester&_include=Task:owner&_include=Task:focus&_revinclude=Task:part-of
**Implementation Notes:** Fetches a bundle containing Task resources part of the task group ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference))
1. **[`patient`](https://hl7.org/fhir/R4/task.html#search)**search parameter
* including support for these **[`_include`](http://hl7.org/fhir/R4/search.html#include)** parameters: `Task:focus`, `Task:owner`, `Task:patient`, and `Task:requester`
* including support for **[`_revinclude`](https://hl7.org/fhir/R4/search.html#revinclude)** parameter: `Task:part-of`
* including support for chained searching of patient canonical identifier `patient.identifier` (e.g. `patient.identifier=[system|][code]`)
`GET [base]/Task?patient={Type/}[id]` or optionally `GET [base]/Task?patient.identifier=[system|][code]`Example:
1. GET [base]/Task?patient=5678
1. GET [base]/Task?patient.identifier=http://ns.electronichealth.net.au/id/medicare-number|32788511952
1. GET [base]/Task?patient=5678&_include=Task:patient&_include=Task:requester&_include=Task:owner&_include=Task:focus
1. GET [base]/Task?patient=5678&_revinclude=Task:part-of
**Implementation Notes:** Fetches a bundle containing Task resources matching the patient ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference))
1. Combined**[`patient`](https://hl7.org/fhir/R4/task.html#search)**and**[`status`](https://hl7.org/fhir/R4/task.html#search)**search parameters
* including support for these **[`_include`](http://hl7.org/fhir/R4/search.html#include)** parameters: `Task:focus`, `Task:owner`, `Task:patient`, and `Task:requester`
* including support for **[`_revinclude`](https://hl7.org/fhir/R4/search.html#revinclude)** parameter: `Task:part-of`
* including support for chained searching of patient canonical identifier `patient.identifier` (e.g. `patient.identifier=[system|][code]`)
* including support for **[`multipleOr`](http://hl7.org/fhir/R4/searchparameter-definitions.html#SearchParameter.multipleOr)** search on `status`
`GET [base]/Task?patient={Type/}[id]&status={system|}[code]{,{system|}[code],...}` or optionally `GET [base]/Task?patient.identifier=[system|][code]&status={system|}[code]{,{system|}[code],...}`Example:
1. GET [base]/Task?patient=5678&status=completed
1. GET [base]/Task?patient.identifier=http://ns.electronichealth.net.au/id/medicare-number|32788511952&status=completed
1. GET [base]/Task?patient=5678&status=completed&_include=Task:patient&_include=Task:requester&_include=Task:owner&_include=Task:focus
1. GET [base]/Task?patient=5678&status=accepted,in-progress
1. GET [base]/Task?patient=5678&status=completed&_revinclude=Task:part-of
**Implementation Notes:** Fetches a bundle containing Task resources matching the patient and status ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference), [how to search by token](http://hl7.org/fhir/R4/search.html#token))
1. **[`requester`](https://hl7.org/fhir/R4/task.html#search)**search parameter
* including support for these **[`_include`](http://hl7.org/fhir/R4/search.html#include)** parameters: `Task:focus`, `Task:owner`, `Task:patient`, and `Task:requester`
* including support for **[`_revinclude`](https://hl7.org/fhir/R4/search.html#revinclude)** parameter: `Task:part-of`
* including support for chained searching of requester canonical identifier `requester.identifier` (e.g. `requester{:Type}.identifier=[system|][code]`)
`GET [base]/Task?requester={Type/}[id]` or optionally `GET [base]/Task?requester{:Type}.identifier=[system|][code]`Example:
1. GET [base]/Task?requester=5678
1. GET [base]/Task?requester:PractitionerRole.identifier=http://ns.electronichealth.net.au/id/medicare-provider-number|553255
1. GET [base]/Task?requester=5678&_include=Task:patient&_include=Task:requester&_include=Task:owner&_include=Task:focus
1. GET [base]/Task?requester=5678&_revinclude=Task:part-of
**Implementation Notes:** Fetches a bundle containing Task resources matching the requester ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference))
1. Combined**[`requester`](https://hl7.org/fhir/R4/task.html#search)**and**[`status`](https://hl7.org/fhir/R4/task.html#search)**search parameters
* including support for these **[`_include`](http://hl7.org/fhir/R4/search.html#include)** parameters: `Task:focus`, `Task:owner`, `Task:patient`, and `Task:requester`
* including support for **[`_revinclude`](https://hl7.org/fhir/R4/search.html#revinclude)** parameter: `Task:part-of`
* including support for chained searching of requester canonical identifier `requester.identifier` (e.g. `requester{:Type}.identifier=[system|][code]`)
* including support for **[`multipleOr`](http://hl7.org/fhir/R4/searchparameter-definitions.html#SearchParameter.multipleOr)** search on `status`
`GET [base]/Task?requester={Type/}[id]&status={system|}[code]{,{system|}[code],...}` or optionally `GET [base]/Task?requester{:Type}.identifier=[system|][code]&status={system|}[code]{,{system|}[code],...}`Example:
1. GET [base]/Task?requester=5678&status=completed
1. GET [base]/Task?requester:PractitionerRole.identifier=http://ns.electronichealth.net.au/id/medicare-provider-number|553255&status=completed
1. GET [base]/Task?requester=5678&status=accepted,in-progress&_include=Task:patient&_include=Task:requester&_include=Task:owner&_include=Task:focus
1. GET [base]/Task?requester=5678&status=completed&_revinclude=Task:part-of
**Implementation Notes:** Fetches a bundle containing Task resources matching the requester and status ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference), [how to search by token](http://hl7.org/fhir/R4/search.html#token))
1. **[`status`](https://hl7.org/fhir/R4/task.html#search)**search parameter
* including support for these **[`_include`](http://hl7.org/fhir/R4/search.html#include)** parameters: `Task:focus`, `Task:owner`, `Task:patient`, and `Task:requester`
* including support for **[`_revinclude`](https://hl7.org/fhir/R4/search.html#revinclude)** parameter: `Task:part-of`
* including support for **[`multipleOr`](http://hl7.org/fhir/R4/searchparameter-definitions.html#SearchParameter.multipleOr)**
`GET [base]/Task?status={system|}[code]{,{system|}[code],...}`Example:
1. GET [base]/Task?status=completed
1. GET [base]/Task?status=accepted,in-progress
1. GET [base]/Task?status=completed&_include=Task:patient&_include=Task:requester&_include=Task:owner&_include=Task:focus
1. GET [base]/Task?status=completed&_revinclude=Task:part-of
**Implementation Notes:** Fetches a bundle containing Task resources matching the status ([how to search by token](http://hl7.org/fhir/R4/search.html#token))



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "au-erequesting-task-group",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org.au/fhir/ereq/ImplementationGuide/hl7.fhir.au.ereq"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-task-group",
  "version" : "1.0.0",
  "name" : "AUeRequestingTaskGroup",
  "title" : "AU eRequesting Task Group",
  "status" : "active",
  "date" : "2026-02-11T06:09:09+00:00",
  "publisher" : "HL7 Australia",
  "contact" : [
    {
      "name" : "HL7 Australia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.hl7.org/display/HAFWG"
        }
      ]
    },
    {
      "name" : "HL7 Australia FHIR Work Group",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.hl7.org/display/HAFWG",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This profile sets minimum expectations for a Task resource that is used to record, search, and fetch information about a group of tasks that are part of the same fulfilment group. It is based on the [AU eRequesting Task](StructureDefinition-au-erequesting-task.html) profile and identifies the additional constraints, extensions, vocabularies and value sets that **SHALL** be present in the Task resource when conforming to this profile.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2024+; Licensed Under Creative Commons No Rights Reserved.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Task",
  "baseDefinition" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-task",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Task",
        "path" : "Task",
        "constraint" : [
          {
            "key" : "au-ereq-taskgr-01",
            "severity" : "error",
            "human" : "Tag 'fulfilment-task' from 'http://terminology.hl7.org.au/CodeSystem/resource-tag' shall not be present.",
            "expression" : "meta.tag.where(system = 'http://terminology.hl7.org.au/CodeSystem/resource-tag' and code = 'fulfilment-task').empty()",
            "source" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-task-group"
          }
        ]
      },
      {
        "id" : "Task.meta.tag:eRequestingFulfilmentTask",
        "path" : "Task.meta.tag",
        "sliceName" : "eRequestingFulfilmentTask",
        "patternCoding" : {
          "system" : "http://terminology.hl7.org.au/CodeSystem/resource-tag",
          "code" : "fulfilment-task-group"
        }
      },
      {
        "id" : "Task.focus",
        "path" : "Task.focus",
        "max" : "0"
      }
    ]
  }
}

```
