# Practitioner - Sallie Losch - AU eRequesting Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Practitioner - Sallie Losch**

## Example Practitioner: Practitioner - Sallie Losch

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU eRequesting Practitioner](StructureDefinition-au-erequesting-practitioner.md)

**identifier**: HPI-I/8003613233384866

**name**: Sallie LOSCH 

**telecom**: ph: 0270104128(Work), [sallie.losch@example.com.au](mailto:sallie.losch@example.com.au)

**address**: 93 Elizabeth Cl Marlowe NSW 2622 

**gender**: Female

### Qualifications

| | | |
| :--- | :--- | :--- |
| - | **Identifier** | **Code** |
| * | Ahpra Registration Number/HAC0000000068 | Ahpra Other Medical Practitioners |



## Resource Content

```json
{
  "resourceType" : "Practitioner",
  "id" : "losch-sallie",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-practitioner"
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "NPI",
            "display" : "National provider identifier"
          }
        ],
        "text" : "HPI-I"
      },
      "system" : "http://ns.electronichealth.net.au/id/hi/hpii/1.0",
      "value" : "8003613233384866"
    }
  ],
  "name" : [
    {
      "family" : "LOSCH",
      "given" : ["Sallie"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "0270104128",
      "use" : "work"
    },
    {
      "system" : "email",
      "value" : "sallie.losch@example.com.au"
    }
  ],
  "address" : [
    {
      "line" : ["93 Elizabeth Cl"],
      "city" : "Marlowe",
      "state" : "NSW",
      "postalCode" : "2622"
    }
  ],
  "gender" : "female",
  "qualification" : [
    {
      "identifier" : [
        {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org.au/CodeSystem/v2-0203",
                "code" : "AHPRA",
                "display" : "Australian Health Practitioner Regulation Agency Registration Number"
              }
            ],
            "text" : "Ahpra Registration Number"
          },
          "system" : "http://hl7.org.au/id/ahpra-registration-number",
          "value" : "HAC0000000068"
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org.au/CodeSystem/v2-0360",
            "code" : "AHPRA",
            "display" : "Ahpra Registration"
          }
        ],
        "text" : "Ahpra Other Medical Practitioners"
      }
    }
  ]
}

```
