# Organization - Elimbah Medical Centre - AU eRequesting Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Organization - Elimbah Medical Centre**

## Example Organization: Organization - Elimbah Medical Centre

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU eRequesting Organization](StructureDefinition-au-erequesting-organization.md)

**identifier**: HPI-O/8003629900040359

**type**: Medical Centre

**name**: Elimbah Medical Centre

**telecom**: [info@elimbahmedicalcentre.example.com.au](mailto:info@elimbahmedicalcentre.example.com.au), ph: (07)555 03997(Work)

**address**: 199 Copper Esp Elimbah QLD 4516 AU 



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "elimbah-medical-centre",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-organization"
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org.au/CodeSystem/v2-0203",
            "code" : "NOI",
            "display" : "National Organisation Identifier"
          }
        ],
        "text" : "HPI-O"
      },
      "system" : "http://ns.electronichealth.net.au/id/hi/hpio/1.0",
      "value" : "8003629900040359"
    }
  ],
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "288565001",
          "display" : "Medical centre"
        }
      ],
      "text" : "Medical Centre"
    }
  ],
  "name" : "Elimbah Medical Centre",
  "telecom" : [
    {
      "system" : "email",
      "value" : "info@elimbahmedicalcentre.example.com.au",
      "use" : "work"
    },
    {
      "system" : "phone",
      "value" : "(07)555 03997",
      "use" : "work"
    }
  ],
  "address" : [
    {
      "line" : ["199 Copper Esp"],
      "city" : "Elimbah",
      "state" : "QLD",
      "postalCode" : "4516",
      "country" : "AU"
    }
  ]
}

```
