# CommunicationRequest - Urgent results communication to provider - AU eRequesting Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **CommunicationRequest - Urgent results communication to provider**

## Example CommunicationRequest: CommunicationRequest - Urgent results communication to provider

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU eRequesting CommunicationRequest Urgent Provider](StructureDefinition-au-erequesting-communicationrequest-urgentprovider.md)

**groupIdentifier**: Placer Group Number/EMC4542244-5624

**status**: Active

**category**: Urgent Results

**priority**: Urgent

**medium**: phone

**subject**: [Fred Roberts Male, DoB: 1961-06-16 ( IHI: Austalian Healthcare Identifier - Individual#8003608500314661)](Patient-roberts-fred.md)

**about**: [ServiceRequest Plain chest X-ray](ServiceRequest-order-xray-1.md)

**authoredOn**: 2024-05-11

**requester**: [PractitionerRole General practitioner](PractitionerRole-generalpractitioner-guthridge-jarred.md)

**recipient**: [PractitionerRole General practitioner](PractitionerRole-generalpractitioner-guthridge-jarred.md)

**sender**: [Organization Mount Charlton Radiology](Organization-mount-charlton-radiology.md)



## Resource Content

```json
{
  "resourceType" : "CommunicationRequest",
  "id" : "communicationrequest-urgent-results-to-provider",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-communicationrequest-urgentprovider"
    ]
  },
  "groupIdentifier" : {
    "type" : {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
          "code" : "PGN",
          "display" : "Placer Group Number"
        }
      ],
      "text" : "Placer Group Number"
    },
    "system" : "http://ns.electronichealth.net.au/id/hpio-scoped/order/1.0/8003629900040359",
    "value" : "EMC4542244-5624",
    "assigner" : {
      "reference" : "Organization/elimbah-medical-centre",
      "display" : "Elimbah Medical Centre"
    }
  },
  "status" : "active",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org.au/CodeSystem/communication-request-category",
          "code" : "urgent-results",
          "display" : "Urgent Results"
        }
      ]
    }
  ],
  "priority" : "urgent",
  "medium" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationMode",
          "code" : "PHONE",
          "display" : "telephone"
        }
      ],
      "text" : "phone"
    }
  ],
  "subject" : {
    "reference" : "Patient/roberts-fred"
  },
  "about" : [
    {
      "reference" : "ServiceRequest/order-xray-1"
    }
  ],
  "authoredOn" : "2024-05-11",
  "requester" : {
    "reference" : "PractitionerRole/generalpractitioner-guthridge-jarred"
  },
  "recipient" : [
    {
      "reference" : "PractitionerRole/generalpractitioner-guthridge-jarred"
    }
  ],
  "sender" : {
    "reference" : "Organization/mount-charlton-radiology"
  }
}

```
