# AU eRequesting Workflow Guidance - AU eRequesting Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Guidance**](guidance.md)
* **AU eRequesting Workflow Guidance**

## AU eRequesting Workflow Guidance

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

In AU eRequesting, a [workflow](https://hl7.org/fhir/R4/workflow.html) pattern using the ServiceRequest and Task resources is used to separate the diagnostic request details from its fulfilment. The ServiceRequest represents the request initiated by placers, while the associated Task is used by fillers for tracking and communicating the progress of the request through the fulfilment workflow.

The current state of a ServiceRequest or Task resource within its defined lifecycle is represented by the code assigned to the status element of the resource. The `ServiceRequest.status` reflects the placer’s overall view of the diagnostic request status, whereas the `Task.status` tracks and conveys the filler’s fulfilment status and the progress in fulfilling the diagnostic request.

This page provides guidance on managing workflow states in AU eRequesting. It covers Task state transitions, the use of supporting elements `Task.statusReason`, `Task.businessStatus`, and `ServiceRequest.extension:statusReason` to provide additional workflow context, and the relationship between Task and ServiceRequest status codes.

### AU eRequesting Task Status Workflow

This section describes how the [AU eRequesting Task Diagnostic Request](StructureDefinition-au-erequesting-task-diagnosticrequest.md) profile is used to track the fulfilment of diagnostic requests in the context of community-based care in Australia. This guidance builds on the [Task state machine](https://hl7.org/fhir/R4/task.html#statemachine), where states are encoded using status codes specified in the [AU eRequesting Task Status](ValueSet-au-erequesting-task-status.md) value set.

#### Task Status Definitions

The [AU eRequesting Task Status](ValueSet-au-erequesting-task-status.md) value set specifies a constrained subset of task status codes used in the Australian eRequesting context.

#### Task State Transitions

The Task state (status) transitions described here reflect the lifecycle of a Task within AU eRequesting workflows for community-based pathology and imaging. These state transitions are intended to guide implementers in supporting consistent and coordinated workflow behaviour. While implementation flexibility can exist to meet business needs and constraints, supporting the suggested states and transitions will help promote interoperability and alignment across systems.

The business rules that define which actors or system roles can modify or trigger changes to `Task.status` are not currently considered within the scope of AU eRequesting Release 1. However, guidance on aligning `ServiceRequest.status` and `Task.status` is provided in [Relationship between ServiceRequest.status and Task.status](#relationship-between-servicerequeststatus-and-taskstatus). 

**Figure 1: AU eRequesting task state transitions**


The table below supplements Figure 1 by providing implementation guidance for AU eRequesting workflows and listing the allowed state transitions.

| | | |
| :--- | :--- | :--- |
| State | Implementation Guidance for AU eRequesting Workflows | Allowed Transitions To State(s) |
| requested | * Tasks start in a "requested" state, indicating a formal request for a diagnostic service that is ready to be fulfilled by a filler.
 | receivedacceptedrejectedcancelled |
| received | * Indicates that the task has been acknowledged and claimed by a filler.
* Some workflows may not distinguish between "received" and "accepted". In such cases, implementations may transition directly from "requested" to "accepted".
 | acceptedrejectedcancelled |
| accepted | * Indicates that a filler has agreed to perform the task.
 | in-progresscancelled |
| rejected | * Indicates that the filler has declined to perform the task before beginning any work.
* Use the optional `Task.statusReason` to provide explanatory context for "rejected".
 | N/A (typically a terminal state) |
| cancelled | * Indicates termination of the task before completion, usually due to an external decision or changed circumstances, rather than an error condition.
* Example scenarios for transitioning to "cancelled": 
* The placer cancels the task.
* The task is cancelled because it has been claimed by an alternative filler.
 
* A task cannot be "cancelled" once it is "in-progress".
* While the intention of a cancelled task is that all work authorised by the task is expected to cease, this may not always be possible. Fulfilment activity may still proceed, and a task output may be generated, even though the task remains in a "cancelled" state.
* Use the optional `Task.statusReason` to provide explanatory context for "cancelled".
 | N/A (typically a terminal state) |
| in-progress | * Once the filler initiates activity on the task, the task transitions to the "in-progress" state, indicating that work is being performed.
* A task cannot be cancelled once it is "in-progress".
 | on-holdcompletedfailed |
| on-hold | * Use the optional `Task.statusReason` to provide explanatory context for "on-hold".
 | in-progress |
| completed | * Once the task has been executed, it transitions to "completed".
 | N/A (typically a terminal state) |
| failed | * Indicates that task execution was attempted but could not be completed due to an error or issue.
* Example scenarios for transitioning to "failed": 
* Patient did not attend.
* Sample was insufficient.
 
* Use the optional `Task.statusReason` to provide explanatory context for "failed".
 | N/A (typically a terminal state) |

#### Task.status and Relationship with Task.statusReason and Task.businessStatus

* Use `Task.status` to represent the current state of the Task. These states are encoded with values from the [AU eRequesting Task Status](ValueSet-au-erequesting-task-status.md) value set.
* Use the optional `Task.statusReason` to explain why the Task transitioned to states such as "rejected", "cancelled", "on-hold", or "failed", providing context for deviations from the expected workflow. 
* There is no defined value set for `Task.statusReason`. When used, this element is expected to carry meaningful data including a human-readable description in `Task.statusReason.text`.
 
* Use the optional `Task.businessStatus` to convey business-specific substates that provide additional workflow context within a `Task.status`. 
* For example, values assigned to `Task.businessStatus` such as "collected", "acquired", or "preliminary" from the [AU eRequesting Task Business Status](ValueSet-au-erequesting-task-businessstatus.md) value set can indicate important workflow milestones while the `Task.status` remains "in-progress".
* Since `Task.businessStatus` serves to augment `Task.status` when further categorisation is useful, `Task.businessStatus` may be omitted if no further categorisation is needed.
 
* When updating the `Task.status`, it is recommended to review and update the `Task.statusReason` and `Task.businessStatus` to maintain alignment. If previously set values are no longer relevant, they are expected to be cleared to avoid propagating outdated or misleading information.

The following table outlines the recommended mapping between [AU eRequesting Task Business Status](ValueSet-au-erequesting-task-businessstatus.md) codes and [AU eRequesting Task Status](ValueSet-au-erequesting-task-status.md) codes, indicating the relationship by which a task business status can convey a business-specific substate providing workflow context to task status. Implementers are encouraged to adopt these mappings to support interoperability, although conformance is not currently enforced. This mapping may be formalised in a future release of this IG.

| | | | |
| :--- | :--- | :--- | :--- |
| Shared (pathology and radiology) | service-booked | Service has been booked. | accepted |
| request-claimed | The task has been cancelled as the request has been claimed by another filler. | cancelled | |
| request-cancelled-placer | The task has been cancelled as the request has been cancelled by the placer. | cancelled | |
| cancel-handled | Cancelled task has been handled by the filler. | cancelled | |
| request-data-issue | Rejected fulfilment task due to an issue with the request data. | rejected | |
| preliminary-results | There are preliminary results. | in-progress | |
| addendum-report-complete | Addendum report is complete. | completed | |
| Pathology | specimen-collected | The specimen has been collected. | in-progress |
| Pathology | pathology-in-lab | Specimen is in a pathology lab. | in-progress |
| Radiology | image-acquired | Image acquisition complete. | in-progress |

#### Relationship Between AU eRequesting Task Group Task.status and AU eRequesting Task Diagnostic Request Task.status

The [AU eRequesting Task Group](StructureDefinition-au-erequesting-task-group.md) is used to represent and coordinate the overall group of requests. It allows the AU eRequesting Filler actor to manage the group as a single coordinated request, supporting fulfilment, progress tracking and status updates across the group. See [Diagnostic Request Grouping](general-guidance.md#diagnostic-request-grouping) guidance for more information.

It is expected that the status of the task group will reflect the most appropriate status among the individual [AU eRequesting Task Diagnostic Request(s)](StructureDefinition-au-erequesting-task-diagnosticrequest.md), however this is not enforced. Changes to other resources, such as `ServiceRequest.status`, cannot be reliably acted on by the filler unless those changes are also reflected in the status of the task group.

### AU eRequesting Diagnostic Request Status

#### Request Status Definitions

The [AU eRequesting RequestStatus](ValueSet-au-erequesting-request-status.md) value set specifies a constrained subset of ServiceRequest status codes used in the Australian eRequesting context.

#### Request States

In AU eRequesting workflows for community-based pathology and imaging, the state (status) of an [AU eRequesting Diagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.md) is managed by the AU eRequesting Placer actor.

The table below provides request state implementation guidance for AU eRequesting workflows.

| | |
| :--- | :--- |
| State | Implementation Guidance for AU eRequesting Workflows |
| active | * Diagnostic requests start in an "active" state.
* Indicates a formal request for a diagnostic service.
 |
| on-hold | * Use the optional `ServiceRequest.extension:statusReason` to provide explanatory context. 
* Given there is no defined value set for `ServiceRequest.extension:statusReason`, when used, include meaningful data with a human-readable description in `ServiceRequest.extension:statusReason.valueCodeableConcept.text`.
 
 |
| revoked | * Indicates the diagnostic request was withdrawn or cancelled by the placer before it was fulfilled.
* Use the optional `ServiceRequest.extension:statusReason` to provide explanatory context. 
* Given there is no defined value set for `ServiceRequest.extension:statusReason`, when used, include meaningful data with a human-readable description in `ServiceRequest.extension:statusReason.valueCodeableConcept.text`.
 
* The placer is expected to transition the corresponding task to "cancelled".
 |
| completed | * Indicates the diagnostic service has been performed and task output provided.
* When the filler sets `Task.status` to "completed", the placer may update `ServiceRequest.status` accordingly.
* Alternatively, the update may occur when the expected output (e.g., results or reports) is received.
 |
| entered-in-error | * Use is recommended only if no activity based on the request has occurred.
* Example scenarios for transitioning to "entered-in-error": 
* Wrong patient selected during order entry.
* Test ordered in error.
 
* Use the optional `ServiceRequest.extension:statusReason` to provide explanatory context. 
* Given there is no defined value set for `ServiceRequest.extension:statusReason`, when used, include meaningful data with a human-readable description in `ServiceRequest.extension:statusReason.valueCodeableConcept.text`.
 
* The placer is expected to transition the corresponding task to "cancelled".
 |

#### Relationship Between ServiceRequest.status and ServiceRequest.extension:statusReason

* Use `ServiceRequest.status` to represent the current state of the [AU eRequesting Diagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.md). These states are encoded using codes from the [AU eRequesting RequestStatus](ValueSet-au-erequesting-request-status.md) value set.
* `ServiceRequest.extension:statusReason` provides optional explanatory context about why the request is in that particular state. It is not typically required for normal progression through the workflow (e.g. from "active" to "completed"), however it is intended to provide business-relevant context in exception scenarios, such as when a request is placed "on-hold", "revoked", or marked "entered-in-error". 
* There is no defined value set for `ServiceRequest.extension:statusReason`. When used, this element is expected to carry meaningful data including a human-readable description in `ServiceRequest.extension:statusReason.valueCodeableConcept.text`.
 

#### Relationship Between ServiceRequest.status and Task.status

* While the [AU eRequesting Diagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.md) and [AU eRequesting Task Diagnostic Request](StructureDefinition-au-erequesting-task-diagnosticrequest.md) are loosely coupled, in practice, changes in `ServiceRequest.status` are expected to be reflected in the corresponding `Task.status` to maintain alignment across resources involved in the workflow. Placers are responsible for managing this alignment, as changes in the diagnostic request status often require corresponding updates in fulfilment management. Failure to maintain this alignment can lead to workflow inconsistencies, such as orphaned tasks or misaligned expectations between placers and fillers.
* Some typical business rules on these status relationships are outlined in the [Request States](#request-states) table above.

