# AU Variance Statement - AU eRequesting Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Guidance**](guidance.md)
* **AU Variance Statement**

## AU Variance Statement

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

This version of the AU eRequesting FHIR IG complies with [Version 1.0 of the HL7 Australia FHIR Work Group AU Variance Requirements](https://hl7.org.au/fhir/HL7%20AU%20Variance%20Requirements%20v1.0.pdf).

HL7 Australia published FHIR implementation guides are required to follow specific publishing requirements:

* **SHOULD** use AU Core profiles
* **SHOULD** use AU Base profiles and extensions
* **SHALL** include an AU Variance Statement page

### Variance from AU Base

This implementation guide has no variance (i.e. fully compliant) from AU Base FHIR Implementation Guide version 6.0.0 ([current](https://hl7.org.au/fhir/6.0.0)):

#### Additionally Profiled Resources

This implementation guide profiles the following resources that are not profiled in AU Base:

* CommunicationRequest 
* [AU eRequesting CommunicationRequest](StructureDefinition-au-erequesting-communicationrequest.md)
* [AU eRequesting CommunicationRequest CopyTo](StructureDefinition-au-erequesting-communicationrequest-copyto.md)
* [AU eRequesting CommunicationRequest Patient](StructureDefinition-au-erequesting-communicationrequest-patient.md)
* [AU eRequesting CommunicationRequest Urgent Provider](StructureDefinition-au-erequesting-communicationrequest-urgentprovider.md)
 
* Consent 
* [AU eRequesting MHR Consent Withdrawal](StructureDefinition-au-erequesting-mhrconsentwithdrawal.md)
 
* DocumentReference 
* [AU eRequesting Clinical Context DocumentReference](StructureDefinition-au-erequesting-clinicalcontext-documentreference.md)
 
* Task 
* [AU eRequesting Task](StructureDefinition-au-erequesting-task.md)
* [AU eRequesting Task Communication Request](StructureDefinition-au-erequesting-task-communicationrequest.md)
* [AU eRequesting Task Diagnostic Request](StructureDefinition-au-erequesting-task-diagnosticrequest.md)
* [AU eRequesting Task Group](StructureDefinition-au-erequesting-task-group.md)
 
* Extension 
* [AU eRequesting Display Sequence](StructureDefinition-au-erequesting-displaysequence.md)
* [AU eRequesting Fasting Precondition](StructureDefinition-au-erequesting-fastingprecondition.md)
 

### Variance from AU Core

This implementation guide has no variance (i.e. fully compliant) from AU Core FHIR Implementation Guide version 2.0.0 ([current](https://hl7.org.au/fhir/core/2.0.0)).

#### Additionally Profiled Resources

This implementation guide profiles the following resources that are not profiled in AU Core:

* CommunicationRequest 
* [AU eRequesting CommunicationRequest](StructureDefinition-au-erequesting-communicationrequest.md)
* [AU eRequesting CommunicationRequest CopyTo](StructureDefinition-au-erequesting-communicationrequest-copyto.md)
* [AU eRequesting CommunicationRequest Patient](StructureDefinition-au-erequesting-communicationrequest-patient.md)
* [AU eRequesting CommunicationRequest Urgent Provider](StructureDefinition-au-erequesting-communicationrequest-urgentprovider.md)
 
* Consent 
* [AU eRequesting MHR Consent Withdrawal](StructureDefinition-au-erequesting-mhrconsentwithdrawal.md)
 
* Coverage 
* [AU eRequesting Coverage](StructureDefinition-au-erequesting-coverage.md)
 
* DocumentReference 
* [AU eRequesting Clinical Context DocumentReference](StructureDefinition-au-erequesting-clinicalcontext-documentreference.md)
 
* ServiceRequest 
* [AU eRequesting Diagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.md)
* [AU eRequesting Imaging Request](StructureDefinition-au-erequesting-servicerequest-imag.md)
* [AU eRequesting Pathology Request](StructureDefinition-au-erequesting-servicerequest-path.md)
 
* Task 
* [AU eRequesting Task](StructureDefinition-au-erequesting-task.md)
* [AU eRequesting Task Communication Request](StructureDefinition-au-erequesting-task-communicationrequest.md)
* [AU eRequesting Task Diagnostic Request](StructureDefinition-au-erequesting-task-diagnosticrequest.md)
* [AU eRequesting Task Group](StructureDefinition-au-erequesting-task-group.md)
 
* Extension 
* [AU eRequesting Display Sequence](StructureDefinition-au-erequesting-displaysequence.md)
* [AU eRequesting Fasting Precondition](StructureDefinition-au-erequesting-fastingprecondition.md)
 

