# Sex and Gender - AU eRequesting Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Guidance**](guidance.md)
* **Sex and Gender**

## Sex and Gender

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

This page addresses how sex and gender related concepts can be structured in FHIR and conformant to AU eRequesting.

AU eRequesting places **Must Support** on some concepts and inherits sex and gender related elements localised in AU Base, which has considered the logical data element models provided by [HL7 International’s Cross Paradigm Implementation Guide: Gender Harmony - Sex and Gender Representation, Edition 1 specification (Gender Harmony IG)](https://hl7.org/xprod/ig/uv/gender-harmony/informative1/). AU Core profiles referenced in AU eRequesting place **Must Support** on some concepts and inherit sex and gender elements localised in AU Base.

The table below provides an overview of the sex and gender concepts that are included in AU eRequesting by definition, or by reference to AU Core or AU Base.

**Legend:**

![](green_checkmark.png) **Supported**: The sex or gender related concept is marked as **Must Support**.

![](orange_checkmark.png) **Localised**: The sex or gender related concept is localised for use in an Australian context but is not marked as **Must Support**.

![](blue_checkmark.png) **Not Localised**: The sex or gender related concept is relevant and not yet localised for use in an Australian context.

![](minus_symbol.png) **Not Applicable**: This sex or gender related concept is not applicable for use with this resource type.

| | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| [AU eRequesting Diagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.md) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](green_checkmark.png) |
| [AU eRequesting Imaging Request](StructureDefinition-au-erequesting-servicerequest-imag.md) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](green_checkmark.png) |
| [AU eRequesting Pathology Request](StructureDefinition-au-erequesting-servicerequest-path.md) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](minus_symbol.png) | ![](green_checkmark.png) |
| [AU eRequestingPatient](StructureDefinition-au-erequesting-patient.md) | ![](green_checkmark.png) | ![](green_checkmark.png) | ![](green_checkmark.png) | ![](green_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) |
| [AU eRequesting Practitioner](StructureDefinition-au-erequesting-practitioner.md) | ![](blue_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](minus_symbol.png) |
| [AU Core RelatedPerson](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-relatedperson.html) | ![](blue_checkmark.png) | ![](green_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](orange_checkmark.png) | ![](minus_symbol.png) |

### Administrative Gender (Patient.gender)

AU eRequesting supports the exchange of Administrative Gender, i.e. the basic `Patient.gender` property, as a **Must Support** element in [AU eRequesting Patient](StructureDefinition-au-erequesting-patient.md). As per AU Base, the `Patient.gender` value **SHALL** be regarded as a Recorded Sex or Gender. AU eRequesting adopts without change, the implementation guidance defined in the [Administrative Gender (Patient.gender)](https://hl7.org.au/fhir/6.0.0/sexgender.html#administrative-gender-patientgender) section of the AU Base [Sex and Gender](https://hl7.org.au/fhir/6.0.0/sexgender.html) page.

### Name to Use (NtU)

AU eRequesting supports the exchange of the Name to Use data element (as defined in the [HL7 Gender Harmony IG](https://hl7.org/xprod/ig/uv/gender-harmony/informative1/)), and `name.use` is a **Must Support** element in [AU eRequesting Patient](StructureDefinition-au-erequesting-patient.md) and in [AU Core RelatedPerson](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-relatedperson.html) (referenced by AU eRequesting). It is important to note that, `name.period` is not a **Must Support** element. AU eRequesting and AU Core adopts without change, the implementation guidance defined in the [Name to Use (NtU)](https://hl7.org.au/fhir/6.0.0/sexgender.html#name-to-use-ntu) section of the AU Base [Sex and Gender](https://hl7.org.au/fhir/6.0.0/sexgender.html) page.

### Pronouns​

AU eRequesting supports the exchange of the Pronouns data element (as defined in the [HL7 Gender Harmony IG](https://hl7.org/xprod/ig/uv/gender-harmony/informative1/)). The [Individual Pronouns](http://hl7.org/fhir/StructureDefinition/individual-pronouns) extension is a **Must Support** element in [AU eRequesting Patient](StructureDefinition-au-erequesting-patient.md), with the value element of the extension constrained to be [Australian Pronouns](https://www.healthterminologies.gov.au/integration/R4/fhir/ValueSet/australian-pronouns-1) ([extensible](http://hl7.org/fhir/R4/terminologies.html#extensible)). AU eRequesting adopts without change, the implementation guidance defined in the [Pronouns](https://hl7.org.au/fhir/6.0.0/sexgender.html#pronouns) section of the AU Base [Sex and Gender](https://hl7.org.au/fhir/6.0.0/sexgender.html) page.

### Gender Identity (GI)

AU eRequesting supports the exchange of the Gender Identity data element (as defined in the [HL7 Gender Harmony IG](https://hl7.org/xprod/ig/uv/gender-harmony/informative1/)). The [Individual Gender Identity](http://hl7.org/fhir/StructureDefinition/individual-genderIdentity) extension is a **Must Support** element in [AU eRequesting Patient](StructureDefinition-au-erequesting-patient.md), with the value element of the extension constrained to be [Gender Identity Response](https://healthterminologies.gov.au/fhir/ValueSet/gender-identity-response-1) ([extensible](http://hl7.org/fhir/R4/terminologies.html#extensible)). AU eRequesting adopts without change, the implementation guidance defined in the [Gender Identity](https://hl7.org.au/fhir/6.0.0/sexgender.html#gender-identity-gi) section of the AU Base [Sex and Gender](https://hl7.org.au/fhir/6.0.0/sexgender.html) page.

### Recorded Sex or Gender

In AU eRequesting profiles, or AU Core profiles referenced by AU eRequesting, Recorded Sex or Gender is not **Must Support**. See the implementation guidance defined in the [Recorded Sex or Gender](https://hl7.org.au/fhir/6.0.0/sexgender.html#recorded-sex-or-gender) section of the AU Base [Sex and Gender](https://hl7.org.au/fhir/6.0.0/sexgender.html) page for more information.

### Sex Assigned at Birth

Sex Assigned at Birth is profiled in AU Core as [AU Core Sex Assigned At Birth](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-rsg-sexassignedab.html). While elements within AU Core Sex Assigned at Birth are **Must Support**, usage of the profile is not **Must Support** in [AU eRequesting Patient](StructureDefinition-au-erequesting-patient.md). The AU Core Sex Assigned at Birth profile provides an implementation of the guidance in the [Sex Assigned at Birth](https://hl7.org.au/fhir/6.0.0/sexgender.html#sex-assigned-at-birth) section of the AU Base [Sex and Gender](https://hl7.org.au/fhir/6.0.0/sexgender.html) page.

### Sex Parameter for Clinical Use (SPCU)

 When implementing Sex Parameter for Clinical Use, implementers should be aware that there is currently no national clinical framework supporting its use. It has not yet been endorsed by the Sparked CDG and has not been included in the AUCDI and AUeReqDI as a clinical concept for national use. 

 The guidance on this page is dependent on the availability of the `intendedClinicalUse` element, added to the SPCU extension in the September 2025 Ballot of the HL7 International FHIR Extensions Pack. 

AU eRequesting supports the exchange of the Sex Parameter for Clinical Use (SPCU) data element (as defined by the [HL7 Gender Harmony IG](https://hl7.org/xprod/ig/uv/gender-harmony/informative1/)). The [Patient Sex Parameter for Clinical Use](http://hl7.org/fhir/extensions/StructureDefinition-patient-sexParameterForClinicalUse.html) extension is a **Must Support** element in [AU eRequesting Diagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.md), [AU eRequesting Imaging Request](StructureDefinition-au-erequesting-servicerequest-imag.md) and [AU eRequesting Pathology Request](StructureDefinition-au-erequesting-servicerequest-path.md) and a maximum of one SPCU value is allowed. The [Patient Sex Parameter for Clinical Use](http://hl7.org/fhir/extensions/StructureDefinition-patient-sexParameterForClinicalUse.html) extension is not a **Must Support** element in [AU eRequesting Patient](StructureDefinition-au-erequesting-patient.md).

The inclusion of an SPCU value indicates that the requester is explicitly providing a sex parameter intended for use in fulfilment of the requested diagnostic service. When it is present in an [AU eRequesting Imaging Request](StructureDefinition-au-erequesting-servicerequest-imag.md) or [AU eRequesting Pathology Request](StructureDefinition-au-erequesting-servicerequest-path.md), it conveys the AU eRequesting Placer's intended SPCU for the diagnostic request and can be relied upon by AU eRequesting Filler to support the requested service.

It is recommended that the clinical context for the SPCU value is also provided (e.g. Use female reference intervals when interpreting results). Clinical context clarifies the intended use of the SPCU, supports accurate interpretation by AU eRequesting Fillers, and reduces ambiguity where the patient's other sex and gender attributes may differ. Clinical context can be included in either the [`comment`](https://hl7.org/fhir/extensions/StructureDefinition-patient-sexParameterForClinicalUse-definitions.html#Extension.extension:comment) or [`intendedClinicalUse`](https://hl7.org/fhir/extensions/StructureDefinition-patient-sexParameterForClinicalUse-definitions.html#Extension.extension:intendedClinicalUse) element.

See the implementation guidance defined in the [Sex Parameter for Clinical Use (SPCU)](https://hl7.org.au/fhir/6.0.0/sexgender.html#sex-parameter-for-clinical-use-spcu) section of the AU Base [Sex and Gender](https://hl7.org.au/fhir/6.0.0/sexgender.html) page.

