# Profiles and Extensions - AU eRequesting Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* **Profiles and Extensions**

## Profiles and Extensions

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

### Profiles

The following profiles have been defined for this implementation guide.

See the [AU eRequesting Profile Relationships](general-guidance.md#au-erequesting-profile-relationships) for an overview of the relationships between profiles.

#### CommunicationRequest

* [AU eRequesting CommunicationRequest](StructureDefinition-au-erequesting-communicationrequest.md) 
* [AU eRequesting CommunicationRequest CopyTo](StructureDefinition-au-erequesting-communicationrequest-copyto.md)
* [AU eRequesting CommunicationRequest Patient](StructureDefinition-au-erequesting-communicationrequest-patient.md)
* [AU eRequesting CommunicationRequest Urgent Provider](StructureDefinition-au-erequesting-communicationrequest-urgentprovider.md)
 

#### Consent

* [AU eRequesting MHR Consent Withdrawal](StructureDefinition-au-erequesting-mhrconsentwithdrawal.md)

#### Coverage

* [AU eRequesting Coverage](StructureDefinition-au-erequesting-coverage.md)

#### DocumentReference

* [AU eRequesting Clinical Context DocumentReference](StructureDefinition-au-erequesting-clinicalcontext-documentreference.md)

#### Encounter

* [AU eRequesting Encounter](StructureDefinition-au-erequesting-encounter.md)

#### Organization

* [AU eRequesting Organization](StructureDefinition-au-erequesting-organization.md)

#### Patient

* [AU eRequesting Patient](StructureDefinition-au-erequesting-patient.md)

#### Practitioner

* [AU eRequesting Practitioner](StructureDefinition-au-erequesting-practitioner.md)

#### PractitionerRole

* [AU eRequesting PractitionerRole](StructureDefinition-au-erequesting-practitionerrole.md)

#### ServiceRequest

* [AU eRequesting Diagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.md) 
* [AU eRequesting Imaging Request](StructureDefinition-au-erequesting-servicerequest-imag.md)
* [AU eRequesting Pathology Request](StructureDefinition-au-erequesting-servicerequest-path.md)
 

#### Task

* [AU eRequesting Task](StructureDefinition-au-erequesting-task.md) 
* [AU eRequesting Task Communication Request](StructureDefinition-au-erequesting-task-communicationrequest.md)
* [AU eRequesting Task Diagnostic Request](StructureDefinition-au-erequesting-task-diagnosticrequest.md)
* [AU eRequesting Task Group](StructureDefinition-au-erequesting-task-group.md)
 

#### Other Profiles Used

In addition to the profiles defined in this implementation guide, the following profiles defined elsewhere are used by AU eRequesting. These profiles are a data type profile for a **Must Support** element in an AU eRequesting profile or are the target of a **Must Support** reference element in an AU eRequesting profile:

* [AU Australian Business Number](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-australianbusinessnumber.html)
* [AU Australian Company Number](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-australiancompanynumber.html)
* [AU Australian Registered Body Number](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-australianregistredbodynumber.html)
* [AU Aphra Registration Number](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-ahpraregistrationnumber.html)
* [AU Care Agency Employee Identifier](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-careagencyemployeeidentifier.html)
* [AU Commonwealth Seniors Health Card Number](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-cwlthseniorshealthcardnumber.html)
* [AU Core Condition](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-condition.html)
* [AU Core Location](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-location.html)
* [AU Core Procedure](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-procedure.html)
* [AU Core RelatedPerson](https://hl7.org.au/fhir/core/2.0.0/StructureDefinition-au-core-relatedperson.html)
* [AU CSP Registration Number](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-cspregistrationnumber.html)
* [AU DVA Number](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-dvanumber.html)
* [AU Employee Number](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-employeenumber.html)
* [AU Health Care Card Number](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-healthcarecardnumber.html)
* [AU HPI-I](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-hpii.html)
* [AU HPI-O](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-hpio.html)
* [AU IHI](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-ihi.html)
* [AU Insurance Member Number](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-insurancemembernumber.html)
* [AU Local Order Identifier](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-localorderidentifier.html)
* [AU Medical Record Number](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-medicalrecordnumber.html)
* [AU Medicare Card Number](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-medicarecardnumber.html)
* [AU Medicare Provider Number](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-medicareprovidernumber.html)
* [AU NATA Accreditation Number](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-nataaccreditationnumber.html)
* [AU National Provider Identifier At Organisation](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-nationalprovideridentifieratorganisation.html)
* [AU PAI-O Identifier](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-paioidentifier.html)
* [AU Patient Internal Identifier](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-pi.html)
* [AU Pensioner Concession Card Number](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-pensionerconcessioncardnumber.html)
* [AU Pharmacy Approval Number](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-pharmacyapprovalnumber.html)
* [AU PBS Prescriber Number](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-pbsprescribernumber.html)
* [Australian Address](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-address.html)
* [Observation Pregnancy - Status (IPS)](https://hl7.org/fhir/uv/ips/STU2/StructureDefinition-Observation-pregnancy-status-uv-ips.html)

### Extensions

All [extensions](http://hl7.org/fhir/R4/extensibility.html) used in this guide are defined as part of this guide, in the FHIR Extensions Pack or [AU Base](https://hl7.org.au/fhir/6.0.0/profiles-and-extensions.html#extensions).

The following extensions are marked with **Must Support** in this implementation guide:

* [AU eRequesting Display Sequence](StructureDefinition-au-erequesting-displaysequence.md) in [AU eRequesting Diagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.md)
* [AU eRequesting Fasting Precondition](StructureDefinition-au-erequesting-fastingprecondition.md) in [AU eRequesting Diagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.md)
* [Australian Indigenous Status](https://hl7.org.au/fhir/6.0.0/StructureDefinition-indigenous-status.html) in [AU eRequesting Patient](StructureDefinition-au-erequesting-patient.md)
* [Individual Pronouns](http://hl7.org/fhir/StructureDefinition/individual-pronouns) in [AU eRequesting Patient](StructureDefinition-au-erequesting-patient.md)
* [Individual Gender Identity](http://hl7.org/fhir/StructureDefinition/individual-genderIdentity) in [AU eRequesting Patient](StructureDefinition-au-erequesting-patient.md)
* [Patient Sex Parameter For Clinical Use](https://hl7.org/fhir/extensions/StructureDefinition-patient-sexParameterForClinicalUse.html) in [AU eRequesting Diagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.md)
* [Request status reason](http://hl7.org/fhir/StructureDefinition/request-statusReason) in [AU eRequesting Diagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.md)

