# Change Log - AU eRequesting Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* **Change Log**

## Change Log

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

### Release 1.0.0

* Publication date: 2026-02-11
* Publication status: Working Standard (Trial Use)
* Based on FHIR version: 4.0.1

This change log documents the significant updates and resolutions implemented from version [1.0.0-ballot](https://hl7.org.au/fhir/ereq/1.0.0-ballot/index.html) to [1.0.0](https://hl7.org.au/fhir/ereq/1.0.0/index.html). The list below includes substantive changes to mandatory and **Must Support** elements inherited from AU Base.

#### Changes in This Version

* added Future Candidate Requirements Under Consideration section to Future of eRequesting page [AU eReq: FHIR-52581](https://jira.hl7.org/browse/FHIR-52581)
* removed Exchange Format Support section from Conformance page [AU eReq: FHIR-52288](https://jira.hl7.org/browse/FHIR-52288)
* added guidance on missing mandatory data to Conformance page [AU eReq: FHIR-52515](https://jira.hl7.org/browse/FHIR-52515)
* added guidance on mandatory element population to SHALL:populate notes in Conformance page [AU eReq: FHIR-52516](https://jira.hl7.org/browse/FHIR-52516)
* [AU eRequesting Clinical Context DocumentReference](StructureDefinition-au-erequesting-clinicalcontext-documentreference.md): 
* added Must Support and LOINC code "107903-7" as patternCodeableConcept to DocumentReference.type, and changed cardinality from 0..1 to 1..1 [AU eReq: FHIR-51765](https://jira.hl7.org/browse/FHIR-51765)
* changed DocumentReference.subject reference target from AU Core Patient to AU eRequesting Patient [AU eReq: FHIR-51874](https://jira.hl7.org/browse/FHIR-51874)
* added Must Support and obligations to DocumentReference.date and DocumentReference.author [AU eReq: FHIR-52520](https://jira.hl7.org/browse/FHIR-52520)
* changed DocumentReference.author reference target to AU Core RelatedPerson, AU eRequesting Organization, AU eRequesting Patient, AU eRequesting Practitioner and AU eRequesting PractitionerRole [AU eReq: FHIR-54168](https://jira.hl7.org/browse/FHIR-54168)
 
* [AU eRequesting CommunicationRequest](StructureDefinition-au-erequesting-communicationrequest.md): 
* changed CommunicationRequest.subject, CommunicationRequest.requester and CommunicationRequest.recipient reference target from AU Core Patient to AU eRequesting Patient [AU eReq: FHIR-51874](https://jira.hl7.org/browse/FHIR-51874)
* removed AU eRequesting Task Group reference target from CommunicationRequest.about [AU eReq: FHIR-52403](https://jira.hl7.org/browse/FHIR-52403)
* changed CommunicationRequest.requester and CommunicationRequest.sender reference target from AU Core Organization to AU eRequesting Organization [AU eReq: FHIR-51874](https://jira.hl7.org/browse/FHIR-51874)
* changed CommunicationRequest.requester and CommunicationRequest.recipient reference target from AU Core PractitionerRole to AU eRequesting PractitionerRole [AU eReq: FHIR-51874](https://jira.hl7.org/browse/FHIR-51874)
* added CommunicationRequest.category value set binding to AU eRequesting CommunicationRequest Category (extensible) and removed Must Support and obligations from CommunicationRequest.reasonCode [AU eReq: FHIR-52409](https://jira.hl7.org/browse/FHIR-52409)
* changed cardinality of CommunicationRequest.groupIdentifier.type.coding from 1..1 to 1..* [AU eReq: FHIR-53527](https://jira.hl7.org/browse/FHIR-53527)
 
* [AU eRequesting CommunicationRequest Category](ValueSet-au-erequesting-communicationrequest-category.md): 
* added new value set [AU eReq: FHIR-52409](https://jira.hl7.org/browse/FHIR-52409)
* changed value set url from http://hl7.org.au/fhir/ereq/ValueSet/au-erequesting-communicationrequest-category to http://terminology.hl7.org.au/ValueSet/au-erequesting-communicationrequest-category [AU eReq: FHIR-53571](https://jira.hl7.org/browse/FHIR-53571)
 
* [AU eRequesting CommunicationRequest CopyTo](StructureDefinition-au-erequesting-communicationrequest-copyto.md): 
* changed CommunicationRequest.requester reference target from AU Core PractitionerRole to AU eRequesting PractitionerRole [AU eReq: FHIR-51874](https://jira.hl7.org/browse/FHIR-51874)
* added CommunicationRequest.category value set binding to AU eRequesting CommunicationRequest Category (extensible) and changed patternCodeableConcept from "notification" to "copyto-reports" [AU eReq: FHIR-52409](https://jira.hl7.org/browse/FHIR-52409)
* removed Must Support, obligations and required pattern from CommunicationRequest.reasonCode [AU eReq: FHIR-52409](https://jira.hl7.org/browse/FHIR-52409)
* changed cardinality of CommunicationRequest.groupIdentifier.type.coding from 1..1 to 1..* [AU eReq: FHIR-53527](https://jira.hl7.org/browse/FHIR-53527)
 
* [AU eRequesting CommunicationRequest Patient](StructureDefinition-au-erequesting-communicationrequest-patient.md): 
* removed usage guidance from profile description and added Usage Scenarios to profile [AU eReq: FHIR-51855](https://jira.hl7.org/browse/FHIR-51855)
* changed CommunicationRequest.recipient reference target from AU Core Patient to AU eRequesting Patient [AU eReq: FHIR-51874](https://jira.hl7.org/browse/FHIR-51874)
* removed AU eRequesting Task Group reference target from CommunicationRequest.about [AU eReq: FHIR-52403](https://jira.hl7.org/browse/FHIR-52403)
* removed cardinality constraint on CommunicationRequest.category.coding, changing it from 1..1 to 1..* [AU eReq: FHIR-52337](https://jira.hl7.org/browse/FHIR-52337)
* changed CommunicationRequest.category value set binding from AU eRequesting Patient Category (required) to AU eRequesting CommunicationRequest Category (extensible), changed cardinality from 1..* to 1..1, and added patternCodeableConcept of "patient-preference" [AU eReq: FHIR-52409](https://jira.hl7.org/browse/FHIR-52409)
* removed Must Support, obligations and required pattern from CommunicationRequest.reasonCode [AU eReq: FHIR-52409](https://jira.hl7.org/browse/FHIR-52409)
* changed cardinality of CommunicationRequest.groupIdentifier.type.coding from 1..1 to 1..* [AU eReq: FHIR-53527](https://jira.hl7.org/browse/FHIR-53527)
 
* [AU eRequesting CommunicationRequest Patient Category](https://hl7.org.au/fhir/ereq/1.0.0-ballot/ValueSet-au-erequesting-communicationrequest-patientcategory.html): 
* deprecated value set [AU eReq: FHIR-52409](https://jira.hl7.org/browse/FHIR-52409)
* removed unreleased value set [AU eReq: FHIR-54178](https://jira.hl7.org/browse/FHIR-54178)
 
* [AU eRequesting CommunicationRequest Patient Medium](ValueSet-au-erequesting-communicationrequest-patientmedium.md): 
* changed value set url from http://hl7.org.au/fhir/ereq/ValueSet/au-erequesting-communicationrequest-patientmedium to http://terminology.hl7.org.au/ValueSet/au-erequesting-communicationrequest-patientmedium [AU eReq: FHIR-53571](https://jira.hl7.org/browse/FHIR-53571)
 
* [AU eRequesting CommunicationRequest Reason](https://hl7.org.au/fhir/ereq/1.0.0-ballot/ValueSet-au-erequesting-communicationrequest-reason.html): 
* deprecated value set [AU eReq: FHIR-52409](https://jira.hl7.org/browse/FHIR-52409)
* removed unreleased value set [AU eReq: FHIR-54178](https://jira.hl7.org/browse/FHIR-54178)
 
* [AU eRequesting CommunicationRequest Urgent Provider](StructureDefinition-au-erequesting-communicationrequest-urgentprovider.md): 
* changed CommunicationRequest.requester and CommunicationRequest.recipient reference target from AU Core PractitionerRole to AU eRequesting PractitionerRole [AU eReq: FHIR-51874](https://jira.hl7.org/browse/FHIR-51874)
* added CommunicationRequest.category value set binding to AU eRequesting CommunicationRequest Category (extensible) and changed patternCodeableConcept from "alert" to "urgent-results" [AU eReq: FHIR-52409](https://jira.hl7.org/browse/FHIR-52409)
* removed Must Support, obligations and required pattern from CommunicationRequest.reasonCode [AU eReq: FHIR-52409](https://jira.hl7.org/browse/FHIR-52409)
* changed cardinality of CommunicationRequest.groupIdentifier.type.coding from 1..1 to 1..* [AU eReq: FHIR-53527](https://jira.hl7.org/browse/FHIR-53527)
 
* [AU eRequesting Coverage](StructureDefinition-au-erequesting-coverage.md): 
* added Must Support and obligations to Coverage.payor and Coverage.beneficiary [AU eReq FHIR-51671](https://jira.hl7.org/browse/FHIR-51671)
* added Must Support, obligations and fixed value constraint 'active' to Coverage.status [AU eReq FHIR-51671](https://jira.hl7.org/browse/FHIR-51671)
* changed Coverage.payor reference target to AU eRequesting Organization, AU eRequesting Patient and AU Core RelatedPerson [AU eReq: FHIR-52522](https://jira.hl7.org/browse/FHIR-52522)
* changed Coverage.beneficiary reference target to AU eRequesting Patient [AU eReq: FHIR-52522](https://jira.hl7.org/browse/FHIR-52522)
* added Must Support and obligations to Coverage.identifier, including profile specific implementation guidance on the population of Coverage.identifier and Coverage.type [AU eReq: FHIR-52407](https://jira.hl7.org/browse/FHIR-52407), [AU eReq: FHIR-52553](https://jira.hl7.org/browse/FHIR-52553)
 
* [AU eRequesting DiagnosticRequest](StructureDefinition-au-erequesting-diagnosticrequest.md): 
* added profile specific implementation guidance on the use of ServiceRequest.occurrenceTiming.repeat.count to represent the number of diagnostic requests to be performed [AU eReq: FHIR-51854](https://jira.hl7.org/browse/FHIR-51854)
* added profile specific implementation guidance on the use of ServiceRequest.encounter to support filler billing [AU eReq: FHIR-52406](https://jira.hl7.org/browse/FHIR-52406)
* removed profiling detail from profile specific implementation guidance on the use of ServiceRequest.supportingInfo [AU eReq: FHIR-52423](https://jira.hl7.org/browse/FHIR-52423)
* removed Must Support and obligations from ServiceRequest.bodySite [AU eReq: FHIR-52356](https://jira.hl7.org/browse/FHIR-52356)
* added Must Support and obligations to ServiceRequest.code.text and ServiceRequest.encounter.reference [AU eReq: FHIR-52362](https://jira.hl7.org/browse/FHIR-52362)
* changed ServiceRequest.subject reference target from AU Core Patient to AU eRequesting Patient [AU eReq: FHIR-51874](https://jira.hl7.org/browse/FHIR-51874)
* removed Must Support and obligations on ServiceRequest.quantity[x] [AU eReq: FHIR-52071](https://jira.hl7.org/browse/FHIR-52071)
* changed ServiceRequest.requester reference target from AU Core PractitionerRole to AU eRequesting PractitionerRole [AU eReq: FHIR-51874](https://jira.hl7.org/browse/FHIR-51874)
* changed ServiceRequest.encounter reference target from AU Core Encounter to AU eRequesting Encounter [AU eReq: FHIR-51874](https://jira.hl7.org/browse/FHIR-51874)
 
* [AU eRequesting Encounter](StructureDefinition-au-erequesting-encounter.md): 
* added new profile, including interaction support [AU eReq: FHIR-51874](https://jira.hl7.org/browse/FHIR-51874)
 
* [AU eRequesting MHR Consent Withdrawal](StructureDefinition-au-erequesting-mhrconsentwithdrawal.md): 
* changed cardinality of Consent.category from 1..* to 1..1 [AU eReq: FHIR-51918](https://jira.hl7.org/browse/FHIR-51918)
* changed Consent.patient and Consent.performer reference target from AU Core Patient to AU eRequesting Patient [AU eReq: FHIR-51874](https://jira.hl7.org/browse/FHIR-51874)
* changed Consent.organization reference target from AU Core Organization to AU eRequesting Organization [AU eReq: FHIR-51874](https://jira.hl7.org/browse/FHIR-51874)
* changed cardinality of Consent.scope.coding, Consent.category.coding, Consent.policyRule.coding and Consent.provision.action.coding from 1..1 to 1..* [AU eReq: FHIR-53527](https://jira.hl7.org/browse/FHIR-53527)
 
* [AU eRequesting Organization](StructureDefinition-au-erequesting-organization.md): 
* added new profile, including interaction support [AU eReq: FHIR-51874](https://jira.hl7.org/browse/FHIR-51874)
 
* [AU eRequesting Pathology Request](StructureDefinition-au-erequesting-servicerequest-path.md): 
* removed Must Support and obligations from ServiceRequest.bodySite [AU eReq: FHIR-52356](https://jira.hl7.org/browse/FHIR-52356)
 
* [AU eRequesting Patient](StructureDefinition-au-erequesting-patient.md): 
* added new profile, including interaction support [AU eReq: FHIR-51874](https://jira.hl7.org/browse/FHIR-51874)
* applied technical correction to invariants inv-pat-1 and inv-pat-2 to ensure terminology validation applies to the correct sub-extension values when multiple extension instances are present [AU Base: FHIR-53536](https://jira.hl7.org/browse/FHIR-53536)
 
* [AU eRequesting Practitioner](StructureDefinition-au-erequesting-practitioner.md): 
* added new profile, including interaction support [AU eReq: FHIR-51874](https://jira.hl7.org/browse/FHIR-51874)
 
* [AU eRequesting PractitionerRole](StructureDefinition-au-erequesting-practitionerrole.md): 
* added new profile, including interaction support [AU eReq: FHIR-51874](https://jira.hl7.org/browse/FHIR-51874)
 
* [AU eRequesting Task](StructureDefinition-au-erequesting-task.md): 
* changed Task.for reference target from AU Core Patient to AU eRequesting Patient [AU eReq: FHIR-51874](https://jira.hl7.org/browse/FHIR-51874)
* changed Task.owner reference target from AU Core Organization to AU eRequesting Organization [AU eReq: FHIR-51874](https://jira.hl7.org/browse/FHIR-51874)
* changed Task.requester reference target from AU Core PractitionerRole to AU eRequesting PractitionerRole [AU eReq: FHIR-51874](https://jira.hl7.org/browse/FHIR-51874)
* added Must Support and TaskCode code "fulfill" as patternCodeableConcept to Task.code, and changed cardinality from 0..1 to 1..1 [AU eReq: FHIR-53230](https://jira.hl7.org/browse/FHIR-53230)
 
* [AU eRequesting Task Communication Request](StructureDefinition-au-erequesting-task-communicationrequest.md): 
* added Must Support and TaskCode code "fulfill" as patternCodeableConcept to Task.code, and changed cardinality from 0..1 to 1..1 [AU eReq: FHIR-53230](https://jira.hl7.org/browse/FHIR-53230)
 
* [AU eRequesting Task Diagnostic Request](StructureDefinition-au-erequesting-task-diagnosticrequest.md): 
* added Must Support and TaskCode code "fulfill" as patternCodeableConcept to Task.code, and changed cardinality from 0..1 to 1..1 [AU eReq: FHIR-53230](https://jira.hl7.org/browse/FHIR-53230)
 
* [AU eRequesting Task Group](StructureDefinition-au-erequesting-task-group.md): 
* added Must Support and TaskCode code "fulfill" as patternCodeableConcept to Task.code, and changed cardinality from 0..1 to 1..1 [AU eReq: FHIR-53230](https://jira.hl7.org/browse/FHIR-53230)
 
* [AU eRequesting Placer CapabilityStatement](CapabilityStatement-au-erequesting-placer.md): 
* added support for transaction interaction as SHOULD [AU eReq: FHIR-52519](https://jira.hl7.org/browse/FHIR-52519)
* added supported formats SHOULD support json and MAY support xml [AU eReq: FHIR-52288](https://jira.hl7.org/browse/FHIR-52288)
* added part-of search parameter and _revinclude support for Task:part-of as MAY for Task [AU eReq: FHIR-51501](https://jira.hl7.org/browse/FHIR-51501)
* added conformance requirements from AU eRequesting Diagnostic Request, AU eRequesting Imaging Request and AU eRequesting Pathology Request profile specific implementation guidance [AU eReq: FHIR-52423](https://jira.hl7.org/browse/FHIR-52423)
* changed AU eRequesting Placer actor requirement in FHIR RESTful Capabilities statement to support all resource profiles required to create and manage diagnostic requests [AU eReq: FHIR-52413](https://jira.hl7.org/browse/FHIR-52413)
* changed interaction expectation for create and update from SHOULD to SHALL for resources with conformance of SHALL [AU eReq: FHIR-52413](https://jira.hl7.org/browse/FHIR-52413)
* added identifier search parameter as MAY for Organization, Patient and Practitioner [AU eReq: FHIR-53548](https://jira.hl7.org/browse/FHIR-53548)
* added identifier search parameter and _include support for PractitionerRole:practitioner and PractitionerRole:organization as MAY for PractitionerRole [AU eReq: FHIR-53548](https://jira.hl7.org/browse/FHIR-53548)
* applied technical correction to add Device resource agreed as Must Support for DocumentReference.author [AU eReq: FHIR-54087](https://jira.hl7.org/browse/FHIR-54087)
 
* [AU eRequesting Filler CapabilityStatement](CapabilityStatement-au-erequesting-filler.md): 
* added support for transaction interaction as SHOULD [AU eReq: FHIR-52519](https://jira.hl7.org/browse/FHIR-52519)
* added supported formats SHOULD support json and MAY support xml [AU eReq: FHIR-52288](https://jira.hl7.org/browse/FHIR-52288)
* added part-of search parameter and _revinclude support for Task:part-of as MAY for Task [AU eReq: FHIR-51501](https://jira.hl7.org/browse/FHIR-51501)
* added conformance requirements from AU eRequesting Diagnostic Request, AU eRequesting Imaging Request and AU eRequesting Pathology Request profile specific implementation guidance [AU eReq: FHIR-52423](https://jira.hl7.org/browse/FHIR-52423)
* changed AU eRequesting Filler actor requirement in FHIR RESTful Capabilities statement to support all resource profiles required for finding and retrieving diagnostic request fulfilments [AU eReq: FHIR-52418](https://jira.hl7.org/browse/FHIR-52418)
* applied technical correction to add Device resource agreed as Must Support for DocumentReference.author [AU eReq: FHIR-54087](https://jira.hl7.org/browse/FHIR-54087)
 
* [AU eRequesting Patient CapabilityStatement](CapabilityStatement-au-erequesting-patient.md): 
* added supported formats SHOULD support json and MAY support xml [AU eReq: FHIR-52288](https://jira.hl7.org/browse/FHIR-52288)
* added part-of search parameter and _revinclude support for Task:part-of as MAY for Task [AU eReq: FHIR-51501](https://jira.hl7.org/browse/FHIR-51501)
* added conformance requirements from AU eRequesting Diagnostic Request, AU eRequesting Imaging Request and AU eRequesting Pathology Request profile specific implementation guidance [AU eReq: FHIR-52423](https://jira.hl7.org/browse/FHIR-52423)
* applied technical correction to add Device resource agreed as Must Support for DocumentReference.author [AU eReq: FHIR-54087](https://jira.hl7.org/browse/FHIR-54087)
 
* [AU eRequesting Server CapabilityStatement](CapabilityStatement-au-erequesting-server.md): 
* added support for transaction interaction as SHOULD [AU eReq: FHIR-52519](https://jira.hl7.org/browse/FHIR-52519)
* added supported formats SHALL support json and SHOULD support xml [AU eReq: FHIR-52288](https://jira.hl7.org/browse/FHIR-52288)
* added part-of search parameter and _revinclude support for Task:part-of as SHALL for Task [AU eReq: FHIR-51501](https://jira.hl7.org/browse/FHIR-51501)
* added conformance requirements from AU eRequesting Diagnostic Request, AU eRequesting Imaging Request and AU eRequesting Pathology Request profile specific implementation guidance [AU eReq: FHIR-52423](https://jira.hl7.org/browse/FHIR-52423)
* clarified AU eRequesting Server actor requirement in FHIR RESTful Capabilities statement to support all resource profiles required for the exchange of diagnostic requests [AU eReq: FHIR-52425](https://jira.hl7.org/browse/FHIR-52425)
* applied technical correction to add Device resource agreed as Must Support for DocumentReference.author [AU eReq: FHIR-54087](https://jira.hl7.org/browse/FHIR-54087)
 

### Release 1.0.0-ballot

* Publication date: 2025-08-04
* Publication status: Ballot for Working Standard
* Based on FHIR version: 4.0.1

This change log documents the significant updates and resolutions implemented from version [0.1.0-ballot](https://hl7.org.au/fhir/ereq/0.1.0-ballot/index.html) to [1.0.0-ballot](https://hl7.org.au/fhir/ereq/1.0.0-ballot/index.html). The list below includes substantive changes to mandatory and **Must Support** elements inherited from AU Base.

#### Changes in This Version

* added [Sex and Gender](https://hl7.org.au/fhir/ereq/1.0.0-ballot/sex-and-gender.html) page to consolidate implementation guidance on sex and gender concepts in AU eRequesting, with references to guidance in AU Core and AU Base [AU eReq: FHIR-47176](https://jira.hl7.org/browse/FHIR-47176), [AU eReq: FHIR-47178](https://jira.hl7.org/browse/FHIR-47178), [AU eReq: FHIR-47182](https://jira.hl7.org/browse/FHIR-47182), [AU eReq: FHIR-47183](https://jira.hl7.org/browse/FHIR-47183), [AU eReq: FHIR-46892](https://jira.hl7.org/browse/FHIR-46892), [AU eReq: FHIR-46896](https://jira.hl7.org/browse/FHIR-46896).
* added Recorded Sex or Gender and Sex Parameter for Clinical Use to the [Sex and Gender](https://hl7.org.au/fhir/ereq/1.0.0-ballot/sex-and-gender.html) page [AU Base: 51408](https://jira.hl7.org/browse/FHIR-51408).
* added to [General Guidance](https://hl7.org.au/fhir/ereq/1.0.0-ballot/general-guidance.html), Diagnostic Request Grouping guidance and general implementation considerations [AU eReq: FHIR-51565](https://jira.hl7.org/browse/FHIR-51565).
* added [AU eRequesting Workflow Guidance](https://hl7.org.au/fhir/ereq/1.0.0-ballot/workflow.html) page [AU eReq: FHIR-51565](https://jira.hl7.org/browse/FHIR-51565)
* added to [General Guidance](https://hl7.org.au/fhir/ereq/1.0.0-ballot/general-guidance.html), reference to AU Base guidance on SNOMED CT Australian Edition [AU eReq: FHIR-51474](https://jira.hl7.org/browse/FHIR-51474).
* added to [General Guidance](https://hl7.org.au/fhir/ereq/1.0.0-ballot/general-guidance.html), re-use of referenced resources [AU eReq: FHIR-52167](https://jira.hl7.org/browse/FHIR-52167).
* added [Security and Privacy](https://hl7.org.au/fhir/ereq/1.0.0-ballot/security.html) page [AU eReq: FHIR-50880](https://jira.hl7.org/browse/FHIR-50880).
* removed RANZCR Radiology Referral ValueSet (RRV) from AU eRequesting (defined in NCTS) [AU eReq: FHIR-51017](https://jira.hl7.org/browse/FHIR-51017).
* moved supporting-info search parameter, added in [AU eReq: FHIR-51005](https://jira.hl7.org/browse/FHIR-51005), to AU Base to support broad implementation [AU eReq: FHIR-51251](https://jira.hl7.org/browse/FHIR-51251).
* moved Communication Request Reason code system, added in [AU eReq: FHIR-50979](https://jira.hl7.org/browse/FHIR-50979), [AU eReq: FHIR-49807](https://jira.hl7.org/browse/FHIR-49807), [AU eReq: FHIR-50230](https://jira.hl7.org/browse/FHIR-50230) and [AU eReq: FHIR-50229](https://jira.hl7.org/browse/FHIR-50229) to AU Base to support broad implementation [AU eReq: FHIR-51348](https://jira.hl7.org/browse/FHIR-51348).
* moved Task Tag code system, added in [AU eReq: FHIR-49718](https://jira.hl7.org/browse/FHIR-49718) to AU Base and renamed to Resource Tag to support broad implementation [AU eReq: FHIR-51349](https://jira.hl7.org/browse/FHIR-51349).
* moved Task Business Status code system, added in [AU eReq: FHIR-50973](https://jira.hl7.org/browse/FHIR-50973) and [AU eReq: FHIR-51006](https://jira.hl7.org/browse/FHIR-51006) to AU Base to support broad implementation [AU eReq: FHIR-51350](https://jira.hl7.org/browse/FHIR-51350).
* [AU eRequesting CommunicationRequest](https://hl7.org.au/fhir/ereq/1.0.0-ballot/StructureDefinition-au-erequesting-communicationrequest.html): 
* added new profile, including interaction support [AU eReq: FHIR-49807](https://jira.hl7.org/browse/FHIR-49807), [AU eReq: FHIR-51636](https://jira.hl7.org/browse/FHIR-51636), [AU eReq: FHIR-51637](https://jira.hl7.org/browse/FHIR-51637)
* changed cardinality of CommunicationRequest.sender from 1..1 to 0..1 [AU eReq: FHIR-51145](https://jira.hl7.org/browse/FHIR-51145)
 
* [AU eRequesting CommunicationRequest CopyTo](https://hl7.org.au/fhir/ereq/1.0.0-ballot/StructureDefinition-au-erequesting-communicationrequest-copyto.html): 
* added new profile, including interaction support [AU eReq: FHIR-49807](https://jira.hl7.org/browse/FHIR-49807), [AU eReq: FHIR-51636](https://jira.hl7.org/browse/FHIR-51636), [AU eReq: FHIR-51637](https://jira.hl7.org/browse/FHIR-51637)
 
* [AU eRequesting CommunicationRequest Patient](https://hl7.org.au/fhir/ereq/1.0.0-ballot/StructureDefinition-au-erequesting-communicationrequest-patient.html): 
* added new profile, including interaction support [AU eReq: FHIR-50230](https://jira.hl7.org/browse/FHIR-50230), [AU eReq: FHIR-51636](https://jira.hl7.org/browse/FHIR-51636), [AU eReq: FHIR-51637](https://jira.hl7.org/browse/FHIR-51637)
* added Must Support and cardinality constraint to CommunicationRequest.subject, changing it from 0..1 to 1..1, and reference target to AU Core Patient [AU eReq: FHIR-50948](https://jira.hl7.org/browse/FHIR-50948)
 
* [AU eRequesting CommunicationRequest Patient Category](https://hl7.org.au/fhir/ereq/1.0.0-ballot/ValueSet-au-erequesting-communicationrequest-patientcategory.html): 
* added new value set [AU eReq: FHIR-50230](https://jira.hl7.org/browse/FHIR-50230)
 
* [AU eRequesting CommunicationRequest Patient Medium](https://hl7.org.au/fhir/ereq/1.0.0-ballot/ValueSet-au-erequesting-communicationrequest-patientmedium.html): 
* added new value set [AU eReq: FHIR-50229](https://jira.hl7.org/browse/FHIR-50229), [AU eReq: FHIR-50230](https://jira.hl7.org/browse/FHIR-50230)
 
* [AU eRequesting CommunicationRequest Reason](https://hl7.org.au/fhir/ereq/1.0.0-ballot/ValueSet-au-erequesting-communicationrequest-reason.html): 
* added new value set [AU eReq: FHIR-49807](https://jira.hl7.org/browse/FHIR-49807), [AU eReq: FHIR-50230](https://jira.hl7.org/browse/FHIR-50230), [AU eReq: FHIR-50229](https://jira.hl7.org/browse/FHIR-50229)
* changed value set definition from AU eRequesting code system to Communication Request Reason code system in AU Base [AU Base: 51348](https://jira.hl7.org/browse/FHIR-51348)
 
* [AU eRequesting CommunicationRequest Urgent Provider](https://hl7.org.au/fhir/ereq/1.0.0-ballot/StructureDefinition-au-erequesting-communicationrequest-urgentprovider.html): 
* added new profile, including interaction support [AU eReq: FHIR-50229](https://jira.hl7.org/browse/FHIR-50229), [AU eReq: FHIR-51636](https://jira.hl7.org/browse/FHIR-51636), [AU eReq: FHIR-51637](https://jira.hl7.org/browse/FHIR-51637)
 
* [AU eRequesting Clinical Context DocumentReference](https://hl7.org.au/fhir/ereq/1.0.0-ballot/StructureDefinition-au-erequesting-clinicalcontext-documentreference.html): 
* added new profile, including interaction support [AU eReq: FHIR-50954](https://jira.hl7.org/browse/FHIR-50954), [AU eReq: FHIR-50955](https://jira.hl7.org/browse/FHIR-50955), [AU eReq: FHIR-51636](https://jira.hl7.org/browse/FHIR-51636), [AU eReq: FHIR-51637](https://jira.hl7.org/browse/FHIR-51637)
 
* [AU eRequesting Coverage](https://hl7.org.au/fhir/ereq/1.0.0-ballot/StructureDefinition-au-erequesting-coverage.html): 
* added new profile [AU eReq: FHIR-46848](https://jira.hl7.org/browse/FHIR-46848)
* added Must Support and cardinality constraint to Coverage.type, changing from 0..1 to 1..1 [AU eReq: FHIR-50899](https://jira.hl7.org/browse/FHIR-50899)
* added default Must Support obligations and interaction support [AU eReq: FHIR-51636](https://jira.hl7.org/browse/FHIR-51636), [AU eReq: FHIR-51637](https://jira.hl7.org/browse/FHIR-51637)
 
* [AU eRequesting Coverage Type and Self-Pay Codes](https://hl7.org.au/fhir/ereq/1.0.0-ballot/ValueSet-au-erequesting-coverage-type.html): 
* added new value set [AU eReq: FHIR-46848](https://jira.hl7.org/browse/FHIR-46848)
 
* [AU eRequesting Fulfilment Task Tags](https://hl7.org.au/fhir/ereq/1.0.0-ballot/ValueSet-au-erequesting-fulfilment-task-tags.html): 
* added new value set [AU eReq: FHIR-49718](https://jira.hl7.org/browse/FHIR-49718), [AU eReq: FHIR-49719](https://jira.hl7.org/browse/FHIR-49719)
 
* [AU eRequesting DiagnosticRequest](https://hl7.org.au/fhir/ereq/1.0.0-ballot/StructureDefinition-au-erequesting-diagnosticrequest.html): 
* AU eRequesting ServiceRequest profile renamed to AU eRequesting Diagnostic Request [AU eReq: FHIR-46842](https://jira.hl7.org/browse/FHIR-46842)
* changed the profile to be abstract [AU eReq: FHIR-46813](https://jira.hl7.org/browse/FHIR-46813)
* changed cardinality of ServiceRequest.encounter from 0..1 to 1..1 [AU eReq: FHIR-47008](https://jira.hl7.org/browse/FHIR-47008)
* changed ServiceRequest.insurance reference target to AU eRequesting Coverage [AU eReq: FHIR-46848](https://jira.hl7.org/browse/FHIR-46848)
* changed base profile from AU Base Diagnostic Request (deprecated) to AU Base Service Request [AU eReq: FHIR-50147](https://jira.hl7.org/browse/FHIR-50147)
* clarified profile-specific implementation guidance on populating ServiceRequest.code [AU eReq: FHIR-46847](https://jira.hl7.org/browse/FHIR-46847)
* changed the obligation requirement for AU eRequesting Filler from SHALL:no-error to SHALL:handle for the following Must Support elements: ServiceRequest.identifier, ServiceRequest.intent, ServiceRequest.insurance, ServiceRequest.encounter and ServiceRequest.reasonCode [AU eReq: FHIR-50976](https://jira.hl7.org/browse/FHIR-50976), [AU eReq: FHIR-51636](https://jira.hl7.org/browse/FHIR-51636), [AU eReq: FHIR-51637](https://jira.hl7.org/browse/FHIR-51637)
* added [Request status reason](http://hl7.org/fhir/StructureDefinition/request-statusReason) extension as a Must Support element with cardinality 0..1 [AU eReq: FHIR-47098](https://jira.hl7.org/browse/FHIR-47098)
* added [Patient Sex Parameter for Clinical Use](http://hl7.org/fhir/StructureDefinition/patient-sexParameterForClinicalUse) extension as Must Support element with cardinality 0..1 [AU eReq: FHIR-46997](https://jira.hl7.org/browse/FHIR-46997)
* added [AU eRequesting Display Sequence](https://hl7.org.au/fhir/ereq/1.0.0-ballot/StructureDefinition-au-erequesting-displaysequence.html) extension as Must Support element with cardinality 1..1 [AU eReq: FHIR-49715](https://jira.hl7.org/browse/FHIR-49715), [AU eReq: FHIR-49716](https://jira.hl7.org/browse/FHIR-49716)
* added [AU eRequesting Fasting Precondition](https://hl7.org.au/fhir/ereq/1.0.0-ballot/StructureDefinition-au-erequesting-fastingprecondition.html) extension as Must Support element with cardinality 0..1 [AU eReq: FHIR-49917](https://jira.hl7.org/browse/FHIR-49917).
* added Must Support to ServiceRequest.occurrence [AU eReq: FHIR-49918](https://jira.hl7.org/browse/FHIR-49918).
* added Must Support to ServiceRequest.quantity and constrain to type Quantity and Range [AU eReq: FHIR-49919](https://jira.hl7.org/browse/FHIR-49919)
* added pregnancyStatus slice to ServiceRequest.supportingInfo as Must Support with cardinality 0..1 referencing Observation Pregnancy - Status (IPS) [AU eReq: FHIR-47006](https://jira.hl7.org/browse/FHIR-47006)
* added clinicalContext slice to ServiceRequest.supportingInfo as Must Support referencing [AU eRequesting Clinical Context DocumentReference](https://hl7.org.au/fhir/ereq/1.0.0-ballot/StructureDefinition-au-erequesting-clinicalcontext-documentreference.html) [AU eReq: FHIR-50956](https://jira.hl7.org/browse/FHIR-50956), [AU eReq: FHIR-50957](https://jira.hl7.org/browse/FHIR-50957)
* added Must Support to ServiceRequest.priority [AU eReq: FHIR-46939](https://jira.hl7.org/browse/FHIR-46939)
* added profile specific implementation guidance on the use of ServiceRequest.supportingInfo for pregnancy status and clinical context [AU eReq: FHIR-51565](https://jira.hl7.org/browse/FHIR-51565)
 
* [AU eRequesting Imaging Request](https://hl7.org.au/fhir/ereq/1.0.0-ballot/StructureDefinition-au-erequesting-servicerequest-imag.html): 
* removed Imaging Procedure additional binding on ServiceRequest.code [AU eReq: FHIR-46847](https://jira.hl7.org/browse/FHIR-46847)
* change RANZCR Radiology Referral ValueSet binding for ServiceRequest.code from AU eRequesting defined ValueSet to the NCTS defined ValueSet [AU eReq: FHIR-51017](https://jira.hl7.org/browse/FHIR-51017)
 
* [AU eRequesting MHR Consent Withdrawal](https://hl7.org.au/fhir/ereq/1.0.0-ballot/StructureDefinition-au-erequesting-mhrconsentwithdrawal.html): 
* added new profile, including interaction support [AU eReq: FHIR-49806](https://jira.hl7.org/browse/FHIR-49806), [AU eReq: FHIR-51636](https://jira.hl7.org/browse/FHIR-51636), [AU eReq: FHIR-51637](https://jira.hl7.org/browse/FHIR-51637)
* added Must Support and cardinality constraints changing Consent.policy from 0..* to 1..1, Consent.policy.authority from 0..1 to 1..1 and Consent.policy.uri from 0..1 to 1..1 [AU eReq: FHIR-51096](https://jira.hl7.org/browse/FHIR-51096)
 
* [AU eRequesting Pathology Request](https://hl7.org.au/fhir/ereq/1.0.0-ballot/StructureDefinition-au-erequesting-servicerequest-path.html): 
* removed Pathology Procedure additional binding on ServiceRequest.code [AU eReq: FHIR-46847](https://jira.hl7.org/browse/FHIR-46847)
 
* [AU eRequesting Patient ActorDefinition](https://hl7.org.au/fhir/ereq/1.0.0-ballot/ActorDefinition-au-erequesting-actor-patient.html): 
* changed AU eRequesting Patient Access actor to AU eRequesting Patient [AU eReq: FHIR-46802](https://jira.hl7.org/browse/FHIR-46802)
 
* [AU eRequesting RequestStatus](https://hl7.org.au/fhir/ereq/1.0.0-ballot/ValueSet-au-erequesting-request-status.html): 
* removed "draft" and "unknown" from value set [AU eReq: FHIR-47097](https://jira.hl7.org/browse/FHIR-47097)
 
* [AU eRequesting Task](https://hl7.org.au/fhir/ereq/1.0.0-ballot/StructureDefinition-au-erequesting-task.html): 
* added new profile, including interaction support [AU eReq: FHIR-46947](https://jira.hl7.org/browse/FHIR-46947), [AU eReq: FHIR-46950](https://jira.hl7.org/browse/FHIR-46950), [AU eReq: FHIR-46956](https://jira.hl7.org/browse/FHIR-46956), [AU eReq: FHIR-46958](https://jira.hl7.org/browse/FHIR-46958), [AU eReq: FHIR-46959](https://jira.hl7.org/browse/FHIR-46959), [AU eReq: FHIR-47081](https://jira.hl7.org/browse/FHIR-47081), [AU eReq: FHIR-47082](https://jira.hl7.org/browse/FHIR-47082), [AU eReq: FHIR-47083](https://jira.hl7.org/browse/FHIR-47083), [AU eReq: FHIR-47084](https://jira.hl7.org/browse/FHIR-47084), [AU eReq: FHIR-47086](https://jira.hl7.org/browse/FHIR-47086), [AU eReq: FHIR-47102](https://jira.hl7.org/browse/FHIR-47102), [AU eReq: FHIR-48915](https://jira.hl7.org/browse/FHIR-48915), [AU eReq: FHIR-51406](https://jira.hl7.org/browse/FHIR-51406), [AU eReq: FHIR-47099](https://jira.hl7.org/browse/FHIR-47099), [AU eReq: FHIR-47089](https://jira.hl7.org/browse/FHIR-47089), [AU eReq: FHIR-47087](https://jira.hl7.org/browse/FHIR-47087), [AU eReq: FHIR-48330](https://jira.hl7.org/browse/FHIR-48330), [AU eReq: FHIR-51636](https://jira.hl7.org/browse/FHIR-51636), [AU eReq: FHIR-51637](https://jira.hl7.org/browse/FHIR-51637)
* added Must Support to Task.meta and Task.meta.tag:eRequestingFulfilmentTask and change cardinality of Task.meta from 0..1 to 1..1 [AU eReq: FHIR-50899](https://jira.hl7.org/browse/FHIR-50899)
* added Must Support to Task.identifier with support for type Identifier and AULocalOrderIdentifier [AU eReq: FHIR-50081](https://jira.hl7.org/browse/FHIR-50081)
* changed to abstract profile [AU eReq: FHIR-49717](https://jira.hl7.org/browse/FHIR-49717)
 
* [AU eRequesting Task Business Status](https://hl7.org.au/fhir/ereq/1.0.0-ballot/ValueSet-au-erequesting-task-businessstatus.html): 
* added new value set [AU eReq: FHIR-50973](https://jira.hl7.org/browse/FHIR-50973)
* changed value set definition from AU eRequesting code system to Task Business Status code system in AU Base [AU Base: 51350](https://jira.hl7.org/browse/FHIR-51350)
 
* [AU eRequesting Task Communication Request](https://hl7.org.au/fhir/ereq/1.0.0-ballot/StructureDefinition-au-erequesting-task-communicationrequest.html): 
* added new profile, including interaction support [AU eReq: FHIR-50231](https://jira.hl7.org/browse/FHIR-50231), [AU eReq: FHIR-51636](https://jira.hl7.org/browse/FHIR-51636), [AU eReq: FHIR-51637](https://jira.hl7.org/browse/FHIR-51637)
 
* [AU eRequesting Task Diagnostic Request](https://hl7.org.au/fhir/ereq/1.0.0-ballot/StructureDefinition-au-erequesting-task-diagnosticrequest.html): 
* added new profile, including interaction support [AU eReq: FHIR-49718](https://jira.hl7.org/browse/FHIR-49718), [AU eReq: FHIR-50275](https://jira.hl7.org/browse/FHIR-50275), [AU eReq: FHIR-51636](https://jira.hl7.org/browse/FHIR-51636), [AU eReq: FHIR-51637](https://jira.hl7.org/browse/FHIR-51637)
 
* [AU eRequesting Task Group](https://hl7.org.au/fhir/ereq/1.0.0-ballot/StructureDefinition-au-erequesting-task-group.html): 
* added new profile, including interaction support [AU eReq: FHIR-49719](https://jira.hl7.org/browse/FHIR-49719), [AU eReq: FHIR-51636](https://jira.hl7.org/browse/FHIR-51636), [AU eReq: FHIR-51637](https://jira.hl7.org/browse/FHIR-51637)
 
* [AU eRequesting Task Status](https://hl7.org.au/fhir/ereq/1.0.0-ballot/ValueSet-au-erequesting-task-status.html): 
* added new value set [AU eReq: FHIR-47081](https://jira.hl7.org/browse/FHIR-47081)
* changed value set definition from AU eRequesting code system to Resource Tag code system in AU Base [AU Base: 51349](https://jira.hl7.org/browse/FHIR-51349)
 
* [AU eRequesting Server CapabilityStatement](https://hl7.org.au/fhir/ereq/1.0.0-ballot/CapabilityStatement-au-erequesting-server.html): 
* added read and search-type interactions as SHALL, and create and update interactions as SHOULD for all currently supported resource types [AU eReq: FHIR-48934](https://jira.hl7.org/browse/FHIR-48934), [AU eReq: FHIR-47145](https://jira.hl7.org/browse/FHIR-47145), [AU eReq: FHIR-47143](https://jira.hl7.org/browse/FHIR-47143) [AU eReq: FHIR-48915](https://jira.hl7.org/browse/FHIR-48915)
* added _id search parameter as SHALL for all currently supported resource types [AU eReq: FHIR-48934](https://jira.hl7.org/browse/FHIR-48934), [AU eReq: FHIR-47145](https://jira.hl7.org/browse/FHIR-47145), [AU eReq: FHIR-48915](https://jira.hl7.org/browse/FHIR-48915)
* added identifier search parameter as SHALL for Organization, Patient, Practitioner, and PractitionerRole [AU eReq: FHIR-48934](https://jira.hl7.org/browse/FHIR-48934), [AU eReq: FHIR-47145](https://jira.hl7.org/browse/FHIR-47145)
* added _include support for PractitionerRole:practitioner and PractitionerRole:organization as SHALL for the PractitionerRole resource type [AU eReq: FHIR-48934](https://jira.hl7.org/browse/FHIR-48934), [AU eReq: FHIR-47145](https://jira.hl7.org/browse/FHIR-47145)
* added _include support for ServiceRequest:patient and ServiceRequest:requester as SHALL and ServiceRequest:encounter as SHOULD for ServiceRequest resource type [AU eReq: FHIR-46942](https://jira.hl7.org/browse/FHIR-46942)
* changed the conformance requirement for ServiceRequest create and update interactions from SHALL to SHOULD [AU eReq: FHIR-47141](https://jira.hl7.org/browse/FHIR-47141)
* changed support for supporting-info search parameter and _include support for ServiceRequest:supporting-info from SHOULD to SHALL for the ServiceRequest resource type [AU eReq: FHIR-51005](https://jira.hl7.org/browse/FHIR-51005), [AU eReq: FHIR-51253](https://jira.hl7.org/browse/FHIR-51253)
* changed the resource conformance requirement from SHOULD to SHALL for the following resource types: Coverage, Encounter, Organization, Practitioner and PractitionerRole [AU eReq: FHIR-50976](https://jira.hl7.org/browse/FHIR-50976)
 
* [AU eRequesting Placer CapabilityStatement](https://hl7.org.au/fhir/ereq/1.0.0-ballot/CapabilityStatement-au-erequesting-placer.html): 
* added create and update interactions as SHOULD for all currently supported resource types [AU eReq: FHIR-47144](https://jira.hl7.org/browse/FHIR-47144)
* added supporting-info search parameter and _include support for ServiceRequest:supporting-info as MAY for ServiceRequest resource type [AU eReq: FHIR-51005](https://jira.hl7.org/browse/FHIR-51005)
* added _include support for ServiceRequest:patient, ServiceRequest:requester and ServiceRequest:encounter as SHOULD for the ServiceRequest resource type [AU eReq: FHIR-46942](https://jira.hl7.org/browse/FHIR-46942)
* added read and search-type interactions as MAY for all supported resource types [AU eReq: FHIR-51636](https://jira.hl7.org/browse/FHIR-51636), [AU eReq: FHIR-51637](https://jira.hl7.org/browse/FHIR-51637)
* added _id search parameter as MAY for Condition, Coverage, DocumentReference, Encounter, Location, Organization, Practitioner, PractitionerRole, Procedure, RelatedPerson and ServiceRequest resource types [AU eReq: FHIR-51636](https://jira.hl7.org/browse/FHIR-51636), [AU eReq: FHIR-51637](https://jira.hl7.org/browse/FHIR-51637)
* changed supported profile conformance from MAY to SHALL for DocumentReference resource type [AU eReq: FHIR-51636](https://jira.hl7.org/browse/FHIR-51636), [AU eReq: FHIR-51637](https://jira.hl7.org/browse/FHIR-51637)
* changed _include support for ServiceRequest:patient, ServiceRequest:requester and ServiceRequest:encounter from SHOULD to MAY [AU eReq: FHIR-50976](https://jira.hl7.org/browse/FHIR-50976)
* changed the resource conformance requirement from SHOULD to SHALL for the following resource types: Coverage, Encounter, Organization, Practitioner and PractitionerRole [AU eReq: FHIR-50976](https://jira.hl7.org/browse/FHIR-50976)
 
* [AU eRequesting Filler CapabilityStatement](https://hl7.org.au/fhir/ereq/1.0.0-ballot/CapabilityStatement-au-erequesting-filler.html): 
* added read and search-type interactions as MAY for all currently supported resource types [AU eReq: FHIR-47144](https://jira.hl7.org/browse/FHIR-47144)
* added _id search parameter as MAY for all currently supported resource types [AU eReq: FHIR-47144](https://jira.hl7.org/browse/FHIR-47144)
* added identifier search parameter as MAY for Organization, Patient, Practitioner, and PractitionerRole resource type [AU eReq: FHIR-48934](https://jira.hl7.org/browse/FHIR-48934), [AU eReq: FHIR-47144](https://jira.hl7.org/browse/FHIR-47144)
* added _include support for PractitionerRole:practitioner and PractitionerRole:organization as MAY for the PractitionerRole resource type [AU eReq: FHIR-48934](https://jira.hl7.org/browse/FHIR-48934), [AU eReq: FHIR-47144](https://jira.hl7.org/browse/FHIR-47144)
* added requisition search parameter as MAY for ServiceRequest resource type [AU eReq: FHIR-47144](https://jira.hl7.org/browse/FHIR-47144)
* added _include support for ServiceRequest:patient, ServiceRequest:requester and ServiceRequest:encounter as SHOULD for ServiceRequest resource type [AU eReq: FHIR-46942](https://jira.hl7.org/browse/FHIR-46942)
* added supporting-info search parameter and _include support for ServiceRequest:supporting-info as MAY for ServiceRequest resource type [AU eReq: FHIR-51005](https://jira.hl7.org/browse/FHIR-51005)
* changed read and search-type interactions from MAY to SHOULD for all supported resource types [AU eReq: FHIR-51636](https://jira.hl7.org/browse/FHIR-51636), [AU eReq: FHIR-51637](https://jira.hl7.org/browse/FHIR-51637)
* changed supported profile conformance from MAY to SHALL for DocumentReference resource type [AU eReq: FHIR-51636](https://jira.hl7.org/browse/FHIR-51636), [AU eReq: FHIR-51637](https://jira.hl7.org/browse/FHIR-51637)
* changed _include support for ServiceRequest:patient, ServiceRequest:requester and ServiceRequest:encounter from SHOULD to MAY [AU eReq: FHIR-50976](https://jira.hl7.org/browse/FHIR-50976)
* changed the resource conformance requirement from SHOULD to SHALL for the following resource types: Coverage, Encounter, Organization, Practitioner and PractitionerRole [AU eReq: FHIR-50976](https://jira.hl7.org/browse/FHIR-50976)
 
* [AU eRequesting Patient CapabilityStatement](https://hl7.org.au/fhir/ereq/1.0.0-ballot/CapabilityStatement-au-erequesting-patient.html): 
* renamed AU eRequesting Patient Access CapabilityStatement to be AU eRequesting Patient [AU eReq: FHIR-46802](https://jira.hl7.org/browse/FHIR-46802)
* added read and search-type interactions as MAY for all currently supported resource types [AU eReq: FHIR-47146](https://jira.hl7.org/browse/FHIR-47146)
* added _id search parameter as MAY for all currently supported resource types [AU eReq: FHIR-47146](https://jira.hl7.org/browse/FHIR-47146)
* added identifier search parameter as MAY for Organization, Patient, Practitioner, and PractitionerRole resource type [AU eReq: FHIR-48934](https://jira.hl7.org/browse/FHIR-48934), [AU eReq: FHIR-47145](https://jira.hl7.org/browse/FHIR-47145)
* added requisition search parameter as MAY for ServiceRequest resource type [AU eReq: FHIR-47146](https://jira.hl7.org/browse/FHIR-47146)
* added _include support for PractitionerRole:practitioner and PractitionerRole:organization as MAY for the PractitionerRole resource type [AU eReq: FHIR-48934](https://jira.hl7.org/browse/FHIR-48934), [AU eReq: FHIR-47145](https://jira.hl7.org/browse/FHIR-47145)
* added supporting-info search parameter and _include support for ServiceRequest:supporting-info as MAY for ServiceRequest resource type [AU eReq: FHIR-51005](https://jira.hl7.org/browse/FHIR-51005)
* added _include support for ServiceRequest:patient, ServiceRequest:requester and ServiceRequest:encounter as SHOULD for the ServiceRequest resource type [AU eReq: FHIR-46942](https://jira.hl7.org/browse/FHIR-46942)
* changed _include support for ServiceRequest:patient, ServiceRequest:requester and ServiceRequest:encounter from SHOULD to MAY [AU eReq: FHIR-50976](https://jira.hl7.org/browse/FHIR-50976).
* changed read and search-type interactions from MAY to SHOULD for all supported resource types [AU eReq: FHIR-51636](https://jira.hl7.org/browse/FHIR-51636), [AU eReq: FHIR-51637](https://jira.hl7.org/browse/FHIR-51637)
* changed the resource conformance requirement from SHOULD to SHALL for the following resource types: Coverage, Encounter, Organization, Practitioner and PractitionerRole [AU eReq: FHIR-50976](https://jira.hl7.org/browse/FHIR-50976)
 

