# Task - Imaging Task Group - AU eRequesting Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Task - Imaging Task Group**

## Example Task: Task - Imaging Task Group

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU eRequesting Task Group](StructureDefinition-au-erequesting-task-group.md)

Tag: fulfilment of a group task (Details: Resource Tag code fulfilment-task-group = 'fulfilment of a group task')

**groupIdentifier**: Placer Group Number/EMC4542244-5624

**status**: Requested

**statusReason**: confirmed booking with Mount Charlton Radiology reception

**businessStatus**: Service booked

**intent**: order

**priority**: Urgent

**code**: Fulfill the focal request

**for**: [Fred Roberts Male, DoB: 1961-06-16 ( IHI: Austalian Healthcare Identifier - Individual#8003608500314661)](Patient-roberts-fred.md)

**authoredOn**: 2024-05-11

**lastModified**: 2024-05-11

**requester**: [PractitionerRole General practitioner](PractitionerRole-generalpractitioner-guthridge-jarred.md)

**owner**: [Organization Mount Charlton Radiology](Organization-mount-charlton-radiology.md)



## Resource Content

```json
{
  "resourceType" : "Task",
  "id" : "taskgroup-imaging-1",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-task-group"
    ],
    "tag" : [
      {
        "system" : "http://terminology.hl7.org.au/CodeSystem/resource-tag",
        "code" : "fulfilment-task-group"
      }
    ]
  },
  "groupIdentifier" : {
    "type" : {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
          "code" : "PGN"
        }
      ],
      "text" : "Placer Group Number"
    },
    "system" : "http://ns.electronichealth.net.au/id/hpio-scoped/order/1.0/8003622500032165",
    "value" : "EMC4542244-5624",
    "assigner" : {
      "reference" : "Organization/elimbah-medical-centre",
      "display" : "Elimbah Medical Centre"
    }
  },
  "status" : "requested",
  "statusReason" : {
    "text" : "confirmed booking with Mount Charlton Radiology reception"
  },
  "businessStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org.au/CodeSystem/task-business-status",
        "code" : "service-booked"
      }
    ]
  },
  "intent" : "order",
  "priority" : "urgent",
  "code" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/CodeSystem/task-code",
        "code" : "fulfill"
      }
    ]
  },
  "for" : {
    "reference" : "Patient/roberts-fred"
  },
  "authoredOn" : "2024-05-11",
  "lastModified" : "2024-05-11",
  "requester" : {
    "reference" : "PractitionerRole/generalpractitioner-guthridge-jarred"
  },
  "owner" : {
    "reference" : "Organization/mount-charlton-radiology"
  }
}

```
