# AU eRequesting Imaging Request - AU eRequesting Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **AU eRequesting Imaging Request**

## Resource Profile: AU eRequesting Imaging Request 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-servicerequest-imag | *Version*:1.0.0 | |
| * Standards status: *[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](https://build.fhir.org/ig/hl7au/au-fhir-base/generalguidance.html#maturity-levels): 1 | *Computable Name*:AUeRequestingImagingRequest |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2024+; Licensed Under Creative Commons No Rights Reserved. | | |

 
This profile sets minimum expectations for a ServiceRequest resource that is used to record, search, and fetch information about diagnostic imaging requests for a patient. It is based on the [AU eRequesting Diagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.md) profile and identifies the additional constraints, extensions, vocabularies and value sets that **SHALL** be present in the ServiceRequest resource when conforming to this profile. 

Work is underway within [RANZCR](https://www.ranzcr.com/) to finalise the development of the Radiology Referral Set (RRS) with the aim of including all radiology procedures performed in Australia. The [RANZCR Radiology Referral](https://www.healthterminologies.gov.au/integration/R4/fhir/ValueSet/ranzcr-radiology-referral-1) value set published in the [NCTS](https://www.healthterminologies.gov.au/integration/R4/fhir) is an evolving draft that is derived from the latest agreed set of concepts from the RRS. Implementers are advised to take note that concepts within the value set will continue to expand and evolve when further iterations of the Radiology Referral Set are available.

### Profile Specific Implementation Guidance

* See [AU eRequesting Diagnostic Request Profile Specific Implementation Guidance](StructureDefinition-au-erequesting-diagnosticrequest.md#profile-specific-implementation-guidance) for general guidance applicable to profiles based on AU eRequesting Diagnostic Request.
* See guidance on the representation of body site and associated laterality in [Representing Body Site, Which May Include Laterality](https://hl7.org.au/fhir/6.0.0/generalguidance.html#representing-body-site-which-may-include-laterality) in AU Base.
* `ServiceRequest.code` 
* The use of coding for the requested exam can vary significantly across systems, filler systems need to understand that they may encounter codes they do not recognise and be prepared to handle those resources appropriately. Placer systems **SHALL** populate `ServiceRequest.code.text` so that fillers can at least display the service requested, even if they do not recognise the code supplied.
* Placer systems **SHALL** adhere to the following order of preference when populating the `ServiceRequest.code`: 
1. A code selected from the[RANZCR Radiology Referral](https://www.healthterminologies.gov.au/integration/R4/fhir/ValueSet/ranzcr-radiology-referral-1)value set is the preferred option
1. A code selected from the SNOMED CT[Imaging Procedure](https://www.healthterminologies.gov.au/integration/R4/fhir/ValueSet/imaging-procedure-1)value set is the second most preferred option
1. A local code is preferred over free text, preferably from a published and accessible FHIR code system​
1. Free text is the least preferred option which should not be used if a local code is known
 
 

> While the current RANZCR Radiology Referral binding is preferred, it is intended that this binding will move to extensible in the future to ensure the consistent coding of eRequests. The approach to strengthened binding will consider a number of factors including, industry adoption and progress on development of the RANZCR Radiology Referral value set, subject to discussion with the Technical Design Group. National registries or exchange networks may make additional conformance requirements around support for nationally agreed value sets, even if this specification does not require their use.

**Usages:**

* Refer to this Profile: [AU eRequesting CommunicationRequest](StructureDefinition-au-erequesting-communicationrequest.md), [AU eRequesting MHR Consent Withdrawal](StructureDefinition-au-erequesting-mhrconsentwithdrawal.md) and [AU eRequesting Task Diagnostic Request](StructureDefinition-au-erequesting-task-diagnosticrequest.md)
* Examples for this Profile: [ServiceRequest/order-obsus-1](ServiceRequest-order-obsus-1.md), [ServiceRequest/order-xray-1](ServiceRequest-order-xray-1.md) and [ServiceRequest/order-xray-2](ServiceRequest-order-xray-2.md)
* CapabilityStatements using this Profile: [AU eRequesting Filler CapabilityStatement](CapabilityStatement-au-erequesting-filler.md), [AU eRequesting Patient CapabilityStatement](CapabilityStatement-au-erequesting-patient.md), [AU eRequesting Placer CapabilityStatement](CapabilityStatement-au-erequesting-placer.md) and [AU eRequesting Server CapabilityStatement](CapabilityStatement-au-erequesting-server.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.au.ereq|current/StructureDefinition/au-erequesting-servicerequest-imag)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-au-erequesting-servicerequest-imag.csv), [Excel](StructureDefinition-au-erequesting-servicerequest-imag.xlsx), [Schematron](StructureDefinition-au-erequesting-servicerequest-imag.sch) 

### Notes:

Below is an overview of the mandatory and optional search parameters and combined search parameters. See the [AU eRequesting CapabilityStatements](capability-statements.md) for a complete list of supported RESTful interactions for this IG.

FHIR search operations are described [here](http://hl7.org/fhir/R4/search.html) and the syntax used to describe AU eRequesting interactions is defined [here](https://hl7.org.au/fhir/core/2.0.0/general-guidance.html#readsearch-syntax).

Any search parameter defined in FHIR may be 'allowed' by the system unless explicitly marked as "**SHALL NOT**".

* Parameter(s): _id
  * Server Conformance: **SHALL**
  * Placer Conformance: **MAY**
  * Filler Conformance: **MAY**
  * Patient Conformance: **MAY**
  * Type(s): `token`
  * Requirements (when used alone or in combination): 
* Parameter(s): requisition
  * Server Conformance: **SHALL**
  * Placer Conformance: **MAY**
  * Filler Conformance: **MAY**
  * Patient Conformance: **MAY**
  * Type(s): `token`
  * Requirements (when used alone or in combination): 
* Parameter(s): supporting-info
  * Server Conformance: **SHALL**
  * Placer Conformance: **MAY**
  * Filler Conformance: **MAY**
  * Patient Conformance: **MAY**
  * Type(s): `reference`
  * Requirements (when used alone or in combination): 
* Parameter(s): _include=ServiceRequest:patient
  * Server Conformance: **SHALL**
  * Placer Conformance: **MAY**
  * Filler Conformance: **MAY**
  * Patient Conformance: **MAY**
  * Type(s): `reference`
  * Requirements (when used alone or in combination): 
* Parameter(s): _include=ServiceRequest:requester
  * Server Conformance: **SHALL**
  * Placer Conformance: **MAY**
  * Filler Conformance: **MAY**
  * Patient Conformance: **MAY**
  * Type(s): `reference`
  * Requirements (when used alone or in combination): 
* Parameter(s): _include=ServiceRequest:supporting-info
  * Server Conformance: **SHALL**
  * Placer Conformance: **MAY**
  * Filler Conformance: **MAY**
  * Patient Conformance: **MAY**
  * Type(s): `reference`
  * Requirements (when used alone or in combination): 
* Parameter(s): _include=ServiceRequest:encounter
  * Server Conformance: **SHOULD**
  * Placer Conformance: **MAY**
  * Filler Conformance: **MAY**
  * Patient Conformance: **MAY**
  * Type(s): `reference`
  * Requirements (when used alone or in combination): 

#### Search Parameters:

The following search parameters and search parameter combinations are supported. Conformance obligations are detailed in the table above.

1. **[`_id`](https://hl7.org/fhir/R4/servicerequest.html#search)**search parameter
* including support for these **[`_include`](http://hl7.org/fhir/R4/search.html#include)** parameters: `ServiceRequest:patient`, `ServiceRequest:requester`, `ServiceRequest:encounter`, `ServiceRequest:supporting-info`
`GET [base]/ServiceRequest?_id=[id]`Example:
1. GET [base]/ServiceRequest?_id=2169591
1. GET [base]/ServiceRequest?_id=2169591&_include=ServiceRequest:patient&_include=ServiceRequest:requester&_include=ServiceRequest:encounter&_include=ServiceRequest:supporting-info
**Implementation Notes:** Fetches a bundle with the requested ServiceRequest, instead of just the resource itself, and allows for the inclusion of additional search parameters such as _include, _revinclude, or _lastUpdated ([how to search by id of the resource](https://hl7.org/fhir/r4/search.html#id))
1. **[`requisition`](https://hl7.org/fhir/R4/servicerequest.html#search)**search parameter
* including support for these **[`_include`](http://hl7.org/fhir/R4/search.html#include)** parameters: `ServiceRequest:patient`, `ServiceRequest:requester`, `ServiceRequest:encounter`, `ServiceRequest:supporting-info`
`GET [base]/ServiceRequest?requisition={system|}[code]`Example:
1. GET [base]/ServiceRequest?requisition=EMC4542244-5624
1. GET [base]/ServiceRequest?requisition=https://elimbahmedicalcentre.example.com.au/orders/order-identifier|EMC4542244-5624
1. GET [base]/ServiceRequest?requisition=EMC4542244-5624&_include=ServiceRequest:patient&_include=ServiceRequest:requester&_include=ServiceRequest:encounter&_include=ServiceRequest:supporting-info
**Implementation Notes:** Fetches a bundle of all ServiceRequest resources for the specified requisition identifier ([how to search by token](https://hl7.org/fhir/R4/search.html#token))
1. **[`supporting-info`](https://hl7.org.au/fhir/6.0.0/SearchParameter-servicerequest-supporting-info.html)**search parameter
* including support for these **[`_include`](http://hl7.org/fhir/R4/search.html#include)** parameters: `ServiceRequest:patient`, `ServiceRequest:requester`, `ServiceRequest:encounter`, `ServiceRequest:supporting-info`
`GET [base]/ServiceRequest?supporting-info={Type/}[id]`Example:
1. GET [base]/ServiceRequest?supporting-info=9876
1. GET [base]/ServiceRequest?supporting-info=Observation/9876
1. GET [base]/ServiceRequest?supporting-info=9876&_include=ServiceRequest:patient&_include=ServiceRequest:requester&_include=ServiceRequest:encounter&_include=ServiceRequest:supporting-info
**Implementation Notes:** Fetches a bundle of all ServiceRequest resources matching the supporting-info ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference))



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "au-erequesting-servicerequest-imag",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org.au/fhir/ereq/ImplementationGuide/hl7.fhir.au.ereq"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-servicerequest-imag",
  "version" : "1.0.0",
  "name" : "AUeRequestingImagingRequest",
  "title" : "AU eRequesting Imaging Request",
  "status" : "active",
  "date" : "2026-02-11T06:09:09+00:00",
  "publisher" : "HL7 Australia",
  "contact" : [
    {
      "name" : "HL7 Australia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.hl7.org/display/HAFWG"
        }
      ]
    },
    {
      "name" : "HL7 Australia FHIR Work Group",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.hl7.org/display/HAFWG",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This profile sets minimum expectations for a ServiceRequest resource that is used to record, search, and fetch information about diagnostic imaging requests for a patient. It is based on the [AU eRequesting Diagnostic Request](StructureDefinition-au-erequesting-diagnosticrequest.html) profile and identifies the additional constraints, extensions, vocabularies and value sets that **SHALL** be present in the ServiceRequest resource when conforming to this profile.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2024+; Licensed Under Creative Commons No Rights Reserved.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "quick",
      "uri" : "http://siframework.org/cqf",
      "name" : "Quality Improvement and Clinical Knowledge (QUICK)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "ServiceRequest",
  "baseDefinition" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-diagnosticrequest",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ServiceRequest",
        "path" : "ServiceRequest",
        "short" : "A diagnostic imaging request",
        "definition" : "A request for a diagnostic imaging service."
      },
      {
        "id" : "ServiceRequest.category",
        "path" : "ServiceRequest.category",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "ServiceRequest.category:imaging",
        "path" : "ServiceRequest.category",
        "sliceName" : "imaging",
        "min" : 1,
        "max" : "1",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "363679005"
            }
          ]
        }
      },
      {
        "id" : "ServiceRequest.code",
        "path" : "ServiceRequest.code",
        "comment" : "Refer to the AU eRequesting Imaging Request Profile Specific Implementation Guidance for `ServiceRequest.code` usage.",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://ranzcr.com/fhir/ValueSet/radiology-referral-1"
        }
      },
      {
        "id" : "ServiceRequest.bodySite",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-placer"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-filler"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-patient"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "ServiceRequest.bodySite",
        "mustSupport" : true
      }
    ]
  }
}

```
