# AU eRequesting CommunicationRequest Patient - AU eRequesting Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **AU eRequesting CommunicationRequest Patient**

## Resource Profile: AU eRequesting CommunicationRequest Patient 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-communicationrequest-patient | *Version*:1.0.0 | |
| * Standards status: *[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](https://build.fhir.org/ig/hl7au/au-fhir-base/generalguidance.html#maturity-levels): 1 | *Computable Name*:AUeRequestingCommunicationRequestPatient |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2024+; Licensed Under Creative Commons No Rights Reserved. | | |

 
This profile sets the minimum expectations for a CommunicationRequest resource used to represent a request for direct communication from a diagnostic provider (filler) to a patient. It is based on the [AU eRequesting CommunicationRequest](StructureDefinition-au-erequesting-communicationrequest.md) profile and identifies the additional constraints, extensions, vocabularies and value sets that **SHALL** be present in the CommunicationRequest when conforming to this profile. 

### Usage Scenarios

The following are example usage scenarios for this profile:

* A request from a practitioner to a diagnostic provider to indicate that the provider communicate with the patient via email, for example when communicating instructions to the patient to prepare for a diagnostic test or make an appointment booking.
* A request from a practitioner to a diagnostic provider to indicate that the provider is not to communicate with the patient via SMS or email.

### Profile Specific Implementation Guidance

* See [AU eRequesting CommunicationRequest Profile Specific Implementation Guidance](StructureDefinition-au-erequesting-communicationrequest.md#profile-specific-implementation-guidance) for general guidance applicable to profiles based on AU eRequesting CommunicationRequest.

**Usages:**

* Refer to this Profile: [AU eRequesting Task Communication Request](StructureDefinition-au-erequesting-task-communicationrequest.md)
* Examples for this Profile: [CommunicationRequest/communicationrequest-donotperform](CommunicationRequest-communicationrequest-donotperform.md) and [CommunicationRequest/communicationrequest-patient-instruction](CommunicationRequest-communicationrequest-patient-instruction.md)
* CapabilityStatements using this Profile: [AU eRequesting Filler CapabilityStatement](CapabilityStatement-au-erequesting-filler.md), [AU eRequesting Patient CapabilityStatement](CapabilityStatement-au-erequesting-patient.md), [AU eRequesting Placer CapabilityStatement](CapabilityStatement-au-erequesting-placer.md) and [AU eRequesting Server CapabilityStatement](CapabilityStatement-au-erequesting-server.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.au.ereq|current/StructureDefinition/au-erequesting-communicationrequest-patient)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-au-erequesting-communicationrequest-patient.csv), [Excel](StructureDefinition-au-erequesting-communicationrequest-patient.xlsx), [Schematron](StructureDefinition-au-erequesting-communicationrequest-patient.sch) 

### Notes:

Below is an overview of the mandatory and optional search parameters and combined search parameters. See the [AU eRequesting CapabilityStatements](capability-statements.md) for a complete list of supported RESTful interactions for this IG.

FHIR search operations are described [here](http://hl7.org/fhir/R4/search.html) and the syntax used to describe AU eRequesting interactions is defined [here](https://hl7.org.au/fhir/core/2.0.0/general-guidance.html#readsearch-syntax).

Any search parameter defined in FHIR may be 'allowed' by the system unless explicitly marked as "**SHALL NOT**".

* Parameter(s): _id
  * Server Conformance: **SHALL**
  * Placer Conformance: **MAY**
  * Filler Conformance: **MAY**
  * Patient Conformance: **MAY**
  * Type(s): `token`
  * Requirements (when used alone or in combination): 

#### Search Parameters:

The following search parameters and search parameter combinations are supported. Conformance obligations are detailed in the table above.

1. **[`_id`](https://hl7.org/fhir/R4/communicationrequest.html#search)** search parameter`GET [base]/CommunicationRequest?_id=[id]`Example:
1. GET [base]/CommunicationRequest?_id=2169591
**Implementation Notes:** Fetches a bundle with the requested CommunicationRequest, instead of just the resource itself, and allows for the inclusion of additional search parameters such as _include, _revinclude, or _lastUpdated ([how to search by id of the resource](https://hl7.org/fhir/r4/search.html#id))



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "au-erequesting-communicationrequest-patient",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org.au/fhir/ereq/ImplementationGuide/hl7.fhir.au.ereq"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-communicationrequest-patient",
  "version" : "1.0.0",
  "name" : "AUeRequestingCommunicationRequestPatient",
  "title" : "AU eRequesting CommunicationRequest Patient",
  "status" : "active",
  "date" : "2026-02-11T06:09:09+00:00",
  "publisher" : "HL7 Australia",
  "contact" : [
    {
      "name" : "HL7 Australia",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.hl7.org/display/HAFWG"
        }
      ]
    },
    {
      "name" : "HL7 Australia FHIR Work Group",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.hl7.org/display/HAFWG",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This profile sets the minimum expectations for a CommunicationRequest resource used to represent a request for direct communication from a diagnostic provider (filler) to a patient. It is based on the [AU eRequesting CommunicationRequest](StructureDefinition-au-erequesting-communicationrequest.html) profile and identifies the additional constraints, extensions, vocabularies and value sets that **SHALL** be present in the CommunicationRequest when conforming to this profile.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2024+; Licensed Under Creative Commons No Rights Reserved.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "CommunicationRequest",
  "baseDefinition" : "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-communicationrequest",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "CommunicationRequest",
        "path" : "CommunicationRequest"
      },
      {
        "id" : "CommunicationRequest.category",
        "path" : "CommunicationRequest.category",
        "max" : "1",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org.au/CodeSystem/communication-request-category",
              "code" : "patient-preference"
            }
          ]
        }
      },
      {
        "id" : "CommunicationRequest.doNotPerform",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-placer"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-filler"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-patient"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "CommunicationRequest.doNotPerform",
        "mustSupport" : true
      },
      {
        "id" : "CommunicationRequest.medium",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-placer"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-filler"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:handle"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-server"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/ereq/ActorDefinition/au-erequesting-actor-patient"
              },
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "CommunicationRequest.medium",
        "min" : 1,
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://terminology.hl7.org.au/ValueSet/au-erequesting-communicationrequest-patientmedium"
        }
      },
      {
        "id" : "CommunicationRequest.about",
        "path" : "CommunicationRequest.about",
        "short" : "Fulfilment task group or diagnostic request the communication is about"
      },
      {
        "id" : "CommunicationRequest.requester",
        "path" : "CommunicationRequest.requester",
        "short" : "Patient, provider or practice requesting the communication (or requesting it not be performed)"
      },
      {
        "id" : "CommunicationRequest.recipient",
        "path" : "CommunicationRequest.recipient",
        "short" : "Patient receiving the communication",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-patient"
            ]
          }
        ]
      }
    ]
  }
}

```
