# PractitionerRole - Pathologist - AU eRequesting Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **PractitionerRole - Pathologist**

## Example PractitionerRole: PractitionerRole - Pathologist

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU eRequesting PractitionerRole](StructureDefinition-au-erequesting-practitionerrole.md)

**identifier**: Medicare Provider Number/2448391X

**practitioner**: [Practitioner Aimee Herbert ](Practitioner-herbert-aimee.md)

**organization**: [Organization Kioma Pathology](Organization-kioma-pathology.md)

**code**: Pathologist

**telecom**: ph: (07) 7010 37 53, [aimee.herbert@kiomapathology.example.net](mailto:aimee.herbert@kiomapathology.example.net)



## Resource Content

```json
{
  "resourceType" : "PractitionerRole",
  "id" : "pathologist-herbert-aimee",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-practitionerrole"
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org.au/CodeSystem/v2-0203",
            "code" : "UPIN",
            "display" : "Medicare Provider Number"
          }
        ],
        "text" : "Medicare Provider Number"
      },
      "system" : "http://ns.electronichealth.net.au/id/medicare-provider-number",
      "value" : "2448391X"
    }
  ],
  "practitioner" : {
    "reference" : "Practitioner/herbert-aimee"
  },
  "organization" : {
    "reference" : "Organization/kioma-pathology"
  },
  "code" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "61207006",
          "display" : "Medical pathologist"
        }
      ],
      "text" : "Pathologist"
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "(07) 7010 37 53"
    },
    {
      "system" : "email",
      "value" : "aimee.herbert@kiomapathology.example.net"
    }
  ]
}

```
