# Patient - Elijah KEN SCOTT - AU eRequesting Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Patient - Elijah KEN SCOTT**

## Example Patient: Patient - Elijah KEN SCOTT

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU eRequesting Patient](StructureDefinition-au-erequesting-patient.md)

Elijah KEN SCOTT (official) Male, DoB: 1986-11-28 ( IHI: Austalian Healthcare Identifier - Individual#8003608333647204)

-------

| | |
| :--- | :--- |
| Other Ids: | * Medicare Number/29545408911
* DVA Number/QX521750
 |
| Contact Detail | * ph: 0270103850(Home)
* ph: 0433952520(Mobile)
* ph: 0270103810(Work)
* 81 Short Cir Gilmore ACT 2905 AU 
 |
| Individual Pronouns: | * value: he/him/his/his/himself
 |
| [Australian Indigenous Status](http://hl7.org.au/fhir/6.0.0/StructureDefinition-indigenous-status.html) | australian-indigenous-status-1: 2 (Torres Strait Islander but not Aboriginal origin) |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "scott-elijah-ken",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-patient"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org.au/fhir/StructureDefinition/indigenous-status",
      "valueCoding" : {
        "system" : "https://healthterminologies.gov.au/fhir/CodeSystem/australian-indigenous-status-1",
        "code" : "2",
        "display" : "Torres Strait Islander but not Aboriginal origin"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/individual-pronouns",
      "extension" : [
        {
          "url" : "value",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://loinc.org",
                "code" : "LA29518-0",
                "display" : "he/him/his/his/himself"
              }
            ]
          }
        }
      ]
    }
  ],
  "identifier" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org.au/fhir/StructureDefinition/ihi-status",
          "valueCoding" : {
            "system" : "https://healthterminologies.gov.au/fhir/CodeSystem/ihi-status-1",
            "code" : "active"
          }
        },
        {
          "url" : "http://hl7.org.au/fhir/StructureDefinition/ihi-record-status",
          "valueCoding" : {
            "system" : "https://healthterminologies.gov.au/fhir/CodeSystem/ihi-record-status-1",
            "code" : "verified",
            "display" : "verified"
          }
        }
      ],
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "NI"
          }
        ],
        "text" : "IHI"
      },
      "system" : "http://ns.electronichealth.net.au/id/hi/ihi/1.0",
      "value" : "8003608333647204"
    },
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MC"
          }
        ],
        "text" : "Medicare Number"
      },
      "system" : "http://ns.electronichealth.net.au/id/medicare-number",
      "value" : "29545408911"
    },
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org.au/CodeSystem/v2-0203",
            "code" : "DVAU",
            "display" : "DVA Number"
          }
        ],
        "text" : "DVA Number"
      },
      "system" : "http://ns.electronichealth.net.au/id/dva",
      "value" : "QX521750"
    }
  ],
  "name" : [
    {
      "use" : "official",
      "family" : "SCOTT",
      "given" : ["Elijah", "KEN"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "0270103850",
      "use" : "home"
    },
    {
      "system" : "phone",
      "value" : "0433952520",
      "use" : "mobile"
    },
    {
      "system" : "phone",
      "value" : "0270103810",
      "use" : "work"
    }
  ],
  "gender" : "male",
  "birthDate" : "1986-11-28",
  "address" : [
    {
      "line" : ["81 Short Cir"],
      "city" : "Gilmore",
      "state" : "ACT",
      "postalCode" : "2905",
      "country" : "AU"
    }
  ]
}

```
