# Patient - Remedios Belger - AU eRequesting Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Patient - Remedios Belger**

## Example Patient: Patient - Remedios Belger

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU eRequesting Patient](StructureDefinition-au-erequesting-patient.md)

Remedios BELGER (official) Female, DoB: 1989-01-04 ( IHI: Austalian Healthcare Identifier - Individual#8003608666976378)

-------

| | |
| :--- | :--- |
| Other Id: | Medicare Number/49516515811 |
| Contact Detail | * ph: 0770109100(Home)
* ph: 0491570159(Mobile)
* ph: 0770103121(Work)
* 200 Ocean Pl Logan Reserve QLD 4133 AU 
 |
| [Australian Indigenous Status](http://hl7.org.au/fhir/6.0.0/StructureDefinition-indigenous-status.html) | australian-indigenous-status-1: 3 (Both Aboriginal and Torres Strait Islander origin) |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "belger-remedios",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-patient"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org.au/fhir/StructureDefinition/indigenous-status",
      "valueCoding" : {
        "system" : "https://healthterminologies.gov.au/fhir/CodeSystem/australian-indigenous-status-1",
        "code" : "3",
        "display" : "Both Aboriginal and Torres Strait Islander origin"
      }
    }
  ],
  "identifier" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org.au/fhir/StructureDefinition/ihi-status",
          "valueCoding" : {
            "system" : "https://healthterminologies.gov.au/fhir/CodeSystem/ihi-status-1",
            "code" : "active"
          }
        },
        {
          "url" : "http://hl7.org.au/fhir/StructureDefinition/ihi-record-status",
          "valueCoding" : {
            "system" : "https://healthterminologies.gov.au/fhir/CodeSystem/ihi-record-status-1",
            "code" : "verified",
            "display" : "verified"
          }
        }
      ],
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "NI"
          }
        ],
        "text" : "IHI"
      },
      "system" : "http://ns.electronichealth.net.au/id/hi/ihi/1.0",
      "value" : "8003608666976378"
    },
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MC"
          }
        ],
        "text" : "Medicare Number"
      },
      "system" : "http://ns.electronichealth.net.au/id/medicare-number",
      "value" : "49516515811"
    }
  ],
  "name" : [
    {
      "use" : "official",
      "family" : "BELGER",
      "given" : ["Remedios"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "0770109100",
      "use" : "home"
    },
    {
      "system" : "phone",
      "value" : "0491570159",
      "use" : "mobile"
    },
    {
      "system" : "phone",
      "value" : "0770103121",
      "use" : "work"
    }
  ],
  "gender" : "female",
  "birthDate" : "1989-01-04",
  "address" : [
    {
      "line" : ["200 Ocean Pl"],
      "city" : "Logan Reserve",
      "state" : "QLD",
      "postalCode" : "4133",
      "country" : "AU"
    }
  ]
}

```
