# Encounter - Consultation - AU eRequesting Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Encounter - Consultation**

## Example Encounter: Encounter - Consultation

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU eRequesting Encounter](StructureDefinition-au-erequesting-encounter.md)

**status**: Finished

**class**: [ActCode: AMB](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActCode.html#v3-ActCode-AMB) (ambulatory)

**serviceType**: General practice service

**subject**: [Fred Roberts Male, DoB: 1961-06-16 ( IHI: Austalian Healthcare Identifier - Individual#8003608500314661)](Patient-roberts-fred.md)

### Participants

| | | |
| :--- | :--- | :--- |
| - | **Type** | **Individual** |
| * | primary performer | [PractitionerRole General practitioner](PractitionerRole-generalpractitioner-guthridge-jarred.md) |

**period**: 2024-05-11 10:15:00+1000 --> 2024-05-11 10:30:00+1000

**serviceProvider**: [Organization Elimbah Medical Centre](Organization-elimbah-medical-centre.md)



## Resource Content

```json
{
  "resourceType" : "Encounter",
  "id" : "gp-consultation",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-encounter"
    ]
  },
  "status" : "finished",
  "class" : {
    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
    "code" : "AMB",
    "display" : "ambulatory"
  },
  "serviceType" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "788007007",
        "display" : "General practice service"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/roberts-fred"
  },
  "participant" : [
    {
      "type" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
              "code" : "PPRF",
              "display" : "primary performer"
            }
          ]
        }
      ],
      "individual" : {
        "reference" : "PractitionerRole/generalpractitioner-guthridge-jarred"
      }
    }
  ],
  "period" : {
    "start" : "2024-05-11T10:15:00+10:00",
    "end" : "2024-05-11T10:30:00+10:00"
  },
  "serviceProvider" : {
    "reference" : "Organization/elimbah-medical-centre"
  }
}

```
