# CommunicationRequest - Copy To GP - AU eRequesting Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartifacts.md)
* [**Artefacts Summary**](artifacts.md)
* **CommunicationRequest - Copy To GP**

## Example CommunicationRequest: CommunicationRequest - Copy To GP

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU eRequesting CommunicationRequest CopyTo](StructureDefinition-au-erequesting-communicationrequest-copyto.md)

**groupIdentifier**: Placer Group Number/EMC1552642-1110

**status**: Active

**category**: Copy To Reports

**subject**: [Remedios BELGER (official) Female, DoB: 1989-01-04 ( IHI: Austalian Healthcare Identifier - Individual#8003608666976378)](Patient-belger-remedios.md)

**about**: 

* [ServiceRequest Fasting blood glucose](ServiceRequest-order-glu-1.md)
* [ServiceRequest Blood typing, ABO, Rho(D) and RBC antibody screening](ServiceRequest-order-bg-abs.md)
* [ServiceRequest Urine microscopy, culture and sensitivities](ServiceRequest-order-urinemcs-1.md)
* [ServiceRequest Serum iron tests](ServiceRequest-order-ironstudies.md)

**authoredOn**: 2025-02-21 08:00:00+1000

**requester**: [PractitionerRole Obstetrician and Gynaecologist](PractitionerRole-obstetrician-losch-sallie.md)

**recipient**: [PractitionerRole General practitioner](PractitionerRole-generalpractitioner-guthridge-jarred.md)

**sender**: [Organization Kioma Pathology](Organization-kioma-pathology.md)



## Resource Content

```json
{
  "resourceType" : "CommunicationRequest",
  "id" : "communicationrequest-copyto-gp",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/ereq/StructureDefinition/au-erequesting-communicationrequest-copyto"
    ]
  },
  "groupIdentifier" : {
    "type" : {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
          "code" : "PGN",
          "display" : "Placer Group Number"
        }
      ],
      "text" : "Placer Group Number"
    },
    "system" : "http://ns.electronichealth.net.au/id/hpio-scoped/order/1.0/8003629900040359",
    "value" : "EMC1552642-1110",
    "assigner" : {
      "reference" : "Organization/elimbah-medical-centre",
      "display" : "Elimbah Medical Centre"
    }
  },
  "status" : "active",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org.au/CodeSystem/communication-request-category",
          "code" : "copyto-reports",
          "display" : "Copy To Reports"
        }
      ]
    }
  ],
  "subject" : {
    "reference" : "Patient/belger-remedios"
  },
  "about" : [
    {
      "reference" : "ServiceRequest/order-glu-1"
    },
    {
      "reference" : "ServiceRequest/order-bg-abs"
    },
    {
      "reference" : "ServiceRequest/order-urinemcs-1"
    },
    {
      "reference" : "ServiceRequest/order-ironstudies"
    }
  ],
  "authoredOn" : "2025-02-21T08:00:00+10:00",
  "requester" : {
    "reference" : "PractitionerRole/obstetrician-losch-sallie"
  },
  "recipient" : [
    {
      "reference" : "PractitionerRole/generalpractitioner-guthridge-jarred"
    }
  ],
  "sender" : {
    "reference" : "Organization/kioma-pathology"
  }
}

```
