# Terminology - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* **Terminology**

## Terminology

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

This page includes the value sets and code systems supported in AU Core.

AU Core does not define any unique terminology FHIR artefacts. Terminology supported in AU Core are published in [AU Base](https://hl7.org.au/fhir/terminology.html), the FHIR standard, [HL7 Terminology (THO)](https://terminology.hl7.org/), or the [National Clinical Terminology Service (NCTS)](https://www.healthterminologies.gov.au/).

Implementers are advised to take note that expansions of value sets visible in this guide may differ from expansions returned with a server using
[HL7 Terminology (THO)](http://terminology.hl7.org)version 6.0.0 or higher.

### Value Sets

The following value sets are supported in AU Core, i.e. bound as [preferred](https://hl7.org/fhir/R4/terminologies.html#preferred) or stronger to a supported element, element slice, or extension in an AU Core profile.

Column attribute descriptions are as follows:

* **ValueSet:** The title of the value set.
* **Profiles and Extensions where used:** The profiles and extensions that reference the value set.
* **Available from:** Where the value set is published.

| | | |
| :--- | :--- | :--- |
| [ActEncounterCode - AU Extended](https://hl7.org.au/fhir/ValueSet-au-v3-ActEncounterCode-extended.html) | [AU Core Encounter](StructureDefinition-au-core-encounter.md) | AU Base |
| [AddressType](https://hl7.org/fhir/R4/valueset-address-type.html) | [AU Core Location](StructureDefinition-au-core-location.md),[AU Core Organization](StructureDefinition-au-core-organization.md),[AU Core Patient](StructureDefinition-au-core-patient.md),[AU Core RelatedPerson](StructureDefinition-au-core-relatedperson.md) | FHIR |
| [AddressUse](https://hl7.org/fhir/R4/valueset-address-use.html) | [AU Core Location](StructureDefinition-au-core-location.md),[AU Core Organization](StructureDefinition-au-core-organization.md),[AU Core Patient](StructureDefinition-au-core-patient.md),[AU Core RelatedPerson](StructureDefinition-au-core-relatedperson.md) | FHIR |
| [AdministrativeGender](https://hl7.org/fhir/R4/valueset-administrative-gender.html) | [AU Core Patient](StructureDefinition-au-core-patient.md) | FHIR |
| [AllergyIntolerance Clinical Status Codes](https://hl7.org/fhir/R4/valueset-allergyintolerance-clinical.html) | [AU Core AllergyIntolerance](StructureDefinition-au-core-allergyintolerance.md) | FHIR |
| [AllergyIntolerance Verification Status Codes](http://hl7.org/fhir/R4/valueset-allergyintolerance-verification.html) | [AU Core AllergyIntolerance](StructureDefinition-au-core-allergyintolerance.md) | FHIR |
| [AllergyIntoleranceSeverity](http://hl7.org/fhir/R4/valueset-reaction-event-severity.html) | [AU Core AllergyIntolerance](StructureDefinition-au-core-allergyintolerance.md) | FHIR |
| [Australian Immunisation Register Vaccine](https://healthterminologies.gov.au/fhir/ValueSet/australian-immunisation-register-vaccine-1) | [AU Core Immunization](StructureDefinition-au-core-immunization.md) | NCTS |
| [Australian Indigenous Status](https://healthterminologies.gov.au/fhir/ValueSet/australian-indigenous-status-1) | [AU Core Patient](StructureDefinition-au-core-patient.md) | NCTS |
| [Australian Medication](https://healthterminologies.gov.au/fhir/ValueSet/australian-medication-1) | [AU Core MedicationRequest](StructureDefinition-au-core-medicationrequest.md),[AU Core MedicationStatement](StructureDefinition-au-core-medicationstatement.md),[AU Core Medication](StructureDefinition-au-core-medication.md) | NCTS |
| [Australian Medicines Terminology Vaccine](https://healthterminologies.gov.au/fhir/ValueSet/amt-vaccine-1) | [AU Core Immunization](StructureDefinition-au-core-immunization.md) | NCTS |
| [Australian Pronouns](https://healthterminologies.gov.au/fhir/ValueSet/australian-pronouns-1) | [Individual Pronouns](http://hl7.org/fhir/StructureDefinition/individual-pronouns) | NCTS |
| [Australian States and Territories](https://healthterminologies.gov.au/fhir/ValueSet/australian-states-territories-2) | [AU Core Location](StructureDefinition-au-core-location.md),[AU Core Organization](StructureDefinition-au-core-organization.md),[AU Core Patient](StructureDefinition-au-core-patient.md),[AU Core RelatedPerson](StructureDefinition-au-core-relatedperson.md) | NCTS |
| [Biological Sex](https://healthterminologies.gov.au/fhir/ValueSet/biological-sex-1) | [AU Core Sex Assigned At Birth](StructureDefinition-au-core-rsg-sexassignedab.md) | NCTS |
| [Body Length Units](https://hl7.org/fhir/R4/valueset-ucum-bodylength.html) | [AU Core Body Height](StructureDefinition-au-core-bodyheight.md),[AU Core Waist Circumference](StructureDefinition-au-core-waistcircum.md) | FHIR |
| [Body Site](https://healthterminologies.gov.au/fhir/ValueSet/body-site-1) | [AU Core Diagnostic Result Observation](StructureDefinition-au-core-diagnosticresult.md),[AU Core MedicationRequest](StructureDefinition-au-core-medicationrequest.md),[AU Core MedicationStatement](StructureDefinition-au-core-medicationstatement.md) | NCTS |
| [Body Temperature Units](https://hl7.org/fhir/R4/valueset-ucum-bodytemp.html) | [AU Core Body Temperature](StructureDefinition-au-core-bodytemp.md) | FHIR |
| [Body Weight Units](https://hl7.org/fhir/R4/valueset-ucum-bodyweight.html) | [AU Core Body Weight](StructureDefinition-au-core-bodyweight.md) | FHIR |
| [Clinical Condition](https://healthterminologies.gov.au/fhir/ValueSet/clinical-condition-1) | [AU Core Condition](StructureDefinition-au-core-condition.md) | NCTS |
| [Clinical Finding](https://healthterminologies.gov.au/fhir/ValueSet/clinical-finding-1) | [AU Core AllergyIntolerance](StructureDefinition-au-core-allergyintolerance.md),[AU Core MedicationRequest](StructureDefinition-au-core-medicationrequest.md),[AU Core MedicationStatement](StructureDefinition-au-core-medicationstatement.md) | NCTS |
| [Clinical Specialty](https://healthterminologies.gov.au/fhir/ValueSet/clinical-specialty-1) | [AU Core PractitionerRole](StructureDefinition-au-core-practitionerrole.md) | NCTS |
| [Common Languages in Australia](https://healthterminologies.gov.au/fhir/ValueSet/common-languages-australia-2) | [AU Core Patient](StructureDefinition-au-core-patient.md) | NCTS |
| [Condition Category Codes](https://hl7.org/fhir/R4/valueset-condition-category.html) | [AU Core Condition](StructureDefinition-au-core-condition.md) | FHIR |
| [Condition Clinical Status Codes](https://hl7.org/fhir/R4/valueset-condition-clinical.html) | [AU Core Condition](StructureDefinition-au-core-condition.md) | FHIR |
| [Condition/Diagnosis Severity](https://hl7.org/fhir/R4/valueset-condition-severity.html) | [AU Core Condition](StructureDefinition-au-core-condition.md) | FHIR |
| [ConditionVerificationStatus](https://hl7.org/fhir/R4/valueset-condition-ver-status.html) | [AU Core Condition](StructureDefinition-au-core-condition.md) | FHIR |
| [ContactPointSystem](https://hl7.org/fhir/R4/valueset-contact-point-system.html) | [AU Core HealthcareService](StructureDefinition-au-core-healthcareservice.md),[AU Core Organization](StructureDefinition-au-core-organization.md),[AU Core Patient](StructureDefinition-au-core-patient.md),[AU Core PractitionerRole](StructureDefinition-au-core-practitionerrole.md),[AU Core RelatedPerson](StructureDefinition-au-core-relatedperson.md) | FHIR |
| [ContactPointUse](https://hl7.org/fhir/R4/valueset-contact-point-use.html) | [AU Core HealthcareService](StructureDefinition-au-core-healthcareservice.md),[AU Core Organization](StructureDefinition-au-core-organization.md),[AU Core Patient](StructureDefinition-au-core-patient.md),[AU Core PractitionerRole](StructureDefinition-au-core-practitionerrole.md),[AU Core RelatedPerson](StructureDefinition-au-core-relatedperson.md) | FHIR |
| [DataAbsentReason](https://hl7.org/fhir/R4/valueset-data-absent-reason.html) | [AU Core Pathology Result Observation](StructureDefinition-au-core-diagnosticresult-path.md),[AU Core Heart Rate](StructureDefinition-au-core-heartrate.md),[AU Core Body Height](StructureDefinition-au-core-bodyheight.md),[AU Core Blood Pressure](StructureDefinition-au-core-bloodpressure.md),[AU Core Respiration Rate](StructureDefinition-au-core-resprate.md),[AU Core Body Weight](StructureDefinition-au-core-bodyweight.md),[AU Core Waist Circumference](StructureDefinition-au-core-waistcircum.md),[AU Core Body Temperature](StructureDefinition-au-core-bodytemp.md),[AU Core Diagnostic Result Observation](StructureDefinition-au-core-diagnosticresult.md),[AU Core Smoking Status](StructureDefinition-au-core-smokingstatus.md) | FHIR |
| [Diagnostic Service Section Codes](http://hl7.org/fhir/R4/valueset-diagnostic-service-sections.html) | [AU Core Diagnostic Result Observation](StructureDefinition-au-core-diagnosticresult.md) | FHIR |
| [DVA Entitlement](https://hl7.org.au/fhir/ValueSet-dva-entitlement.html) | [AU Core Patient](StructureDefinition-au-core-patient.md) | AU Base |
| [EncounterStatus](https://hl7.org/fhir/R4/valueset-encounter-status.html) | [AU Core Encounter](StructureDefinition-au-core-encounter.md) | FHIR |
| [EventStatus](https://hl7.org/fhir/R4/valueset-event-status.html) | [AU Core Procedure](StructureDefinition-au-core-procedure.md) | FHIR |
| [Gender Identity Response](https://healthterminologies.gov.au/fhir/ValueSet/gender-identity-response-1) | [Individual Gender Identity](http://hl7.org/fhir/StructureDefinition/individual-genderIdentity) | NCTS |
| [Healthcare Organisation Role Type](https://healthterminologies.gov.au/fhir/ValueSet/healthcare-organisation-role-type-1) | [AU Core Organization](StructureDefinition-au-core-organization.md) | NCTS |
| [hl7VS-identifierType - AU Extended](https://hl7.org.au/fhir/ValueSet-au-v2-0203-extended.html) | [AU Core Organization](StructureDefinition-au-core-organization.md) | AU Base |
| [IdentifierUse](https://hl7.org/fhir/R4/valueset-identifier-use.html) | [AU Core Organization](StructureDefinition-au-core-organization.md),[AU Core Patient](StructureDefinition-au-core-patient.md),[AU Core Practitioner](StructureDefinition-au-core-practitioner.md),[AU Core PractitionerRole](StructureDefinition-au-core-practitionerrole.md) | FHIR |
| [Immunization Status Codes](https://hl7.org/fhir/R4/valueset-immunization-status.html) | [AU Core Immunization](StructureDefinition-au-core-immunization.md) | FHIR |
| [Indicator of Hypersensitivity or Intolerance to Substance](https://healthterminologies.gov.au/fhir/ValueSet/indicator-hypersensitivity-intolerance-to-substance-2) | [AU Core AllergyIntolerance](StructureDefinition-au-core-allergyintolerance.md) | NCTS |
| [Individual Healthcare Identifier Record Status](https://healthterminologies.gov.au/fhir/ValueSet/ihi-record-status-1) | [AU Core Patient](StructureDefinition-au-core-patient.md) | NCTS |
| [Individual Healthcare Identifier Status](https://healthterminologies.gov.au/fhir/ValueSet/ihi-status-1) | [AU Core Patient](StructureDefinition-au-core-patient.md) | NCTS |
| [Location Type (Physical) - AU Extended](https://hl7.org.au/fhir/ValueSet-au-location-physical-type-extended.html) | [AU Core Location](StructureDefinition-au-core-location.md) | AU Base |
| [Medication Reason Taken](https://healthterminologies.gov.au/fhir/ValueSet/medication-reason-taken-1) | [AU Core MedicationStatement](StructureDefinition-au-core-medicationstatement.md) | NCTS |
| [Medication request intent](https://hl7.org/fhir/R4/valueset-medicationrequest-intent.html) | [AU Core MedicationRequest](StructureDefinition-au-core-medicationrequest.md) | FHIR |
| [Medication status codes](https://hl7.org/fhir/R4/valueset-medication-statement-status.html) | [AU Core MedicationStatement](StructureDefinition-au-core-medicationstatement.md) | FHIR |
| [Medicationrequest status](https://hl7.org/fhir/R4/valueset-medicationrequest-status.html) | [AU Core MedicationRequest](StructureDefinition-au-core-medicationrequest.md) | FHIR |
| [NameUse](https://hl7.org/fhir/R4/valueset-name-use.html) | [AU Core Patient](StructureDefinition-au-core-patient.md),[AU Core Practitioner](StructureDefinition-au-core-practitioner.md),[AU Core RelatedPerson](StructureDefinition-au-core-relatedperson.md) | FHIR |
| [Observation Category Codes](https://hl7.org/fhir/R4/valueset-observation-category.html) | [AU Core Pathology Result Observation](StructureDefinition-au-core-diagnosticresult-path.md),[AU Core Heart Rate](StructureDefinition-au-core-heartrate.md),[AU Core Body Height](StructureDefinition-au-core-bodyheight.md),[AU Core Blood Pressure](StructureDefinition-au-core-bloodpressure.md),[AU Core Respiration Rate](StructureDefinition-au-core-resprate.md),[AU Core Body Weight](StructureDefinition-au-core-bodyweight.md),[AU Core Waist Circumference](StructureDefinition-au-core-waistcircum.md),[AU Core Body Temperature](StructureDefinition-au-core-bodytemp.md),[AU Core Diagnostic Result Observation](StructureDefinition-au-core-diagnosticresult.md),[AU Core Smoking Status](StructureDefinition-au-core-smokingstatus.md) | FHIR |
| [Observation Interpretation Codes](https://hl7.org/fhir/R4/valueset-observation-interpretation.html) | [AU Core Pathology Result Observation](StructureDefinition-au-core-diagnosticresult-path.md) | FHIR |
| [Observation Reference Range Meaning Codes](https://hl7.org/fhir/R4/valueset-referencerange-meaning.html) | [AU Core Pathology Result Observation](StructureDefinition-au-core-diagnosticresult-path.md),[AU Core Diagnostic Result Observation](StructureDefinition-au-core-diagnosticresult.md) | FHIR |
| [ObservationStatus](http://hl7.org/fhir/R4/valueset-observation-status.html) | [AU Core Blood Pressure](StructureDefinition-au-core-bloodpressure.md),[AU Core Body Height](StructureDefinition-au-core-bodyheight.md),[AU Core Body Temperature](StructureDefinition-au-core-bodytemp.md),[AU Core Body Weight](StructureDefinition-au-core-bodyweight.md),[AU Core Diagnostic Result Observation](StructureDefinition-au-core-diagnosticresult.md),[AU Core Heart Rate](StructureDefinition-au-core-heartrate.md),[AU Core Pathology Result Observation](StructureDefinition-au-core-diagnosticresult-path.md),[AU Core Respiration Rate](StructureDefinition-au-core-resprate.md),[AU Core Smoking Status](StructureDefinition-au-core-smokingstatus.md),[AU Core Waist Circumference](StructureDefinition-au-core-waistcircum.md) | FHIR |
| [Participant type](https://hl7.org/fhir/R4/valueset-encounter-participant-type.html) | [AU Core Encounter](StructureDefinition-au-core-encounter.md) | FHIR |
| [Pathology Diagnostic Service Category](https://healthterminologies.gov.au/fhir/ValueSet/pathology-diagnostic-service-category-1) | [AU Core Pathology Result Observation](StructureDefinition-au-core-diagnosticresult-path.md) | NCTS |
| [PBS Item Codes](https://hl7.org.au/fhir/ValueSet-pbs-item.html) | [AU Core MedicationRequest](StructureDefinition-au-core-medicationrequest.md),[AU Core MedicationStatement](StructureDefinition-au-core-medicationstatement.md),[AU Core Medication](StructureDefinition-au-core-medication.md) | AU Base |
| [Practitioner Role](https://healthterminologies.gov.au/fhir/ValueSet/practitioner-role-1) | [AU Core PractitionerRole](StructureDefinition-au-core-practitionerrole.md) | NCTS |
| [Procedure](https://healthterminologies.gov.au/fhir/ValueSet/procedure-1) | [AU Core Procedure](StructureDefinition-au-core-procedure.md) | NCTS |
| [QuantityComparator](https://hl7.org/fhir/R4/valueset-quantity-comparator.html) | [AU Core Blood Pressure](StructureDefinition-au-core-bloodpressure.md),[AU Core Body Height](StructureDefinition-au-core-bodyheight.md),[AU Core Body Temperature](StructureDefinition-au-core-bodytemp.md),[AU Core Body Weight](StructureDefinition-au-core-bodyweight.md),[AU Core Diagnostic Result Observation](StructureDefinition-au-core-diagnosticresult.md),[AU Core Heart Rate](StructureDefinition-au-core-heartrate.md),[AU Core Pathology Result Observation](StructureDefinition-au-core-diagnosticresult-path.md),[AU Core Respiration Rate](StructureDefinition-au-core-resprate.md),[AU Core Waist Circumference](StructureDefinition-au-core-waistcircum.md) | FHIR |
| [RCPA SPIA Pathology Reporting](https://healthterminologies.gov.au/fhir/ValueSet/spia-pathology-reporting-1) | [AU Core Pathology Result Observation](StructureDefinition-au-core-diagnosticresult-path.md) | NCTS |
| [Reason For Encounter](https://healthterminologies.gov.au/fhir/ValueSet/reason-for-encounter-1) | [AU Core Encounter](StructureDefinition-au-core-encounter.md) | NCTS |
| [Reason For Request](https://healthterminologies.gov.au/fhir/ValueSet/reason-for-request-1) | [AU Core MedicationRequest](StructureDefinition-au-core-medicationrequest.md) | NCTS |
| [Related Person Relationship Type](https://healthterminologies.gov.au/fhir/ValueSet/related-person-relationship-type-1) | [AU Core RelatedPerson](StructureDefinition-au-core-relatedperson.md) | NCTS |
| [Route of Administration](https://healthterminologies.gov.au/fhir/ValueSet/route-of-administration-1) | [AU Core MedicationRequest](StructureDefinition-au-core-medicationrequest.md),[AU Core MedicationStatement](StructureDefinition-au-core-medicationstatement.md) | NCTS |
| [Service Type](https://healthterminologies.gov.au/fhir/ValueSet/service-type-1) | [AU Core Encounter](StructureDefinition-au-core-encounter.md),[AU Core HealthcareService](StructureDefinition-au-core-healthcareservice.md) | NCTS |
| [ServiceDeliveryLocationRoleType - AU Extended](https://hl7.org.au/fhir/ValueSet-au-v3-ServiceDeliveryLocationRoleType-extended.html) | [AU Core Location](StructureDefinition-au-core-location.md) | AU Base |
| [Smoking Status](https://healthterminologies.gov.au/fhir/ValueSet/smoking-status-1) | [AU Core Smoking Status](StructureDefinition-au-core-smokingstatus.md) | NCTS |
| [SNOMED CT Additional Dosage Instructions](https://hl7.org/fhir/R4/valueset-additional-instruction-codes.html) | [AU Core MedicationRequest](StructureDefinition-au-core-medicationrequest.md),[AU Core MedicationStatement](StructureDefinition-au-core-medicationstatement.md) | FHIR |
| [SNOMED CT Administration Method Codes](https://hl7.org/fhir/R4/valueset-administration-method-codes.html) | [AU Core MedicationRequest](StructureDefinition-au-core-medicationrequest.md),[AU Core MedicationStatement](StructureDefinition-au-core-medicationstatement.md) | FHIR |
| [Vital Signs Units](https://hl7.org/fhir/R4/valueset-ucum-vitals-common.html) | [AU Core Heart Rate](StructureDefinition-au-core-heartrate.md),[AU Core Body Height](StructureDefinition-au-core-bodyheight.md),[AU Core Blood Pressure](StructureDefinition-au-core-bloodpressure.md),[AU Core Respiration Rate](StructureDefinition-au-core-resprate.md),[AU Core Body Weight](StructureDefinition-au-core-bodyweight.md),[AU Core Waist Circumference](StructureDefinition-au-core-waistcircum.md),[AU Core Body Temperature](StructureDefinition-au-core-bodytemp.md) | FHIR |
| [Vital Signs](https://hl7.org/fhir/R4/valueset-observation-vitalsignresult.html) | [AU Core Heart Rate](StructureDefinition-au-core-heartrate.md),[AU Core Body Height](StructureDefinition-au-core-bodyheight.md),[AU Core Blood Pressure](StructureDefinition-au-core-bloodpressure.md),[AU Core Respiration Rate](StructureDefinition-au-core-resprate.md),[AU Core Body Weight](StructureDefinition-au-core-bodyweight.md),[AU Core Waist Circumference](StructureDefinition-au-core-waistcircum.md),[AU Core Body Temperature](StructureDefinition-au-core-bodytemp.md) | FHIR |

### Code Systems

See the [FHIR terminology section](http://hl7.org/fhir/R4/terminologies-systems.html) for a complete discussion on code systems and a list of code system names used in FHIR.

The following code systems are referenced by the value sets listed above.

Column attribute descriptions are as follows:

* **CodeSystem:** The title of a code system.
* **ValueSet where used:** The value set(s) that reference the code system.
* **Available from:** Where the code system is published.
* **Publisher:** Identifies the organisation responsible for maintaining the code system.

| | | | |
| :--- | :--- | :--- | :--- |
| [ActCode AU](https://hl7.org.au/fhir/CodeSystem-au-v3-ActCode.html) | [ActEncounterCode - AU Extended](https://hl7.org.au/fhir/ValueSet-au-v3-ActEncounterCode-extended.html) | AU Base | HL7 Australia |
| [ActCode](https://terminology.hl7.org/5.3.0/CodeSystem-v3-ActCode.html) | [ActEncounterCode - AU Extended](https://hl7.org.au/fhir/ValueSet-au-v3-ActEncounterCode-extended.html) | HL7 Terminology (THO) | Health Level Seven International |
| [AddressType](https://hl7.org/fhir/R4/codesystem-address-type.html) | [AddressType](https://hl7.org/fhir/R4/valueset-address-type.html) | FHIR | Health Level Seven International |
| [AddressUse](https://hl7.org/fhir/R4/codesystem-address-use.html) | [AddressUse](https://hl7.org/fhir/R4/valueset-address-use.html) | FHIR | Health Level Seven International |
| [AdministrativeGender](https://hl7.org/fhir/R4/codesystem-administrative-gender.html) | [AdministrativeGender](https://hl7.org/fhir/R4/valueset-administrative-gender.html) | FHIR | Health Level Seven International |
| [AllergyIntolerance Clinical Status Codes](https://hl7.org/fhir/R4/codesystem-allergyintolerance-clinical.html) | [AllergyIntolerance Clinical Status Codes](https://hl7.org/fhir/R4/valueset-allergyintolerance-clinical.html) | FHIR | Health Level Seven International |
| [AllergyIntolerance Verification Status Codes](https://hl7.org/fhir/R4/codesystem-allergyintolerance-verification.html) | [AllergyIntolerance Verification Status Codes](http://hl7.org/fhir/R4/valueset-allergyintolerance-verification.html) | FHIR | Health Level Seven International |
| [AllergyIntoleranceSeverity](https://hl7.org/fhir/R4/codesystem-reaction-event-severity.html) | [AllergyIntoleranceSeverity](https://hl7.org/fhir/R4/valueset-reaction-event-severity.html) | FHIR | Health Level Seven International |
| [Australian Immunisation Register Vaccine](https://www.humanservices.gov.au/organisations/health-professionals/enablers/air-vaccine-code-formats) | [Australian Immunisation Register Vaccine](https://healthterminologies.gov.au/fhir/ValueSet/australian-immunisation-register-vaccine-1) | NCTS | Services Australia |
| [Australian Indigenous Status](https://healthterminologies.gov.au/fhir/CodeSystem/australian-indigenous-status-1) | [Australian Indigenous Status](https://healthterminologies.gov.au/fhir/ValueSet/australian-indigenous-status-1) | NCTS | Australian Digital Health Agency |
| [Australian States and Territories](https://healthterminologies.gov.au/fhir/CodeSystem/australian-states-territories-1) | [Australian States and Territories](https://healthterminologies.gov.au/fhir/ValueSet/australian-states-territories-2) | NCTS | Australian Digital Health Agency |
| [Condition Category Codes](https://hl7.org/fhir/R4/codesystem-condition-category.html) | [Condition Category Codes](https://hl7.org/fhir/R4/valueset-condition-category.html) | FHIR | Health Level Seven International |
| [Condition Clinical Status Codes](https://hl7.org/fhir/R4/codesystem-condition-clinical.html) | [Condition Clinical Status Codes](https://hl7.org/fhir/R4/valueset-condition-clinical.html) | FHIR | Health Level Seven International |
| [ConditionVerificationStatus](https://hl7.org/fhir/R4/codesystem-condition-ver-status.html) | [ConditionVerificationStatus](https://hl7.org/fhir/R4/valueset-condition-ver-status.html) | FHIR | Health Level Seven International |
| [ContactPointSystem](https://hl7.org/fhir/R4/codesystem-contact-point-system.html) | [ContactPointSystem](https://hl7.org/fhir/R4/valueset-contact-point-system.html) | FHIR | Health Level Seven International |
| [ContactPointUse](https://hl7.org/fhir/R4/codesystem-contact-point-use.html) | [ContactPointUse](https://hl7.org/fhir/R4/valueset-contact-point-use.html) | FHIR | Health Level Seven International |
| [contactRole2](http://terminology.hl7.org/CodeSystem/v2-0131) | [Related Person Relationship Type](https://healthterminologies.gov.au/fhir/ValueSet/related-person-relationship-type-1) | HL7 Terminology (THO) | Health Level Seven International |
| [DataAbsentReason](http://terminology.hl7.org/CodeSystem/data-absent-reason) | [Australian Pronouns](https://healthterminologies.gov.au/fhir/ValueSet/australian-pronouns-1),[Gender Identity Response](https://healthterminologies.gov.au/fhir/ValueSet/gender-identity-response-1),[Biological Sex](https://healthterminologies.gov.au/fhir/ValueSet/biological-sex-1),[DataAbsentReason](https://hl7.org/fhir/R4/valueset-data-absent-reason.html) | HL7 Terminology (THO) | Health Level Seven International |
| [EncounterStatus](https://hl7.org/fhir/R4/codesystem-encounter-status.html) | [EncounterStatus](https://hl7.org/fhir/R4/valueset-encounter-status.html) | FHIR | Health Level Seven International |
| [EventStatus](https://hl7.org/fhir/R4/codesystem-event-status.html) | [EventStatus](https://hl7.org/fhir/R4/valueset-event-status.html),[Immunization Status Codes](https://hl7.org/fhir/R4/valueset-immunization-status.html) | FHIR | Health Level Seven International |
| [IdentifierType AU](https://hl7.org.au/fhir/CodeSystem-au-v2-0203.html) | [DVA Entitlement](https://hl7.org.au/fhir/ValueSet-dva-entitlement.html),[hl7VS-identifierType - AU Extended](https://hl7.org.au/fhir/ValueSet-au-v2-0203-extended.html) | AU Base | HL7 Australia |
| [identifierType](http://terminology.hl7.org/CodeSystem/v2-0203) | [hl7VS-identifierType - AU Extended](https://hl7.org.au/fhir/ValueSet-au-v2-0203-extended.html) | HL7 Terminology (THO) | Health Level Seven International |
| [IdentifierUse](https://hl7.org/fhir/R4/codesystem-identifier-use.html) | [IdentifierUse](https://hl7.org/fhir/R4/valueset-identifier-use.html) | FHIR | Health Level Seven International |
| [Individual Healthcare Identifier Record Status](https://healthterminologies.gov.au/fhir/CodeSystem/ihi-record-status-1) | [Individual Healthcare Identifier Record Status](https://healthterminologies.gov.au/fhir/ValueSet/ihi-record-status-1) | NCTS | Australian Digital Health Agency |
| [Individual Healthcare Identifier Status](https://healthterminologies.gov.au/fhir/CodeSystem/ihi-status-1) | [Individual Healthcare Identifier Status](https://healthterminologies.gov.au/fhir/ValueSet/ihi-status-1) | NCTS | Australian Digital Health Agency |
| [Location Type (Physical) AU](https://hl7.org.au/fhir/CodeSystem-au-location-physical-type.html) | [Location Type (Physical) - AU Extended](https://hl7.org.au/fhir/ValueSet-au-location-physical-type-extended.html) | AU Base | HL7 Australia |
| [Location Type AU](https://hl7.org.au/fhir/CodeSystem-au-location-type.html) | [ServiceDeliveryLocationRoleType - AU Extended](https://hl7.org.au/fhir/ValueSet-au-v3-ServiceDeliveryLocationRoleType-extended.html) | AU Base | HL7 Australia |
| [Location Type](http://terminology.hl7.org/CodeSystem/location-physical-type) | [Location Type (Physical) - AU Extended](https://hl7.org.au/fhir/ValueSet-au-location-physical-type-extended.html) | HL7 Terminology (THO) | Health Level Seven International |
| [LOINC](https://www.healthterminologies.gov.au/access-clinical-terminology/access-fhir-terminology-resources/code-systems/?ui:filter=loinc) | [Australian Pronouns](https://healthterminologies.gov.au/fhir/ValueSet/australian-pronouns-1),[RCPA SPIA Pathology Reporting](https://healthterminologies.gov.au/fhir/ValueSet/spia-pathology-reporting-1),[Vital Signs](http://hl7.org/fhir/R4/valueset-observation-vitalsignresult.html) | NCTS, HL7 Terminology (THO) | Regenstrief Institute, Inc |
| [Medication request intent](https://hl7.org/fhir/R4/codesystem-medicationrequest-intent.html) | [Medication request intent](https://hl7.org/fhir/R4/valueset-medicationrequest-intent.html) | FHIR | Health Level Seven International |
| [Medication status codes](https://hl7.org/fhir/R4/codesystem-medication-statement-status.html) | [Medication status codes](https://hl7.org/fhir/R4/valueset-medication-statement-status.html) | FHIR | Health Level Seven International |
| [Medicationrequest status](https://hl7.org/fhir/R4/codesystem-medicationrequest-status.html) | [Medicationrequest status](https://hl7.org/fhir/R4/valueset-medicationrequest-status.html) | FHIR | Health Level Seven International |
| [NameUse](https://hl7.org/fhir/R4/codesystem-name-use.html) | [NameUse](https://hl7.org/fhir/R4/valueset-name-use.html) | FHIR | Health Level Seven International |
| [Observation Category Codes](https://hl7.org/fhir/R4/codesystem-observation-category.html) | [Observation Category Codes](https://hl7.org/fhir/R4/valueset-observation-category.html) | FHIR | Health Level Seven International |
| [Observation Reference Range Meaning Codes](https://hl7.org/fhir/R4/codesystem-referencerange-meaning.html) | [Observation Reference Range Meaning Codes](https://hl7.org/fhir/R4/valueset-referencerange-meaning.html) | FHIR | Health Level Seven International |
| [ObservationStatus](https://hl7.org/fhir/R4/codesystem-observation-status.html) | [ObservationStatus](http://hl7.org/fhir/R4/valueset-observation-status.html) | FHIR | Health Level Seven International |
| [Participant type](https://hl7.org/fhir/R4/codesystem-encounter-participant-type.html) | [Participant type](https://hl7.org/fhir/R4/valueset-encounter-participant-type.html) | FHIR | Health Level Seven International |
| [Participation Type](https://terminology.hl7.org/5.1.0/CodeSystem-v3-ParticipationType.html) | [Related Person Relationship Type](https://healthterminologies.gov.au/fhir/ValueSet/related-person-relationship-type-1) | HL7 Terminology (THO) | Health Level Seven International |
| [PBS Item Codes](https://hl7.org.au/fhir/CodeSystem-pbs-item-external.html) | [PBS Item Codes](https://hl7.org.au/fhir/ValueSet-pbs-item.html) | AU Base | Department of Health and Aged Care, Commonwealth of Australia |
| [QuantityComparator](https://hl7.org/fhir/R4/codesystem-quantity-comparator.html) | [QuantityComparator](https://hl7.org/fhir/R4/valueset-quantity-comparator.html) | FHIR | Health Level Seven International |
| [RoleClass](http://terminology.hl7.org/CodeSystem/v3-RoleClass) | [Related Person Relationship Type](https://healthterminologies.gov.au/fhir/ValueSet/related-person-relationship-type-1) | HL7 Terminology (THO) | Health Level Seven International |
| [RoleCode](http://terminology.hl7.org/CodeSystem/v3-RoleCode) | [ServiceDeliveryLocationRoleType - AU Extended](https://hl7.org.au/fhir/ValueSet-au-v3-ServiceDeliveryLocationRoleType-extended.html),[Related Person Relationship Type](https://healthterminologies.gov.au/fhir/ValueSet/related-person-relationship-type-1) | HL7 Terminology (THO) | Health Level Seven International |
| [SNOMED Clinical Terms (Australian extension)](https://www.healthterminologies.gov.au/access-clinical-terminology/access-snomed-ct-au/) | [Australian Medication](https://healthterminologies.gov.au/fhir/ValueSet/australian-medication-1),[Australian Medicines Terminology Vaccine](https://healthterminologies.gov.au/fhir/ValueSet/amt-vaccine-1),[Biological Sex](https://healthterminologies.gov.au/fhir/ValueSet/biological-sex-1),[Body Site](https://healthterminologies.gov.au/fhir/ValueSet/body-site-1),[Clinical Condition](https://healthterminologies.gov.au/fhir/ValueSet/clinical-condition-1),[Clinical Finding](https://healthterminologies.gov.au/fhir/ValueSet/clinical-finding-1),[Clinical Specialty](https://healthterminologies.gov.au/fhir/ValueSet/clinical-specialty-1),[Condition/Diagnosis Severity](https://hl7.org/fhir/R4/valueset-condition-severity.html),[Gender Identity Response](https://healthterminologies.gov.au/fhir/ValueSet/gender-identity-response-1),[Healthcare Organisation Role Type](https://healthterminologies.gov.au/fhir/ValueSet/healthcare-organisation-role-type-1),[Indicator of Hypersensitivity or Intolerance to Substance](https://healthterminologies.gov.au/fhir/ValueSet/indicator-hypersensitivity-intolerance-to-substance-2),[Medication Reason Taken](https://healthterminologies.gov.au/fhir/ValueSet/medication-reason-taken-1),[Practitioner Role](https://healthterminologies.gov.au/fhir/ValueSet/practitioner-role-1),[Procedure](https://healthterminologies.gov.au/fhir/ValueSet/procedure-1),[Reason For Encounter](https://healthterminologies.gov.au/fhir/ValueSet/reason-for-encounter-1),[Reason for Request](https://healthterminologies.gov.au/fhir/ValueSet/reason-for-request-1),[Related Person Relationship Type](https://healthterminologies.gov.au/fhir/ValueSet/related-person-relationship-type-1),[Route of Administration](https://healthterminologies.gov.au/fhir/ValueSet/route-of-administration-1),[Service Type](https://healthterminologies.gov.au/fhir/ValueSet/service-type-1),[Smoking Status](https://healthterminologies.gov.au/fhir/ValueSet/smoking-status-1),[SNOMED CT Additional Dosage Instructions](https://hl7.org/fhir/R4/valueset-additional-instruction-codes.html),[SNOMED CT Administration Method Codes](https://hl7.org/fhir/R4/valueset-administration-method-codes.html) | NCTS | Australian Digital Health Agency |
| [Tags for the Identification of Languages](https://terminology.hl7.org/ECS_MR-v3-ietf3066.html) | [Common Languages in Australia](https://healthterminologies.gov.au/fhir/ValueSet/common-languages-australia-2) | HL7 Terminology (THO) | Internet Engineering Task Force |
| [Unified Code for Units of Measure (UCUM)](https://terminology.hl7.org/ECS_MR-v3-ucum.html) | [Body Length Units](https://hl7.org/fhir/R4/valueset-ucum-bodylength.html),[Body Temperature Units](https://hl7.org/fhir/R4/valueset-ucum-bodytemp.html),[Body Weight Units](https://hl7.org/fhir/R4/valueset-ucum-bodyweight.html),[Vital Signs Units](https://hl7.org/fhir/R4/valueset-ucum-vitals-common.html) | HL7 Terminology (THO) | Regenstrief Institute, Inc |
| [v2 DIAGNOSTIC SERVICE SECTION ID](http://hl7.org/fhir/R4/v2/0074/index.html) | [Diagnostic Service Section Codes](http://hl7.org/fhir/R4/valueset-diagnostic-service-sections.html),[Pathology Diagnostic Service Category](https://healthterminologies.gov.au/fhir/ValueSet/pathology-diagnostic-service-category-1) | FHIR | Health Level Seven International |
| [v3 Code System ObservationInterpretation](https://hl7.org/fhir/R4/v3/ObservationInterpretation/cs.html) | [Observation Interpretation Codes](https://hl7.org/fhir/R4/valueset-observation-interpretation.html) | FHIR | Health Level Seven International |
| [v3 Code System ParticipationType](https://hl7.org/fhir/R4/v3/ParticipationType/cs.html) | [Participant type](https://hl7.org/fhir/R4/valueset-encounter-participant-type.html) | FHIR | Health Level Seven International |

