# Home - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org.au/fhir/core/ImplementationGuide/hl7.fhir.au.core | *Version*:2.0.0 | |
| * IG Standards status: *[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](https://hl7.org.au/fhir/6.0.0/generalguidance.html#maturity-levels): 2 | *Computable Name*:AUCoreImplementationGuide |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2022+; Licensed Under Creative Commons No Rights Reserved. | | |

### Introduction

AU Core is provided to support the use of HL7® FHIR®© in an Australian context. It sets the minimum expectations on FHIR resources to support conformance and implementation in systems.

AU Core defines the data model and RESTful API interactions that set minimum expectations for a system to record, update, search, and retrieve core digital health and administrative information.

AU Core uses AU Base representations, where available, as the basis for profiles that define the FHIR resources to be supported, along with their elements, extensions, vocabularies, and value sets, and how they are used is defined. It also documents the minimum FHIR RESTful interactions for each resource type to access data. AU Core promotes interoperability and adoption through common implementation and provides the basis for further implementation guide development for specific use cases.

There are two different ways to implement AU Core:

1. Profile Only Support: systems support only the resources as profiled by AU Core to represent digital health information.
1. Profile Support + Interaction Support: systems support the resources as profiled by AU Core to represent digital health information (Profile Support) and the[RESTful FHIR API](http://hl7.org/fhir/R4/http.html)interactions defined for it (Interaction Support).

In this regard it is similar in nature to other national core specifications such as US Core FHIR Implementation Guide and international FHIR specifications such as International Patient Access FHIR Implementation Guide.

For a detailed description of the different ways to implement AU Core see the [Conformance Requirements](general-requirements.md) page.

### Project Background

This implementation guide is under development through the AU Core project as part of the [Sparked AU FHIR Accelerator](https://sparked.csiro.au/). The Sparked AU FHIR Accelerator is a community comprising government, technology vendors, provider organisations, peak bodies, practitioners, and domain experts, to accelerate the creation and use of national FHIR standards in health care information exchange.

The AU Core Sparked project includes:

* AUCDI - clinician focussed data requirements project.
* AU Core FHIR Implementation Guide - HL7 Australia technical data access and exchange specification.

[AUCDI](https://sparked.csiro.au/index.php/sparked-products-resources/aucdi/) aims to define requirements underlying the standardisation of the capture, structure, usage, and exchange of health data to counteract the current fragmentation of Australia’s health data systems. The AUCDI forms a basis for clinical data requirements for AU Core.

### Dependencies






* Parameter: system-version
  * Value: SNOMED CT[AU]

### Usage

AU Core is particularly useful in defining:

* A testable level of system conformance
* Assumed support by client applications
* The basis of downstream implementation guides

Implementation of capabilities defined in AU Core enables specifications, applications and business logic to be developed with confidence.

This document is a working specification that may be directly implemented by FHIR®© system producers.

FHIR®© Connectathon events are key to the verification of the guide as being suitable for implementation. This implementation guide will be used as the basis for Australian Connectathon events.

### AU Core Actors

The following actors are part of AU Core:

**AU Core Requestor**

A system that creates and initiates a data access request to retrieve core digital health and administrative information. The AU Core Requestor is the client in a client-server interaction.
 

**AU Core Responder**

A system that responds to the data access request submitted by requesters, providing responses to requests for core digital health and administrative information. The AU Core Responder is the server in a client-server interaction.
 

### AU Core FHIR RESTful Interactions

For systems that support AU Core FHIR RESTful interactions ([Profile Support + Interaction Support](general-requirements.md#profile-support--interaction-support)), the interaction requirements, such as read and search operations, are detailed in the AU Core Requester and AU Core Responder [CapabilityStatements](capability-statements.md).

The following are simple examples of AU Core FHIR RESTful interactions between AU Core Requester and AU Core Responder actors:

**Example of a FHIR RESTful read interaction**

 **Figure 1: Read a Patient using the logical id** 
 

**Example of a FHIR RESTful search interaction**

 **Figure 2: Search for patients that match a family name** 

### How to Read This Guide

This guide is divided into several pages which are listed at the top of each page in the menu bar.

* [Home](index.md): This page provides the introduction and scope for this guide.
* [Conformance](conformance.md): These pages describe the set of rules to claim conformance to this guide including the expectations for **Must Support** elements in AU Core profiles. 
* [General Requirements](general-requirements.md): This page defines requirements common to all actors and profiles used in this guide including how CapabilityStatements are used to claim conformance. This page defines the expectations for mandatory and **Must Support** elements in AU Core Profiles.
* [Declaring Conformance](declaring-conformance.md): This page describes how to declare conformance to AU Core.
 
* [Guidance](guidance.md): These pages list the guidance for this guide. 
* [General Guidance](general-guidance.md): This page provides guidance on using the profiles defined in this guide.
* [Medicine Information](medicine-information.md): This page provides guidance on constructing medication related resources.
* [Sex and Gender](sex-and-gender.md): This page provides guidance on the representation of sex, gender, and related concepts.
* [AUCDI](aucdi.md): This page maps AUCDI data groups and elements to FHIR artefacts in AU Core.
* [Relationship With Other IGs](relationship.md): This page provides guidance on the relationship between AU Core, AUCDI, and other implementation guides.
* [AU Variance Statement](variance.md): This page documents the variance from AU Base.
* [Comparison With Other National and International IGs](comparison.md): This page provides comparison between AU Core profiles and other national, or international implementation guides.
* [Future of AU Core](future.md): This page outlines the approach to developing AU Core and yearly update cycle.
 
* [Security and Privacy](security.md): This page documents the AU Core general security and privacy requirements and recommendations.
* [FHIR Artefacts](fhirartefacts.md): These pages provide detailed descriptions and formal definitions for all the FHIR artefacts defined in this guide. 
* [Artefacts Summary](artifacts.md): This page lists the FHIR artefacts defined in this guide.
* [Profiles and Extensions](profiles-and-extensions.md): This page describes the profiles and extensions that are defined in this guide to exchange data. Each profile page includes a narrative description and guidance, formal definition and a "Notes" section that summarises the supported search transactions for each profile. Guidance typically focuses on the profiled elements but can include guidance on un-profiled elements to aid with implementation.
* [Search Parameters](search-parameters.md): This page lists the search parameters extended for use in this guide for use in AU Core operations.
* [Terminology](terminology.md): This page lists the value sets and code systems supported in this guide.
* [Capability Statements](capability-statements.md): This page defines the expected FHIR capabilities of AU Core Responders and Requesters.
* [Actor Definitions](actors.md): This page defines the AU Core actors, AU Core Responder and AU Core Requester.
 
* [Examples](examples.md): This page lists all the examples used in this guide.
* [Support](support.md): These pages provide supporting material for implementation of AU Core. 
* [Downloads](downloads.md): This page provides links to downloadable artefacts.
* [License and Legal](license.md): This page outlines the license and legal requirements for material in AU Core.
 
* [Change Log](changes.md): This page documents the changes across versions of this guide.

### Collaboration

This guide is the product of collaborative work undertaken with participants from:

* [Sparked HL7 Australia AU Core Technical Design Group](https://confluence.hl7.org/display/HAFWG/HL7+Australia+-+AU+Core+Technical+Design+Group+Home)
* [HL7 Australia FHIR Working Group](https://confluence.hl7.org/display/HAFWG/HL7+Australia+FHIR+Work+Group+Home)
* Australian FHIR Implementers Community

Primary Editors: Brett Esler, Danielle Tavares-Rixon, Dusica Bojicic.



## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "hl7.fhir.au.core",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    }
  ],
  "url" : "http://hl7.org.au/fhir/core/ImplementationGuide/hl7.fhir.au.core",
  "version" : "2.0.0",
  "name" : "AUCoreImplementationGuide",
  "title" : "AU Core Implementation Guide",
  "status" : "active",
  "date" : "2026-01-28T05:31:23+00:00",
  "publisher" : "HL7 Australia",
  "contact" : [
    {
      "name" : "HL7 Australia FHIR Work Group",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.hl7.org/display/HAFWG",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This implementation guide is provided to support the use of FHIR®© in an Australian context, and defines the minimum set of constraints on the FHIR resources to create the AU Core profiles. This implementation guide forms the foundation to build future AU Realm FHIR implementation guides and its content will continue to grow to meet the needs of AU implementers.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2022+; Licensed Under Creative Commons No Rights Reserved.",
  "packageId" : "hl7.fhir.au.core",
  "license" : "CC0-1.0",
  "fhirVersion" : ["4.0.1"],
  "dependsOn" : [
    {
      "id" : "hl7tx",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on HL7 Terminology"
        }
      ],
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r4",
      "version" : "7.0.1"
    },
    {
      "id" : "hl7ext",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on the HL7 Extension Pack"
        }
      ],
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r4",
      "version" : "5.2.0"
    },
    {
      "id" : "aubaser6",
      "uri" : "http://hl7.org.au/fhir/ImplementationGuide/hl7.fhir.au.base",
      "packageId" : "hl7.fhir.au.base",
      "version" : "6.0.0"
    },
    {
      "uri" : "http://hl7.org/fhir/smart-app-launch/ImplementationGuide/hl7.fhir.uv.smart-app-launch",
      "packageId" : "hl7.fhir.uv.smart-app-launch",
      "version" : "2.2.0"
    },
    {
      "uri" : "http://hl7.org/fhir/uv/ipa/ImplementationGuide/hl7.fhir.uv.ipa",
      "packageId" : "hl7.fhir.uv.ipa",
      "version" : "1.1.0"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2022+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "Working Standard"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "shownav"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "show-inherited-invariants"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludemap"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-expansion-params"
          },
          {
            "url" : "value",
            "valueString" : "../input/_resources/exp-params.json"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "https://hl7.org.au/fhir/6.0.0/generalguidance.html#maturity-levels"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "version-comparison-master"
          },
          {
            "url" : "value",
            "valueString" : "1.0.0"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org.au/fhir/core/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/expansion-parameters",
        "valueReference" : {
          "reference" : "Parameters/expansion-parameters"
        }
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r4#0.9.0"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2022+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "Working Standard"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "shownav"
          },
          {
            "url" : "value",
            "valueString" : "false"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "show-inherited-invariants"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludemap"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-expansion-params"
          },
          {
            "url" : "value",
            "valueString" : "../input/_resources/exp-params.json"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "https://hl7.org.au/fhir/6.0.0/generalguidance.html#maturity-levels"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "version-comparison-master"
          },
          {
            "url" : "value",
            "valueString" : "1.0.0"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org.au/fhir/core/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ActorDefinition"
          }
        ],
        "reference" : {
          "reference" : "ActorDefinition/au-core-actor-responder"
        },
        "name" : "AU Core Responder",
        "description" : "The AU Core Responder is a system responsible for providing responses to queries submitted by AU Core Requesters.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ActorDefinition"
          }
        ],
        "reference" : {
          "reference" : "ActorDefinition/au-core-actor-requester"
        },
        "name" : "AU Core Requester",
        "description" : "The AU Core Requester is a system that creates and initiates a data access request to retrieve core digital health and administrative information.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/au-core-responder"
        },
        "name" : "AU Core Responder CapabilityStatement",
        "description" : "This CapabilityStatement describes the basic rules for the [AU Core Responder actor](ActorDefinition-au-core-actor-responder.html) that is responsible for providing responses to queries submitted by AU Core Requesters. The complete list of FHIR profiles, RESTful operations, and search parameters supported by AU Core Responders are defined in this CapabilityStatement.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CapabilityStatement"
          }
        ],
        "reference" : {
          "reference" : "CapabilityStatement/au-core-requester"
        },
        "name" : "AU Core Requester CapabilityStatement",
        "description" : "This CapabilityStatement describes the basic rules for the [AU Core Requester actor](ActorDefinition-au-core-actor-requester.html) that is responsible for creating and initiating the queries for information. The complete list of FHIR profiles, RESTful operations, and search parameters supported by AU Core Requesters are defined in this CapabilityStatement.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/au-core-clinical-patient"
        },
        "name" : "AUCoreClinicalPatient",
        "description" : "This SearchParameter describes the rules on the clinical-patient search parameter in AU Core. It is based on the FHIR [clinical-patient](https://hl7.org/fhir/R4/searchparameter-registry.html#clinical-patient) search parameter and identifies the additional requirements when conforming to AU Core.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "SearchParameter"
          }
        ],
        "reference" : {
          "reference" : "SearchParameter/au-core-practitionerrole-practitioner"
        },
        "name" : "AUCorePractitionerRolePractitioner",
        "description" : "This SearchParameter describes the rules on the PractitionerRole-practitioner search parameter in AU Core. It is based on the FHIR [PractitionerRole-practitioner](https://hl7.org/fhir/R4/practitionerrole.html#search) search parameter and identifies the additional requirements when conforming to AU Core.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/au-core-allergyintolerance"
        },
        "name" : "AU Core AllergyIntolerance",
        "description" : "This profile sets minimum expectations for an AllergyIntolerance resource to record, search, and fetch allergies/adverse reactions associated with a patient. It is based on the [AU Base AllergyIntolerance](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-allergyintolerance.html) profile and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the AllergyIntolerance resource when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/au-core-condition"
        },
        "name" : "AU Core Condition",
        "description" : "This profile sets minimum expectations for a Condition resource to record, search, and fetch problems, diagnoses, and health concerns associated with a patient. It is based on the [AU Base Condition](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-condition.html) profile and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Condition resource when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/au-core-encounter"
        },
        "name" : "AU Core Encounter",
        "description" : "This profile sets minimum expectations for an Encounter resource to record, search, and fetch basic encounter information for a patient. It is based on the [AU Base Encounter](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-encounter.html) profile and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Encounter when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/au-core-immunization"
        },
        "name" : "AU Core Immunization",
        "description" : "This profile sets minimum expectations for an Immunization resource to record, search, and fetch immunisation history associated with a patient. It is based on the [AU Base Immunization](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-immunization.html) profile and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Immunization resource when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/au-core-location"
        },
        "name" : "AU Core Location",
        "description" : "This profile sets minimum expectations for a Location resource to record, search, and fetch information about a location. It is based on the [AU Base Location](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-location.html) profile and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Location when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/au-core-medication"
        },
        "name" : "AU Core Medication",
        "description" : "This profile sets minimum expectations for a Medication resource to record, search, and fetch medications associated with a patient. It is based on the [AU Base Medication](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-medication.html) profile and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Medication when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context. \n\nIn AU Core a Medication resource is used within the context of a referencing resource: MedicationAdministration, MedicationDispense, MedicationRequest, or MedicationStatement resource.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/au-core-medicationrequest"
        },
        "name" : "AU Core MedicationRequest",
        "description" : "This profile sets minimum expectations for a MedicationRequest resource to record, search, and fetch medication orders and requests (i.e. prescriptions) associated with a patient. It is based on the [AU Base MedicationRequest](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-medicationrequest.html) profile and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the MedicationRequest when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/au-core-organization"
        },
        "name" : "AU Core Organization",
        "description" : "This profile sets minimum expectations for a Organization resource to record, search, and fetch information about an organisation. It is based on the [AU Base Organization](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-organization.html) profile and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Organization when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/au-core-patient"
        },
        "name" : "AU Core Patient",
        "description" : "This profile sets minimum expectations for a Patient resource to record, search, and fetch basic demographics and other administrative information about an individual patient. It is based on the [AU Base Patient](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-patient.html) profile and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Patient when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/au-core-practitioner"
        },
        "name" : "AU Core Practitioner",
        "description" : "This profile sets minimum expectations for a Practitioner resource to record, search, and fetch basic demographics and other administrative information about an individual practitioner. It is based on the [AU Base Practitioner](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-practitioner.html) profile and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Practitioner when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/au-core-practitionerrole"
        },
        "name" : "AU Core PractitionerRole",
        "description" : "This profile sets minimum expectations for a PractitionerRole resource to record, search, and fetch a practitioner role for a practitioner associated with a patient. It is based on the [AU Base PractitionerRole](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-practitionerrole.html) profile and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the PractitionerRole resource when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/au-core-procedure"
        },
        "name" : "AU Core Procedure",
        "description" : "This profile sets minimum expectations for a Procedure resource to record, search, and fetch procedures associated with a patient. It is based on the [AU Base Procedure](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-procedure.html) profile and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Procedure resource when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/au-core-rsg-sexassignedab"
        },
        "name" : "AU Core Sex Assigned At Birth",
        "description" : "This profile defines the minimum expectations for a [Person Recorded Sex or Gender extension](https://hl7.org/fhir/extensions/StructureDefinition-individual-recordedSexOrGender.html) when representing Sex Assigned at Birth. This profile identifies the *additional* mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Extension when conforming to this profile.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/au-core-bloodpressure"
        },
        "name" : "AU Core Blood Pressure",
        "description" : "This profile sets minimum expectations for an Observation resource to record, search, and fetch blood pressure observations with standard coding and units of measure. It is based on the [FHIR Blood Pressure Profile](http://hl7.org/fhir/R4/bp.html) and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Observation resource when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/au-core-bodyheight"
        },
        "name" : "AU Core Body Height",
        "description" : "This profile sets minimum expectations for an Observation resource to record, search, and fetch body height observations with standard coding and units of measure. It is based on the [FHIR Body Height Profile](http://hl7.org/fhir/R4/bodyheight.html) and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Observation resource when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/au-core-bodyweight"
        },
        "name" : "AU Core Body Weight",
        "description" : "This profile sets minimum expectations for an Observation resource to record, search, and fetch body weight observations with standard coding and units of measure. It is based on the [FHIR Body Weight Profile](http://hl7.org/fhir/R4/bodyweight.html) and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Observation resource when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/au-core-bodytemp"
        },
        "name" : "AU Core Body Temperature",
        "description" : "This profile sets minimum expectations for an Observation resource to record, search, and fetch body temperature observations with standard coding and units of measure. It is based on the [FHIR Body Temperature Profile](http://hl7.org/fhir/R4/bodytemp.html) and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Observation resource when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/au-core-resprate"
        },
        "name" : "AU Core Respiration Rate",
        "description" : "This profile sets minimum expectations for an Observation resource to record, search, and fetch respiration rate observations with standard coding and units of measure. It is based on the [FHIR Respiratory Rate Profile](http://hl7.org/fhir/R4/resprate.html) and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Observation resource when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/au-core-heartrate"
        },
        "name" : "AU Core Heart Rate",
        "description" : "This profile sets minimum expectations for an Observation resource to record, search, and fetch heart rate observations with standard coding and units of measure. It is based on the [FHIR Heart Rate Profile](http://hl7.org/fhir/R4/heartrate.html) and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Observation resource when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/au-core-waistcircum"
        },
        "name" : "AU Core Waist Circumference",
        "description" : "This profile sets minimum expectations for an Observation resource to record, search, and fetch waist circumference observations with standard coding and units of measure. It is based on the [FHIR Vital Signs Profile](http://hl7.org/fhir/R4/vitalsigns.html) and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Observation resource when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/au-core-healthcareservice"
        },
        "name" : "AU Core HealthcareService",
        "description" : "This profile sets minimum expectations for a HealthcareService resource to record, search, and fetch information about a healthcare service. It is based on the [AU Base HealthcareService](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-healthcareservice.html) profile and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the HealthcareService resource when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/au-core-smokingstatus"
        },
        "name" : "AU Core Smoking Status",
        "description" : "This profile sets minimum expectations for an Observation resource to record, search, and fetch observations that represent a patient’s smoking status, i.e. current behaviour for all types of tobacco smoking, with standard coding. It is based on the FHIR [Observation](http://hl7.org/fhir/R4/observation.html) resource and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Observation resource when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "AllergyIntolerance"
          }
        ],
        "reference" : {
          "reference" : "AllergyIntolerance/lactose"
        },
        "name" : "AllergyIntolerance - Lactose intolerance",
        "description" : "Shows an example of Lactose intolerance with manifestations of abdominal pain, bloating, and diarrhoea for the *AU Core AllergyIntolerance* profile. Patient: Mia Leanne Banks.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-allergyintolerance"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "AllergyIntolerance"
          }
        ],
        "reference" : {
          "reference" : "AllergyIntolerance/noneknown"
        },
        "name" : "AllergyIntolerance - No known allergy",
        "description" : "Shows an example of allergy intolerance for the *AU Core AllergyIntolerance* profile indicating the patient has no known allergies. Patient: Mr. Li Wang.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-allergyintolerance"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "AllergyIntolerance"
          }
        ],
        "reference" : {
          "reference" : "AllergyIntolerance/penicillin"
        },
        "name" : "AllergyIntolerance - Penicillin allergy",
        "description" : "Shows an example of a Penicillin allergy with the reaction manifestation as hives for the *AU Core AllergyIntolerance* profile. Patient: Deangelo HOWE.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-allergyintolerance"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/ckd"
        },
        "name" : "Condition - Chronic Kidney Disease",
        "description" : "Shows an example of active Chronic Kidney Disease with onset age for the *AU Core Condition* profile. Patient: Ronny Lawrence Irvine.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-condition"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/uti"
        },
        "name" : "Condition - Urinary tract infection",
        "description" : "Shows an example of a resolved urinary tract infection with onset and abatement age for the *AU Core Condition* profile. Patient: Mia Leanne Banks.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-condition"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/condition-masked"
        },
        "name" : "Condition - Data suppressed for category and code",
        "description" : "Shows an example of a condition with suppressed data (category and code) where the data requester has access rights to know that data is suppressed for the *AU Core Condition* profile. Patient: Anne Bennelong.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-condition"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/noknown"
        },
        "name" : "Condition - No known condition",
        "description" : "Shows an example of no known conditions for the *AU Core Condition* profile. Patient: Deangelo HOWE.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-condition"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/covid-admin-1"
        },
        "name" : "Encounter - COVID 19 Vaccine Administration Dose 1",
        "description" : "Shows an example of a COVID-19 vaccine administration encounter for the *AU Core Encounter* profile. Patient: Mrs. Anne Bennelong.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/discharge-1"
        },
        "name" : "Encounter - Discharge",
        "description" : "Shows an example of a completed emergency encounter for the *AU Core Encounter* profile. Patient: Ronny Lawrence Irvine.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/telehealth"
        },
        "name" : "Encounter - telehealth",
        "description" : "Shows an example of a completed virtual telehealth encounter for the *AU Core Encounter* profile. Patient: Mrs. Anne Bennelong.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-encounter"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Immunization"
          }
        ],
        "reference" : {
          "reference" : "Immunization/covid-1"
        },
        "name" : "Immunization - COVID Dose 1",
        "description" : "Shows an example of administered COVID-19 vaccine for the *AU Core Immunization* profile. Patient: Mrs. Anne Bennelong.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-immunization"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Immunization"
          }
        ],
        "reference" : {
          "reference" : "Immunization/zoster-notgiven"
        },
        "name" : "Immunization - Administration of Zoster vaccination refused",
        "description" : "Shows an example of a vaccination not administered due to patient's refusal for the *AU Core Immunization* profile. Patient: Deangelo HOWE.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-immunization"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Location"
          }
        ],
        "reference" : {
          "reference" : "Location/bobrester-medical-center"
        },
        "name" : "Location - Tindal Building",
        "description" : "Shows an example of Tindal Building location for the *AU Core Location* profile.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-location"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Location"
          }
        ],
        "reference" : {
          "reference" : "Location/patient-home"
        },
        "name" : "Location - Patient home",
        "description" : "Shows an example of patient's home location example for the *AU Core Location* profile.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-location"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Location"
          }
        ],
        "reference" : {
          "reference" : "Location/murrabit-hospital"
        },
        "name" : "Location - Murrabit Public Hospital",
        "description" : "Shows an example of the Murrabit Public Hospital location for the *AU Core Location* profile.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-location"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/1active-ingredient"
        },
        "name" : "Medication - Branded pack with one active ingredient",
        "description" : "Shows an example of a branded medication, Chlorsig (chloramphenicol 0.5%), with one active ingredient for the *AU Core Medication* profile. Includes a medication type extension indicating a branded product with no specified strength or form.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-medication"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/2active-ingredients"
        },
        "name" : "Medication - Product with two active ingredients",
        "description" : "Shows an example of a combination medication, perindopril arginine 10 mg + amlodipine 10 mg tablets, for the *AU Core Medication* profile. Includes a PBS code for the medication.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-medication"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/simvastatin"
        },
        "name" : "Medication - Simvastatin 40 MG Disintegrating Oral Tablet",
        "description" : "Shows an example of Simvastatin 40 mg oral tablet for the *AU Core Medication* profile. Includes a SNOMED CT code for the medication.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-medication"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/paracetamol-codeine"
        },
        "name" : "MedicationRequest - prescription, paracetamol 500 mg + codeine phosphate hemihydrate 30 mg",
        "description" : "Shows an example of an order for paracetamol 500 mg + codeine phosphate hemihydrate 30 mg tablet for pain management for the *AU Core MedicationRequest* profile illustrating missing data for status and requester. Patient:  Mrs. Anne Bennelong.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-medicationrequest"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/reaptan"
        },
        "name" : "MedicationRequest - active prescription, Reaptan",
        "description" : "Shows an example of an order for Reaptan 10 mg/10 mg for the *AU Core MedicationRequest* profile. The request includes the reason code, a reference to a contained Medication resource, and dosage instructions. Patient: Mr. Li Wang.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-medicationrequest"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/simvastatin"
        },
        "name" : "MedicationRequest - active prescription, Simvastatin",
        "description" : "Shows an example of an order for Simvastatin 40 mg oral tablet for high cholesterol for the *AU Core MedicationRequest* profile, demonstrating representation of medication as a reference to a Medication resource. Patient: Mr. Li Wang.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-medicationrequest"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/active-bisoprolol"
        },
        "name" : "MedicationStatement - active use of Bisoprolol 2.5mg",
        "description" : "Shows an example of current (active) use of Bisolprolol 2.5mg with dosage text for the *AU Core MedicationStatement* profile. This example demonstrates representation of medication as a reference to a contained Medication resource. Patient:  Mia Leanne Banks.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-medicationstatement"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/completed-bactrim"
        },
        "name" : "MedicationStatement - completed use of Bactrim DS",
        "description" : "Shows an example of completed use of Bactrim DS tablet due to a urinary tract infection (reasonReference) for the *AU Core MedicationStatement* profile. Patient:  Mia Leanne Banks.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-medicationstatement"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/completed-chloramphenicol"
        },
        "name" : "MedicationStatement - completed use of Chloramphenicol 1% eye ointment",
        "description" : "Shows an example of completed use of Chloramphenicol 1% eye ointment due to Adult gonococcal conjunctivitis (reasonCode) for the *AU Core MedicationStatement* profile. Patient:  Mia Leanne Banks.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-medicationstatement"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/previous-use-diflucan"
        },
        "name" : "MedicationStatement - patient has taken Diflucan in the past but is not taking it any more",
        "description" : "Shows an example of the previous use of Diflucan 200 mg/100 mL injection and the patient is not currently on this medicine for the *AU Core MedicationStatement* profile. This example demonstrates representation of additional AUCDI concepts for dosage including route, timing, dose and rate. Patient:  Mia Leanne Banks.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-medicationstatement"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/bloodpressure-1"
        },
        "name" : "Observation - Blood Pressure (systolic and diastolic)",
        "description" : "Shows an example of a blood pressure observation with both systolic and diastolic measurements for the *AU Core Blood Pressure* profile. Patient: Mr. Li Wang.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-bloodpressure"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/bloodpressure-data-absent"
        },
        "name" : "Observation - Blood Pressure (data absent for diastolic)",
        "description" : "Shows an example of a blood pressure observation for the *AU Core Blood Pressure* profile, where the systolic value is recorded and the diastolic value is marked as unknown using the Data Absent Reason extension. Patient: Ronny Lawrence Irvine.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-bloodpressure"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/bodyheight-1"
        },
        "name" : "Observation - Height",
        "description" : "Shows an example of a body height observation for the *AU Core Body Height* profile. Patient: Mr. Li Wang.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-bodyheight"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/bodytemp-1"
        },
        "name" : "Observation - Temperature",
        "description" : "Shows an example of a body temperature observation for the *AU Core Body Temperature* profile. Patient: Mrs. Anne Bennelong.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-bodytemp"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/bodyweight-1"
        },
        "name" : "Observation - Body weight",
        "description" : "Shows an example of a body weight observation for the *AU Core Body Weight* profile. Patient: Mia Leanne Banks.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-bodyweight"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/hearing-threshold-1"
        },
        "name" : "Observation - Hearing threshold Ear (left) 500 Hz",
        "description" : "Shows an example of a hearing threshold observation for the *AU Core Diagnostic Result Observation* profile. Patient: Ronny Lawrence Irvine.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-diagnosticresult"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/heartrate-1"
        },
        "name" : "Observation - Heart rate",
        "description" : "Shows an example of a heart rate observation for the *AU Core Heart Rate* profile. Patient: Mr. Li Wang.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-heartrate"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/pulserate-1"
        },
        "name" : "Observation - Pulse rate",
        "description" : "Shows an example of a pulse rate observation for the *AU Core Heart Rate* profile. Patient: Mr. Li Wang.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-heartrate"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/lipid-hdl-1"
        },
        "name" : "Observation - HDL",
        "description" : "Shows an example of a laboratory result for HDL cholesterol levels for the *AU Core Pathology Result Observation* profile. Patient: Mia Leanne Banks.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-diagnosticresult-path"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/lipid-ldl-1"
        },
        "name" : "Observation - LDL",
        "description" : "Shows an example of a laboratory result for LDL cholesterol for the *AU Core Pathology Result Observation* profile. Patient: Mia Leanne Banks.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-diagnosticresult-path"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/lipid-total-chol-1"
        },
        "name" : "Observation - Total Cholesterol/HDL ratio",
        "description" : "Shows an example of a laboratory result for the Total Cholesterol/HDL ratio for the *AU Core Pathology Result Observation* profile. Patient: Mia Leanne Banks.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-diagnosticresult-path"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/lipid-triglyceride-1"
        },
        "name" : "Observation - Triglyceride",
        "description" : "Shows an example of a laboratory result for Triglyceride levels for the *AU Core Pathology Result Observation* profile. Patient: Mia Leanne Banks.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-diagnosticresult-path"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/pathresult-covid-1"
        },
        "name" : "Observation - COVID Pathology Result (Not detected)",
        "description" : "Shows an example of a COVID-19 PCR test result indicating 'Not detected' with notes on test accreditation and evaluation status for the *AU Core Pathology Result Observation* profile. Patient: Li Wang.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-diagnosticresult-path"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/resprate-1"
        },
        "name" : "Observation - Respiration rate",
        "description" : "Shows an example of a respiration rate observation for the *AU Core Respiration Rate* profile. Patient: Mia Leanne Banks.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-resprate"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/smokingstatus-current-smoker"
        },
        "name" : "Observation - Current smoker",
        "description" : "Shows an example of an observation of smoking status as a current smoker for the *AU Core Smoking Status* profile. Patient: Mr. Li Wang.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-smokingstatus"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/waistcircum-1"
        },
        "name" : "Observation - Waist Circumference",
        "description" : "Shows an example of a waist circumference measurement result for the *AU Core Waist Circumference* profile. Patient: Mia Leanne Banks.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-waistcircum"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/observation-masked"
        },
        "name" : "Observation - Data suppressed for category, code, effective[x] and value[x]",
        "description" : "Shows an example of an observation with suppressed data (category, code, effectivePeriod, and valueQuantity) where the data requester has access rights to know that data is suppressed for the  *AU Core Diagnostic Result Observation* profile. Patient: Ronny Lawrence Irvine.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-diagnosticresult"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/bobrester-medical-center"
        },
        "name" : "Organization - Bobrester Medical Centre",
        "description" : "Shows an example of an organisation, Bobrester Medical Centre, for the *AU Core Organization* profile, with ABN identifier, type as Medical Centre, and contact details including email and phone number.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-organization"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/murrabit-hospital"
        },
        "name" : "Organization - Murrabit Public Hospital",
        "description" : "Shows an example of an organisation, Murrabit Public Hospital, for the *AU Core Organization* profile, with a HPI-O, type as Hospital, and contact details including multiple phone numbers and email address.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-organization"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/mitchells-hill-audiology"
        },
        "name" : "Organization - Mitchells Hill Audiology",
        "description" : "Shows an example of an organisation, Mitchells Hill Audiology, for the *AU Core Organization* profile, with HPI-O and ABN identifiers, type specified as an audiology clinic, with contact details and an address.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-organization"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/ronny-irvine"
        },
        "name" : "Patient - Ronny Lawrence Irvine",
        "description" : "Shows an example of a patient resource for Mr. Ronny Lawrence Irvine for the *AU Core Patient* profile. The patient identifies as Torres Strait Islander but not of Aboriginal origin, with an unknown birth date represented using the Data Absent Reason extension.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-patient"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/bennelong-anne"
        },
        "name" : "Patient - Mrs. Anne Bennelong",
        "description" : "Shows an example of a patient resource for Mrs. Anne Bennelong for the *AU Core Patient* profile. The patient identifies as Aboriginal but not of Torres Strait Islander origin, speaks Yugambal as a primary language, and has a documented Medicare number.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-patient"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/wang-li"
        },
        "name" : "Patient - Mr. Li Wang",
        "description" : "Shows an example of a patient resource for Mr. Li Wang for the *AU Core Patient* profile. The patient is identified as neither Aboriginal nor Torres Strait Islander origin, speaks Cantonese as the preferred language, and has a Medical Record Number assigned by Large Metropolitan Hospital.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-patient"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/banks-mia-leanne"
        },
        "name" : "Patient - Mia Leanne Banks",
        "description" : "Shows an example of a patient resource for Mia Leanne Banks for the *AU Core Patient* profile. The patient identifies as female gender, uses the pronouns she/her, and has a verified IHI. The resource includes detailed contact information and a recorded biological sex at birth as female.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-patient"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/howe-deangelo"
        },
        "name" : "Patient - Deangelo HOWE",
        "description" : "Shows an example of a patient resource for Deangelo HOWE for the *AU Core Patient* profile. The patient has a verified IHI and identifies as neither Aboriginal nor Torres Strait Islander origin. The resource includes contact details, gender, date of birth, and address.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-patient"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/bobrester-bob"
        },
        "name" : "Practitioner - Dr. Bob Bobrester",
        "description" : "Shows an example of a practitioner resource for Dr. Bob Bobrester for the *AU Core Practitioner* profile. The resource includes the practitioner's name with a title prefix.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitioner"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/sallie-sutherland"
        },
        "name" : "Practitioner - Dr. Sallie Sutherland",
        "description" : "Shows an example of a practitioner resource for Dr. Sallie Sutherland with a HPI-I for the *AU Core Practitioner* profile. The resource includes the practitioner's official name and identifier details.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitioner"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/chau-fryer"
        },
        "name" : "Practitioner - Dr. Chau FRYER",
        "description" : "Shows an example of a practitioner resource for Dr. Chau Fryer with a HPI-I for the *AU Core Practitioner* profile. The resource includes the practitioner's official name and identifier details.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitioner"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/darleen-mackay"
        },
        "name" : "Practitioner - Darleen MACKAY",
        "description" : "Shows an example of a practitioner resource for Darleen Mackay with a HPI-I for the *AU Core Practitioner* profile. The resource includes the practitioner's name and identifier details.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitioner"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/bobrester-bob-gp"
        },
        "name" : "PractitionerRole - General practitioner",
        "description" : "Shows an example of a General Practitioner role for the *AU Core PractitionerRole* profile, including an employee number identifier, contact details and references to the associated Practitioner and Organization.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitionerrole"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/cardiologist-sallie-sutherland"
        },
        "name" : "PractitionerRole - Cardiologist",
        "description" : "Shows an example of a Cardiologist role for the *AU Core PractitionerRole* profile, including a Medicare Provider Number identifier, contact details, and references to the associated Practitioner, Organization, and Location.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitionerrole"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/surgeon-chau-fryer"
        },
        "name" : "PractitionerRole - Surgeon",
        "description" : "Shows an example of a Surgeon role for the *AU Core PractitionerRole* profile, including a Medicare Provider Number identifier, contact details, and references to the associated Practitioner, Organization, and Location.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitionerrole"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/nephrologist-darleen-mackay"
        },
        "name" : "PractitionerRole - Nephrologist",
        "description" : "Shows an example of a nephrologist for the *AU Core PractitionerRole* profile, using a local employee number as the role identifier and including a reference to the Practitioner.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitionerrole"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Procedure"
          }
        ],
        "reference" : {
          "reference" : "Procedure/dialysis"
        },
        "name" : "Procedure - Dialysis",
        "description" : "Shows an example of a completed haemodialysis procedure for the *AU Core Procedure* profile, with reason as a reference to a Condition resource. Patient: Ronny Lawrence Irvine.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-procedure"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Procedure"
          }
        ],
        "reference" : {
          "reference" : "Procedure/stentinsertion"
        },
        "name" : "Procedure - Stent insertion",
        "description" : "Shows an example of a completed stent placement procedure for the *AU Core Procedure* profile, demonstrating performed date, body site, reason, and focal device. Patient: Mr. Li Wang.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-procedure"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "RelatedPerson"
          }
        ],
        "reference" : {
          "reference" : "RelatedPerson/banks-mia-leanne-father"
        },
        "name" : "RelatedPerson - Father of Mia Leanne Banks",
        "description" : "Shows an example of a related person resource for the *AU Core RelatedPerson* profile, demonstrating relationship of father with name. Patient: Mia Leanne Banks.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-relatedperson"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "RelatedPerson"
          }
        ],
        "reference" : {
          "reference" : "RelatedPerson/wang-li-friend"
        },
        "name" : "RelatedPerson - Friend of Mr. Li Wang",
        "description" : "Shows an example of a related person resource for the *AU Core RelatedPerson* profile, demonstrating relationship of friend who is also an emergency contact, with name and telecom and address. Patient: Mr. Li Wang.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-relatedperson"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Specimen"
          }
        ],
        "reference" : {
          "reference" : "Specimen/nasoswab"
        },
        "name" : "Specimen - Naso swab (COVID test)",
        "description" : "Shows an example of a nasopharyngeal swab specimen referenced by the [Observation - COVID Pathology Result (Not detected)](Observation-pathresult-covid-1.html) example for the *AU Core Pathology Result Observation* profile. Patient: Mr. Li Wang.",
        "exampleCanonical" : "http://hl7.org/fhir/StructureDefinition/Specimen"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "HealthcareService"
          }
        ],
        "reference" : {
          "reference" : "HealthcareService/physiotherapy"
        },
        "name" : "HealthcareService - CoreStrength Physiotherapy",
        "description" : "Shows an example of a physiotherapy healthcare service, CoreStrength Physiotherapy, for the *AU Core HealthcareService* profile, with type and contact details.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-healthcareservice"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "HealthcareService"
          }
        ],
        "reference" : {
          "reference" : "HealthcareService/murrabit-crisis-hotline"
        },
        "name" : "HealthcareService - Murrabit Crisis Hotline",
        "description" : "Shows an example of a 24/7 telephone counselling service, Murrabit Crisis Hotline, for the *AU Core HealthcareService* profile, with healthcare service types, identifier and a telephone contact number.",
        "exampleCanonical" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-healthcareservice"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/au-core-diagnosticresult-path"
        },
        "name" : "AU Core Pathology Result Observation",
        "description" : "This profile sets minimum expectations for an Observation resource to record, search, and fetch pathology results associated with a patient. It is based on the [AU Base Pathology Result](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-pathologyresult.html) profile and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Observation when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/au-core-diagnosticresult"
        },
        "name" : "AU Core Diagnostic Result Observation",
        "description" : "This profile sets minimum expectations for an Observation resource to record, search, and fetch specialist or other diagnostic (non-imaging or non-pathology) results for a patient. It is based on the [AU Base Diagnostic Result](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-diagnosticresult.html) profile and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Observation when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/au-core-medicationstatement"
        },
        "name" : "AU Core MedicationStatement",
        "description" : "This profile sets minimum expectations for a MedicationStatement resource to record, search, and fetch summary statements of medication use associated with a patient. It is based on the [AU Base MedicationStatement](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-medicationstatement.html) profile and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the MedicationStatement when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/au-core-relatedperson"
        },
        "name" : "AU Core RelatedPerson",
        "description" : "This profile sets minimum expectations for a RelatedPerson resource to record, search, and fetch basic demographics and other administrative information about individual related persons associated with a patient. It is based on the [AU Base RelatedPerson](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-relatedperson.html) profile and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the RelatedPerson resource when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context."
      }
    ],
    "page" : {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
          "valueCode" : "informative"
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
          "valueUrl" : "toc.html"
        }
      ],
      "nameUrl" : "toc.html",
      "title" : "Table of Contents",
      "generation" : "html",
      "page" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index.html"
            }
          ],
          "nameUrl" : "index.html",
          "title" : "Home",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "conformance.html"
            }
          ],
          "nameUrl" : "conformance.html",
          "title" : "Conformance",
          "generation" : "markdown",
          "page" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                  "valueCode" : "informative"
                },
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "general-requirements.html"
                }
              ],
              "nameUrl" : "general-requirements.html",
              "title" : "General Requirements",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                  "valueCode" : "informative"
                },
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "declaring-conformance.html"
                }
              ],
              "nameUrl" : "declaring-conformance.html",
              "title" : "Declaring Conformance",
              "generation" : "markdown"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "guidance.html"
            }
          ],
          "nameUrl" : "guidance.html",
          "title" : "Guidance",
          "generation" : "markdown",
          "page" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                  "valueCode" : "informative"
                },
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "general-guidance.html"
                }
              ],
              "nameUrl" : "general-guidance.html",
              "title" : "General Guidance",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                  "valueCode" : "informative"
                },
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "medicine-information.html"
                }
              ],
              "nameUrl" : "medicine-information.html",
              "title" : "Medicine Information",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                  "valueCode" : "informative"
                },
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "sex-and-gender.html"
                }
              ],
              "nameUrl" : "sex-and-gender.html",
              "title" : "Sex and Gender",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                  "valueCode" : "informative"
                },
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "aucdi.html"
                }
              ],
              "nameUrl" : "aucdi.html",
              "title" : "AUCDI",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                  "valueCode" : "informative"
                },
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "relationship.html"
                }
              ],
              "nameUrl" : "relationship.html",
              "title" : "Relationship With Other IGs",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                  "valueCode" : "informative"
                },
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "comparison.html"
                }
              ],
              "nameUrl" : "comparison.html",
              "title" : "Comparison With Other National and International IGs",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                  "valueCode" : "informative"
                },
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "variance.html"
                }
              ],
              "nameUrl" : "variance.html",
              "title" : "AU Variance Statement",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                  "valueCode" : "informative"
                },
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "future.html"
                }
              ],
              "nameUrl" : "future.html",
              "title" : "Future of AU Core",
              "generation" : "markdown"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "security.html"
            }
          ],
          "nameUrl" : "security.html",
          "title" : "Security and Privacy",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "fhirartefacts.html"
            }
          ],
          "nameUrl" : "fhirartefacts.html",
          "title" : "FHIR Artefacts",
          "generation" : "markdown",
          "page" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                  "valueCode" : "informative"
                },
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "artifacts.html"
                }
              ],
              "nameUrl" : "artifacts.html",
              "title" : "Artefacts Summary",
              "generation" : "html"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                  "valueCode" : "informative"
                },
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "profiles-and-extensions.html"
                }
              ],
              "nameUrl" : "profiles-and-extensions.html",
              "title" : "Profiles and Extensions",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                  "valueCode" : "informative"
                },
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "search-parameters.html"
                }
              ],
              "nameUrl" : "search-parameters.html",
              "title" : "Search Parameters",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                  "valueCode" : "informative"
                },
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "terminology.html"
                }
              ],
              "nameUrl" : "terminology.html",
              "title" : "Terminology",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                  "valueCode" : "informative"
                },
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "capability-statements.html"
                }
              ],
              "nameUrl" : "capability-statements.html",
              "title" : "Capability Statements",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                  "valueCode" : "informative"
                },
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "actors.html"
                }
              ],
              "nameUrl" : "actors.html",
              "title" : "Actor Definitions",
              "generation" : "markdown"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "examples.html"
            }
          ],
          "nameUrl" : "examples.html",
          "title" : "Examples",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "support.html"
            }
          ],
          "nameUrl" : "support.html",
          "title" : "Support",
          "generation" : "markdown",
          "page" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                  "valueCode" : "informative"
                },
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "downloads.html"
                }
              ],
              "nameUrl" : "downloads.html",
              "title" : "Downloads",
              "generation" : "markdown"
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
                  "valueCode" : "informative"
                },
                {
                  "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
                  "valueUrl" : "license.html"
                }
              ],
              "nameUrl" : "license.html",
              "title" : "License and Legal",
              "generation" : "markdown"
            }
          ]
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
              "valueCode" : "informative"
            },
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "changes.html"
            }
          ],
          "nameUrl" : "changes.html",
          "title" : "Change Log",
          "generation" : "markdown"
        }
      ]
    },
    "parameter" : [
      {
        "code" : "path-resource",
        "value" : "input/resources"
      },
      {
        "code" : "path-resource",
        "value" : "input/capabilities"
      },
      {
        "code" : "path-resource",
        "value" : "input/examples"
      },
      {
        "code" : "path-resource",
        "value" : "input/extensions"
      },
      {
        "code" : "path-resource",
        "value" : "input/models"
      },
      {
        "code" : "path-resource",
        "value" : "input/operations"
      },
      {
        "code" : "path-resource",
        "value" : "input/profiles"
      },
      {
        "code" : "path-resource",
        "value" : "input/vocabulary"
      },
      {
        "code" : "path-resource",
        "value" : "input/testing"
      },
      {
        "code" : "path-resource",
        "value" : "input/history"
      },
      {
        "code" : "path-resource",
        "value" : "fsh-generated/resources"
      },
      {
        "code" : "path-pages",
        "value" : "template/config"
      },
      {
        "code" : "path-pages",
        "value" : "input/images"
      },
      {
        "code" : "path-tx-cache",
        "value" : "input-cache/txcache"
      }
    ]
  }
}

```
