# AUCDI - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**Guidance**](guidance.md)
* **AUCDI**

## AUCDI

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

[Australian Clinical Data for Interoperability (AUCDI)](https://sparked.csiro.au/index.php/sparked-products-resources/aucdi/) and AU Core complement each other assisting in common understanding of clinical data concepts when implemented in systems and exchanged between systems.

AUCDI defines data groups comprising one or more data elements and references clinical terminology concepts, forming the foundation of a common language to allow systems to exchange semantically accurate data more efficiently. AUCDI defines clinical requirements for the data required to support the provision of care, exchange, aggregation for analysis, and to support clinical decision support. AUCDI may define requirements that are future focussed and as yet do not align with system implementation of the clinical concept.

AU Core is a technical specification that addresses constraints and obligations on data representation for exchange. AU Core enables system data to be mapped to an agreed FHIR format and defines capability requirements to share data via FHIR RESTful API interactions.

**Figure 1: AUCDI and AU Core development approach** 


An interpretation of AUCDI clinical information requirements through community consensus is undertaken to define support for the exchange of clinical and administrative data within technical constraints. Note that:

* In any particular release, AU Core may not cover all AUCDI data concepts, especially when AUCDI data concepts are not supported in existing systems.
* AU Core includes exchange for concepts that are commonly implemented in systems and not included in AUCDI e.g. `Patient.name`, `Practitioner.identifier`, `Procedure.encounter`.
* AU Core includes exchange for clinical concepts not yet included in AUCDI e.g. MedicationRequest.
* AU Core includes data elements not included in AUCDI that are required to make FHIR implementable e.g. `Observation.status`, `MedicationRequest.intent`, Provenance.
* Neither AUCDI nor AU Core are required to be implemented as a whole single product. Parts can be implemented as required for specific use cases.

### AUCDI and AU Core Versions

AUCDI and AU Core are updated periodically, and each expand upon the initial core set. AUCDI R2 builds upon R1, expanding on the initial “core”, introducing additional data groups to support different use cases:

| | |
| :--- | :--- |
| R1 | 1.0.0 |
| R2 (Core) | 2.0.0 |

### AUCDI (Core) Mappings Into AU Core

The table below shows the relationship between data defined in the "Core" AUCDI Data Groups and Elements and expected usage in AU Core profiles.
 Column attribute descriptions are as follows:

* **AUCDI Data Group**: The name of the AUCDI data group.
* **AUCDI Data Element**: The name of the AUCDI data element within an AUCDI data group.
* **AU Core Profile(s)**: The title of the AU Core profile relevant for exchange.
* **FHIR Path**: The [FHIRPath expression](https://build.fhir.org/ig/HL7/FHIRPath/) to the FHIR element relevant for exchange, i.e. the FHIR element that can be populated with data from a source system that represents the clinical concept expressed in the AUCDI data element.
* **Comment**: Additional information about the mapping including an explanation of where an element or group is not yet mapped.

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| Adverse reaction risk summary | Substance name | [AU Core AllergyIntolerance](StructureDefinition-au-core-allergyintolerance.md) | `AllergyIntolerance.code` |  |
| Manifestation | [AU Core AllergyIntolerance](StructureDefinition-au-core-allergyintolerance.md) | `AllergyIntolerance.reaction` |  | |
| Comment | [AU Core AllergyIntolerance](StructureDefinition-au-core-allergyintolerance.md) | `AllergyIntolerance.note` |  | |
| Last updated | - | - | This AUCDI element is a[Future Candidate Requirement Under Consideration](future.md#future-candidate-requirements-under-consideration). Future versions of AU Core will develop and test approaches to addressing Last Updated. | |
| Blood pressure | Systolic pressure | [AU Core Blood Pressure](StructureDefinition-au-core-bloodpressure.md) | `Observation` |  |
| Diastolic pressure | [AU Core Blood Pressure](StructureDefinition-au-core-bloodpressure.md) | `Observation` |  | |
| Date/Time of measurement | [AU Core Blood Pressure](StructureDefinition-au-core-bloodpressure.md) | `Observation.effectiveDateTime` |  | |
| Body height | Height / Length | [AU Core Body Height](StructureDefinition-au-core-bodyheight.md) | `Observation` |  |
| Date/Time of measurement | [AU Core Body Height](StructureDefinition-au-core-bodyheight.md) | `Observation.effectiveDateTime` |  | |
| Body temperature | Temperature | [AU Core Body Temperature](StructureDefinition-au-core-bodytemp.md) | `Observation` |  |
| Date/Time of measurement | [AU Core Body Temperature](StructureDefinition-au-core-bodytemp.md) | `Observation.effectiveDateTime` |  | |
| Body weight | Weight | [AU Core Body Weight](StructureDefinition-au-core-bodyweight.md) | `Observation` |  |
| Date/Time of measurement | [AU Core Body Weight](StructureDefinition-au-core-bodyweight.md) | `Observation.effectiveDateTime` |  | |
| Encounter | Reason for encounter | [AU Core Encounter](StructureDefinition-au-core-encounter.md) | `Encounter.reasonCode`|`Encounter.reasonReference` |  |
| Modality | [AU Core Encounter](StructureDefinition-au-core-encounter.md) | `Encounter.class` |  | |
| Estimated glomerular filtration rate (eGFR) | eGFR | [AU Core Pathology Result Observation](StructureDefinition-au-core-diagnosticresult-path.md) | `Observation` |  |
| Date/Time of measurement | [AU Core Pathology Result Observation](StructureDefinition-au-core-diagnosticresult-path.md) | `Observation.effectiveDateTime` |  | |
| Haemoglobin A1c (HbA1c) | HbA1c | [AU Core Pathology Result Observation](StructureDefinition-au-core-diagnosticresult-path.md) | `Observation` |  |
| Date/Time of measurement | [AU Core Pathology Result Observation](StructureDefinition-au-core-diagnosticresult-path.md) | `Observation.effectiveDateTime` |  | |
| Lipids | HDL cholesterol | [AU Core Pathology Result Observation](StructureDefinition-au-core-diagnosticresult-path.md) | `Observation` |  |
| LDL cholesterol | [AU Core Pathology Result Observation](StructureDefinition-au-core-diagnosticresult-path.md) | `Observation` |  | |
| Total cholesterol | [AU Core Pathology Result Observation](StructureDefinition-au-core-diagnosticresult-path.md) | `Observation` |  | |
| Triglycerides | [AU Core Pathology Result Observation](StructureDefinition-au-core-diagnosticresult-path.md) | `Observation` |  | |
| Date/Time of measurement | [AU Core Pathology Result Observation](StructureDefinition-au-core-diagnosticresult-path.md) | `Observation.effectiveDateTime` |  | |
| Medication use statement | Medication name | [AU Core MedicationStatement](StructureDefinition-au-core-medicationstatement.md)|[AU Core Medication](StructureDefinition-au-core-medication.md) | `MedicationStatement.medication[x]`|`Medication.code` | See[Medicine Information](medicine-information.md)guidance. |
| Clinical indication | [AU Core MedicationStatement](StructureDefinition-au-core-medicationstatement.md) | `MedicationStatement.reasonCode`|`MedicationStatement.reasonReference` | | |
| Strength | [AU Core MedicationStatement](StructureDefinition-au-core-medicationstatement.md)|[AU Core Medication](StructureDefinition-au-core-medication.md) | `MedicationStatement.medication[x]`|`Medication.code`|`Medication.ingredient` | | |
| Form | [AU Core MedicationStatement](StructureDefinition-au-core-medicationstatement.md)|[AU Core Medication](StructureDefinition-au-core-medication.md) | `MedicationStatement.medication[x]`|`Medication.form` | | |
| Dose amount | [AU Core MedicationStatement](StructureDefinition-au-core-medicationstatement.md) | `MedicationStatement.dosage.doseAndRate` | | |
| Route of administration | [AU Core MedicationStatement](StructureDefinition-au-core-medicationstatement.md) | `MedicationStatement.dosage.route` | | |
| Dose timing | [AU Core MedicationStatement](StructureDefinition-au-core-medicationstatement.md) | `MedicationStatement.dosage.timing` | | |
| Comment | [AU Core MedicationStatement](StructureDefinition-au-core-medicationstatement.md) | `MedicationStatement.note` | | |
| Date of assertion | [AU Core MedicationStatement](StructureDefinition-au-core-medicationstatement.md) | `MedicationStatement.dateAsserted` | | |
| Problem/Diagnosis summary | Problem / Diagnosis name | [AU Core Condition](StructureDefinition-au-core-condition.md) | `Condition.code` |  |
| Body site | [AU Core Condition](StructureDefinition-au-core-condition.md) | `Condition.code` |  | |
| Status | [AU Core Condition](StructureDefinition-au-core-condition.md) | `Condition.clinicalStatus` |  | |
| Comment | [AU Core Condition](StructureDefinition-au-core-condition.md) | `Condition.note` |  | |
| Last updated | - | - | This AUCDI element is a[Future Candidate Requirement Under Consideration](future.md#future-candidate-requirements-under-consideration). Future versions of AU Core will develop and test approaches to addressing Last Updated. | |
| Procedure | Procedure name | [AU Core Procedure](StructureDefinition-au-core-procedure.md) | `Procedure.code` |  |
| Clinical indication | [AU Core Procedure](StructureDefinition-au-core-procedure.md) | `Procedure.reasonCode`|`Procedure.reasonReference[x]` |  | |
| Body site/laterality | [AU Core Procedure](StructureDefinition-au-core-procedure.md) | `Procedure.code` |  | |
| Date/time performed | [AU Core Procedure](StructureDefinition-au-core-procedure.md) | `Procedure.performed[x]`|`Procedure.performedDateTime` |  | |
| Comment | [AU Core Procedure](StructureDefinition-au-core-procedure.md) | `Procedure.note` |  | |
| Pulse | Rate | [AU Core Heart Rate](StructureDefinition-au-core-heartrate.md) | `Observation` |  |
| Date/Time of observation | [AU Core Heart Rate](StructureDefinition-au-core-heartrate.md) | `Observation.effectiveDateTime` |  | |
| Respiration | Rate | [AU Core Respiration Rate](StructureDefinition-au-core-resprate.md) | `Observation` |  |
| Date/Time of observation | [AU Core Respiration Rate](StructureDefinition-au-core-resprate.md) | `Observation.effectiveDateTime` |  | |
| Sex and gender summary | Sex assigned at birth | [AU Core Patient](StructureDefinition-au-core-patient.md) | `Patient.extension.where(url='http://hl7.org/fhir/StructureDefinition/individual-recordedSexOrGender')` | The[Person Recorded Sex or Gender extension](http://hl7.org/fhir/StructureDefinition/individual-recordedSexOrGender)is profiled by[AU Core Sex Assigned At Birth (RSG)](StructureDefinition-au-core-rsg-sexassignedab.md)to represent the concept of Sex assigned at birth. |
| Gender identity | [AU Core Patient](StructureDefinition-au-core-patient.md) | `Patient.extension.where(url='http://hl7.org/fhir/StructureDefinition/individual-genderIdentity')` |  | |
| Pronoun/s | [AU Core Patient](StructureDefinition-au-core-patient.md) | `Patient.extension.where(url='http://hl7.org/fhir/StructureDefinition/individual-pronouns')` |  | |
| Last updated | - | - | This AUCDI element is a[Future Candidate Requirement Under Consideration](future.md#future-candidate-requirements-under-consideration). Future versions of AU Core will develop and test approaches to addressing Last Updated. | |
| Tobacco smoking summary | Overall status | [AU Core Smoking Status](StructureDefinition-au-core-smokingstatus.md) | `Observation` |  |
| Last updated | - | - | This AUCDI element is a[Future Candidate Requirement Under Consideration](future.md#future-candidate-requirements-under-consideration). Future versions of AU Core will develop and test approaches to addressing Last Updated. | |
| Urine albumin-creatinine ratio (uACR) | uACR | [AU Core Pathology Result Observation](StructureDefinition-au-core-diagnosticresult-path.md) | `Observation` |  |
| Date/Time of measurement | [AU Core Pathology Result Observation](StructureDefinition-au-core-diagnosticresult-path.md) | `Observation.effectiveDateTime` |  | |
| Vaccination | Vaccine name | [AU Core Immunization](StructureDefinition-au-core-immunization.md) | `Immunization.vaccineCode` |  |
| Sequence | [AU Core Immunization](StructureDefinition-au-core-immunization.md) | `Immunization.protocolApplied.doseNumber[x]` |  | |
| Date of administration | [AU Core Immunization](StructureDefinition-au-core-immunization.md) | `Immunization.occurenceDateTime` |  | |
| Comment | [AU Core Immunization](StructureDefinition-au-core-immunization.md) | `Immunization.note` |  | |
| Waist circumference | Waist circumference | [AU Core Waist Circumference](StructureDefinition-au-core-waistcircum.md) | `Observation` |  |
| Date/Time of measurement | [AU Core Waist Circumference](StructureDefinition-au-core-waistcircum.md) | `Observation.effectiveDateTime` |  | |

