# Artefacts Summary - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* **Artefacts Summary**

## Artefacts Summary

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Requirements: Actor Definitions 

The following artifacts define the types of individuals and/or systems that will interact as part of the use cases covered by this implementation guide.

| | |
| :--- | :--- |
| [AU Core Requester](ActorDefinition-au-core-actor-requester.md) | The AU Core Requester is a system that creates and initiates a data access request to retrieve core digital health and administrative information. |
| [AU Core Responder](ActorDefinition-au-core-actor-responder.md) | The AU Core Responder is a system responsible for providing responses to queries submitted by AU Core Requesters. |

### Behavior: Capability Statements 

The following artifacts define the specific capabilities that different types of systems are expected to have in order to comply with this implementation guide. Systems conforming to this implementation guide are expected to declare conformance to one or more of the following capability statements.

| | |
| :--- | :--- |
| [AU Core Requester CapabilityStatement](CapabilityStatement-au-core-requester.md) | This CapabilityStatement describes the basic rules for the [AU Core Requester actor](ActorDefinition-au-core-actor-requester.md) that is responsible for creating and initiating the queries for information. The complete list of FHIR profiles, RESTful operations, and search parameters supported by AU Core Requesters are defined in this CapabilityStatement. |
| [AU Core Responder CapabilityStatement](CapabilityStatement-au-core-responder.md) | This CapabilityStatement describes the basic rules for the [AU Core Responder actor](ActorDefinition-au-core-actor-responder.md) that is responsible for providing responses to queries submitted by AU Core Requesters. The complete list of FHIR profiles, RESTful operations, and search parameters supported by AU Core Responders are defined in this CapabilityStatement. |

### Behavior: Search Parameters 

These define the properties by which a RESTful server can be searched. They can also be used for sorting and including related resources.

| | |
| :--- | :--- |
| [AUCoreClinicalPatient](SearchParameter-au-core-clinical-patient.md) | This SearchParameter describes the rules on the clinical-patient search parameter in AU Core. It is based on the FHIR [clinical-patient](https://hl7.org/fhir/R4/searchparameter-registry.html#clinical-patient) search parameter and identifies the additional requirements when conforming to AU Core. |
| [AUCorePractitionerRolePractitioner](SearchParameter-au-core-practitionerrole-practitioner.md) | This SearchParameter describes the rules on the PractitionerRole-practitioner search parameter in AU Core. It is based on the FHIR [PractitionerRole-practitioner](https://hl7.org/fhir/R4/practitionerrole.html#search) search parameter and identifies the additional requirements when conforming to AU Core. |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [AU Core AllergyIntolerance](StructureDefinition-au-core-allergyintolerance.md) | This profile sets minimum expectations for an AllergyIntolerance resource to record, search, and fetch allergies/adverse reactions associated with a patient. It is based on the [AU Base AllergyIntolerance](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-allergyintolerance.html) profile and identifies the **additional** mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the AllergyIntolerance resource when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context. |
| [AU Core Blood Pressure](StructureDefinition-au-core-bloodpressure.md) | This profile sets minimum expectations for an Observation resource to record, search, and fetch blood pressure observations with standard coding and units of measure. It is based on the [FHIR Blood Pressure Profile](http://hl7.org/fhir/R4/bp.html) and identifies the **additional** mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Observation resource when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context. |
| [AU Core Body Height](StructureDefinition-au-core-bodyheight.md) | This profile sets minimum expectations for an Observation resource to record, search, and fetch body height observations with standard coding and units of measure. It is based on the [FHIR Body Height Profile](http://hl7.org/fhir/R4/bodyheight.html) and identifies the **additional** mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Observation resource when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context. |
| [AU Core Body Temperature](StructureDefinition-au-core-bodytemp.md) | This profile sets minimum expectations for an Observation resource to record, search, and fetch body temperature observations with standard coding and units of measure. It is based on the [FHIR Body Temperature Profile](http://hl7.org/fhir/R4/bodytemp.html) and identifies the **additional** mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Observation resource when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context. |
| [AU Core Body Weight](StructureDefinition-au-core-bodyweight.md) | This profile sets minimum expectations for an Observation resource to record, search, and fetch body weight observations with standard coding and units of measure. It is based on the [FHIR Body Weight Profile](http://hl7.org/fhir/R4/bodyweight.html) and identifies the **additional** mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Observation resource when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context. |
| [AU Core Condition](StructureDefinition-au-core-condition.md) | This profile sets minimum expectations for a Condition resource to record, search, and fetch problems, diagnoses, and health concerns associated with a patient. It is based on the [AU Base Condition](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-condition.html) profile and identifies the **additional** mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Condition resource when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context. |
| [AU Core Diagnostic Result Observation](StructureDefinition-au-core-diagnosticresult.md) | This profile sets minimum expectations for an Observation resource to record, search, and fetch specialist or other diagnostic (non-imaging or non-pathology) results for a patient. It is based on the [AU Base Diagnostic Result](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-diagnosticresult.html) profile and identifies the **additional** mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Observation when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context. |
| [AU Core Encounter](StructureDefinition-au-core-encounter.md) | This profile sets minimum expectations for an Encounter resource to record, search, and fetch basic encounter information for a patient. It is based on the [AU Base Encounter](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-encounter.html) profile and identifies the **additional** mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Encounter when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context. |
| [AU Core HealthcareService](StructureDefinition-au-core-healthcareservice.md) | This profile sets minimum expectations for a HealthcareService resource to record, search, and fetch information about a healthcare service. It is based on the [AU Base HealthcareService](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-healthcareservice.html) profile and identifies the **additional** mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the HealthcareService resource when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context. |
| [AU Core Heart Rate](StructureDefinition-au-core-heartrate.md) | This profile sets minimum expectations for an Observation resource to record, search, and fetch heart rate observations with standard coding and units of measure. It is based on the [FHIR Heart Rate Profile](http://hl7.org/fhir/R4/heartrate.html) and identifies the **additional** mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Observation resource when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context. |
| [AU Core Immunization](StructureDefinition-au-core-immunization.md) | This profile sets minimum expectations for an Immunization resource to record, search, and fetch immunisation history associated with a patient. It is based on the [AU Base Immunization](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-immunization.html) profile and identifies the **additional** mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Immunization resource when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context. |
| [AU Core Location](StructureDefinition-au-core-location.md) | This profile sets minimum expectations for a Location resource to record, search, and fetch information about a location. It is based on the [AU Base Location](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-location.html) profile and identifies the **additional** mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Location when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context. |
| [AU Core Medication](StructureDefinition-au-core-medication.md) | This profile sets minimum expectations for a Medication resource to record, search, and fetch medications associated with a patient. It is based on the [AU Base Medication](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-medication.html) profile and identifies the **additional** mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Medication when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context.In AU Core a Medication resource is used within the context of a referencing resource: MedicationAdministration, MedicationDispense, MedicationRequest, or MedicationStatement resource. |
| [AU Core MedicationRequest](StructureDefinition-au-core-medicationrequest.md) | This profile sets minimum expectations for a MedicationRequest resource to record, search, and fetch medication orders and requests (i.e. prescriptions) associated with a patient. It is based on the [AU Base MedicationRequest](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-medicationrequest.html) profile and identifies the **additional** mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the MedicationRequest when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context. |
| [AU Core MedicationStatement](StructureDefinition-au-core-medicationstatement.md) | This profile sets minimum expectations for a MedicationStatement resource to record, search, and fetch summary statements of medication use associated with a patient. It is based on the [AU Base MedicationStatement](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-medicationstatement.html) profile and identifies the **additional** mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the MedicationStatement when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context. |
| [AU Core Organization](StructureDefinition-au-core-organization.md) | This profile sets minimum expectations for a Organization resource to record, search, and fetch information about an organisation. It is based on the [AU Base Organization](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-organization.html) profile and identifies the **additional** mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Organization when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context. |
| [AU Core Pathology Result Observation](StructureDefinition-au-core-diagnosticresult-path.md) | This profile sets minimum expectations for an Observation resource to record, search, and fetch pathology results associated with a patient. It is based on the [AU Base Pathology Result](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-pathologyresult.html) profile and identifies the **additional** mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Observation when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context. |
| [AU Core Patient](StructureDefinition-au-core-patient.md) | This profile sets minimum expectations for a Patient resource to record, search, and fetch basic demographics and other administrative information about an individual patient. It is based on the [AU Base Patient](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-patient.html) profile and identifies the **additional** mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Patient when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context. |
| [AU Core Practitioner](StructureDefinition-au-core-practitioner.md) | This profile sets minimum expectations for a Practitioner resource to record, search, and fetch basic demographics and other administrative information about an individual practitioner. It is based on the [AU Base Practitioner](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-practitioner.html) profile and identifies the **additional** mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Practitioner when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context. |
| [AU Core PractitionerRole](StructureDefinition-au-core-practitionerrole.md) | This profile sets minimum expectations for a PractitionerRole resource to record, search, and fetch a practitioner role for a practitioner associated with a patient. It is based on the [AU Base PractitionerRole](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-practitionerrole.html) profile and identifies the **additional** mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the PractitionerRole resource when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context. |
| [AU Core Procedure](StructureDefinition-au-core-procedure.md) | This profile sets minimum expectations for a Procedure resource to record, search, and fetch procedures associated with a patient. It is based on the [AU Base Procedure](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-procedure.html) profile and identifies the **additional** mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Procedure resource when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context. |
| [AU Core RelatedPerson](StructureDefinition-au-core-relatedperson.md) | This profile sets minimum expectations for a RelatedPerson resource to record, search, and fetch basic demographics and other administrative information about individual related persons associated with a patient. It is based on the [AU Base RelatedPerson](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-relatedperson.html) profile and identifies the **additional** mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the RelatedPerson resource when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context. |
| [AU Core Respiration Rate](StructureDefinition-au-core-resprate.md) | This profile sets minimum expectations for an Observation resource to record, search, and fetch respiration rate observations with standard coding and units of measure. It is based on the [FHIR Respiratory Rate Profile](http://hl7.org/fhir/R4/resprate.html) and identifies the **additional** mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Observation resource when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context. |
| [AU Core Smoking Status](StructureDefinition-au-core-smokingstatus.md) | This profile sets minimum expectations for an Observation resource to record, search, and fetch observations that represent a patient’s smoking status, i.e. current behaviour for all types of tobacco smoking, with standard coding. It is based on the FHIR [Observation](http://hl7.org/fhir/R4/observation.html) resource and identifies the **additional** mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Observation resource when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context. |
| [AU Core Waist Circumference](StructureDefinition-au-core-waistcircum.md) | This profile sets minimum expectations for an Observation resource to record, search, and fetch waist circumference observations with standard coding and units of measure. It is based on the [FHIR Vital Signs Profile](http://hl7.org/fhir/R4/vitalsigns.html) and identifies the **additional** mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Observation resource when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context. |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [AU Core Sex Assigned At Birth](StructureDefinition-au-core-rsg-sexassignedab.md) | This profile defines the minimum expectations for a [Person Recorded Sex or Gender extension](https://hl7.org/fhir/extensions/StructureDefinition-individual-recordedSexOrGender.html) when representing Sex Assigned at Birth. This profile identifies the **additional** mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Extension when conforming to this profile. |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [AllergyIntolerance - Lactose intolerance](AllergyIntolerance-lactose.md) | Shows an example of Lactose intolerance with manifestations of abdominal pain, bloating, and diarrhoea for the **AU Core AllergyIntolerance** profile. Patient: Mia Leanne Banks. |
| [AllergyIntolerance - No known allergy](AllergyIntolerance-noneknown.md) | Shows an example of allergy intolerance for the **AU Core AllergyIntolerance** profile indicating the patient has no known allergies. Patient: Mr. Li Wang. |
| [AllergyIntolerance - Penicillin allergy](AllergyIntolerance-penicillin.md) | Shows an example of a Penicillin allergy with the reaction manifestation as hives for the **AU Core AllergyIntolerance** profile. Patient: Deangelo HOWE. |
| [Condition - Chronic Kidney Disease](Condition-ckd.md) | Shows an example of active Chronic Kidney Disease with onset age for the **AU Core Condition** profile. Patient: Ronny Lawrence Irvine. |
| [Condition - Data suppressed for category and code](Condition-condition-masked.md) | Shows an example of a condition with suppressed data (category and code) where the data requester has access rights to know that data is suppressed for the **AU Core Condition** profile. Patient: Anne Bennelong. |
| [Condition - No known condition](Condition-noknown.md) | Shows an example of no known conditions for the **AU Core Condition** profile. Patient: Deangelo HOWE. |
| [Condition - Urinary tract infection](Condition-uti.md) | Shows an example of a resolved urinary tract infection with onset and abatement age for the **AU Core Condition** profile. Patient: Mia Leanne Banks. |
| [Encounter - COVID 19 Vaccine Administration Dose 1](Encounter-covid-admin-1.md) | Shows an example of a COVID-19 vaccine administration encounter for the **AU Core Encounter** profile. Patient: Mrs. Anne Bennelong. |
| [Encounter - Discharge](Encounter-discharge-1.md) | Shows an example of a completed emergency encounter for the **AU Core Encounter** profile. Patient: Ronny Lawrence Irvine. |
| [Encounter - telehealth](Encounter-telehealth.md) | Shows an example of a completed virtual telehealth encounter for the **AU Core Encounter** profile. Patient: Mrs. Anne Bennelong. |
| [HealthcareService - CoreStrength Physiotherapy](HealthcareService-physiotherapy.md) | Shows an example of a physiotherapy healthcare service, CoreStrength Physiotherapy, for the **AU Core HealthcareService** profile, with type and contact details. |
| [HealthcareService - Murrabit Crisis Hotline](HealthcareService-murrabit-crisis-hotline.md) | Shows an example of a 24/7 telephone counselling service, Murrabit Crisis Hotline, for the **AU Core HealthcareService** profile, with healthcare service types, identifier and a telephone contact number. |
| [Immunization - Administration of Zoster vaccination refused](Immunization-zoster-notgiven.md) | Shows an example of a vaccination not administered due to patient's refusal for the **AU Core Immunization** profile. Patient: Deangelo HOWE. |
| [Immunization - COVID Dose 1](Immunization-covid-1.md) | Shows an example of administered COVID-19 vaccine for the **AU Core Immunization** profile. Patient: Mrs. Anne Bennelong. |
| [Location - Murrabit Public Hospital](Location-murrabit-hospital.md) | Shows an example of the Murrabit Public Hospital location for the **AU Core Location** profile. |
| [Location - Patient home](Location-patient-home.md) | Shows an example of patient's home location example for the **AU Core Location** profile. |
| [Location - Tindal Building](Location-bobrester-medical-center.md) | Shows an example of Tindal Building location for the **AU Core Location** profile. |
| [Medication - Branded pack with one active ingredient](Medication-1active-ingredient.md) | Shows an example of a branded medication, Chlorsig (chloramphenicol 0.5%), with one active ingredient for the **AU Core Medication** profile. Includes a medication type extension indicating a branded product with no specified strength or form. |
| [Medication - Product with two active ingredients](Medication-2active-ingredients.md) | Shows an example of a combination medication, perindopril arginine 10 mg + amlodipine 10 mg tablets, for the **AU Core Medication** profile. Includes a PBS code for the medication. |
| [Medication - Simvastatin 40 MG Disintegrating Oral Tablet](Medication-simvastatin.md) | Shows an example of Simvastatin 40 mg oral tablet for the **AU Core Medication** profile. Includes a SNOMED CT code for the medication. |
| [MedicationRequest - active prescription, Reaptan](MedicationRequest-reaptan.md) | Shows an example of an order for Reaptan 10 mg/10 mg for the **AU Core MedicationRequest** profile. The request includes the reason code, a reference to a contained Medication resource, and dosage instructions. Patient: Mr. Li Wang. |
| [MedicationRequest - active prescription, Simvastatin](MedicationRequest-simvastatin.md) | Shows an example of an order for Simvastatin 40 mg oral tablet for high cholesterol for the **AU Core MedicationRequest** profile, demonstrating representation of medication as a reference to a Medication resource. Patient: Mr. Li Wang. |
| [MedicationRequest - prescription, paracetamol 500 mg + codeine phosphate hemihydrate 30 mg](MedicationRequest-paracetamol-codeine.md) | Shows an example of an order for paracetamol 500 mg + codeine phosphate hemihydrate 30 mg tablet for pain management for the **AU Core MedicationRequest** profile illustrating missing data for status and requester. Patient: Mrs. Anne Bennelong. |
| [MedicationStatement - active use of Bisoprolol 2.5mg](MedicationStatement-active-bisoprolol.md) | Shows an example of current (active) use of Bisolprolol 2.5mg with dosage text for the **AU Core MedicationStatement** profile. This example demonstrates representation of medication as a reference to a contained Medication resource. Patient: Mia Leanne Banks. |
| [MedicationStatement - completed use of Bactrim DS](MedicationStatement-completed-bactrim.md) | Shows an example of completed use of Bactrim DS tablet due to a urinary tract infection (reasonReference) for the **AU Core MedicationStatement** profile. Patient: Mia Leanne Banks. |
| [MedicationStatement - completed use of Chloramphenicol 1% eye ointment](MedicationStatement-completed-chloramphenicol.md) | Shows an example of completed use of Chloramphenicol 1% eye ointment due to Adult gonococcal conjunctivitis (reasonCode) for the **AU Core MedicationStatement** profile. Patient: Mia Leanne Banks. |
| [MedicationStatement - patient has taken Diflucan in the past but is not taking it any more](MedicationStatement-previous-use-diflucan.md) | Shows an example of the previous use of Diflucan 200 mg/100 mL injection and the patient is not currently on this medicine for the **AU Core MedicationStatement** profile. This example demonstrates representation of additional AUCDI concepts for dosage including route, timing, dose and rate. Patient: Mia Leanne Banks. |
| [Observation - Blood Pressure (data absent for diastolic)](Observation-bloodpressure-data-absent.md) | Shows an example of a blood pressure observation for the **AU Core Blood Pressure** profile, where the systolic value is recorded and the diastolic value is marked as unknown using the Data Absent Reason extension. Patient: Ronny Lawrence Irvine. |
| [Observation - Blood Pressure (systolic and diastolic)](Observation-bloodpressure-1.md) | Shows an example of a blood pressure observation with both systolic and diastolic measurements for the **AU Core Blood Pressure** profile. Patient: Mr. Li Wang. |
| [Observation - Body weight](Observation-bodyweight-1.md) | Shows an example of a body weight observation for the **AU Core Body Weight** profile. Patient: Mia Leanne Banks. |
| [Observation - COVID Pathology Result (Not detected)](Observation-pathresult-covid-1.md) | Shows an example of a COVID-19 PCR test result indicating 'Not detected' with notes on test accreditation and evaluation status for the **AU Core Pathology Result Observation** profile. Patient: Li Wang. |
| [Observation - Current smoker](Observation-smokingstatus-current-smoker.md) | Shows an example of an observation of smoking status as a current smoker for the **AU Core Smoking Status** profile. Patient: Mr. Li Wang. |
| [Observation - Data suppressed for category, code, effective[x] and value[x]](Observation-observation-masked.md) | Shows an example of an observation with suppressed data (category, code, effectivePeriod, and valueQuantity) where the data requester has access rights to know that data is suppressed for the **AU Core Diagnostic Result Observation** profile. Patient: Ronny Lawrence Irvine. |
| [Observation - HDL](Observation-lipid-hdl-1.md) | Shows an example of a laboratory result for HDL cholesterol levels for the **AU Core Pathology Result Observation** profile. Patient: Mia Leanne Banks. |
| [Observation - Hearing threshold Ear (left) 500 Hz](Observation-hearing-threshold-1.md) | Shows an example of a hearing threshold observation for the **AU Core Diagnostic Result Observation** profile. Patient: Ronny Lawrence Irvine. |
| [Observation - Heart rate](Observation-heartrate-1.md) | Shows an example of a heart rate observation for the **AU Core Heart Rate** profile. Patient: Mr. Li Wang. |
| [Observation - Height](Observation-bodyheight-1.md) | Shows an example of a body height observation for the **AU Core Body Height** profile. Patient: Mr. Li Wang. |
| [Observation - LDL](Observation-lipid-ldl-1.md) | Shows an example of a laboratory result for LDL cholesterol for the **AU Core Pathology Result Observation** profile. Patient: Mia Leanne Banks. |
| [Observation - Pulse rate](Observation-pulserate-1.md) | Shows an example of a pulse rate observation for the **AU Core Heart Rate** profile. Patient: Mr. Li Wang. |
| [Observation - Respiration rate](Observation-resprate-1.md) | Shows an example of a respiration rate observation for the **AU Core Respiration Rate** profile. Patient: Mia Leanne Banks. |
| [Observation - Temperature](Observation-bodytemp-1.md) | Shows an example of a body temperature observation for the **AU Core Body Temperature** profile. Patient: Mrs. Anne Bennelong. |
| [Observation - Total Cholesterol/HDL ratio](Observation-lipid-total-chol-1.md) | Shows an example of a laboratory result for the Total Cholesterol/HDL ratio for the **AU Core Pathology Result Observation** profile. Patient: Mia Leanne Banks. |
| [Observation - Triglyceride](Observation-lipid-triglyceride-1.md) | Shows an example of a laboratory result for Triglyceride levels for the **AU Core Pathology Result Observation** profile. Patient: Mia Leanne Banks. |
| [Observation - Waist Circumference](Observation-waistcircum-1.md) | Shows an example of a waist circumference measurement result for the **AU Core Waist Circumference** profile. Patient: Mia Leanne Banks. |
| [Organization - Bobrester Medical Centre](Organization-bobrester-medical-center.md) | Shows an example of an organisation, Bobrester Medical Centre, for the **AU Core Organization** profile, with ABN identifier, type as Medical Centre, and contact details including email and phone number. |
| [Organization - Mitchells Hill Audiology](Organization-mitchells-hill-audiology.md) | Shows an example of an organisation, Mitchells Hill Audiology, for the **AU Core Organization** profile, with HPI-O and ABN identifiers, type specified as an audiology clinic, with contact details and an address. |
| [Organization - Murrabit Public Hospital](Organization-murrabit-hospital.md) | Shows an example of an organisation, Murrabit Public Hospital, for the **AU Core Organization** profile, with a HPI-O, type as Hospital, and contact details including multiple phone numbers and email address. |
| [Patient - Deangelo HOWE](Patient-howe-deangelo.md) | Shows an example of a patient resource for Deangelo HOWE for the **AU Core Patient** profile. The patient has a verified IHI and identifies as neither Aboriginal nor Torres Strait Islander origin. The resource includes contact details, gender, date of birth, and address. |
| [Patient - Mia Leanne Banks](Patient-banks-mia-leanne.md) | Shows an example of a patient resource for Mia Leanne Banks for the **AU Core Patient** profile. The patient identifies as female gender, uses the pronouns she/her, and has a verified IHI. The resource includes detailed contact information and a recorded biological sex at birth as female. |
| [Patient - Mr. Li Wang](Patient-wang-li.md) | Shows an example of a patient resource for Mr. Li Wang for the **AU Core Patient** profile. The patient is identified as neither Aboriginal nor Torres Strait Islander origin, speaks Cantonese as the preferred language, and has a Medical Record Number assigned by Large Metropolitan Hospital. |
| [Patient - Mrs. Anne Bennelong](Patient-bennelong-anne.md) | Shows an example of a patient resource for Mrs. Anne Bennelong for the **AU Core Patient** profile. The patient identifies as Aboriginal but not of Torres Strait Islander origin, speaks Yugambal as a primary language, and has a documented Medicare number. |
| [Patient - Ronny Lawrence Irvine](Patient-ronny-irvine.md) | Shows an example of a patient resource for Mr. Ronny Lawrence Irvine for the **AU Core Patient** profile. The patient identifies as Torres Strait Islander but not of Aboriginal origin, with an unknown birth date represented using the Data Absent Reason extension. |
| [Practitioner - Darleen MACKAY](Practitioner-darleen-mackay.md) | Shows an example of a practitioner resource for Darleen Mackay with a HPI-I for the **AU Core Practitioner** profile. The resource includes the practitioner's name and identifier details. |
| [Practitioner - Dr. Bob Bobrester](Practitioner-bobrester-bob.md) | Shows an example of a practitioner resource for Dr. Bob Bobrester for the **AU Core Practitioner** profile. The resource includes the practitioner's name with a title prefix. |
| [Practitioner - Dr. Chau FRYER](Practitioner-chau-fryer.md) | Shows an example of a practitioner resource for Dr. Chau Fryer with a HPI-I for the **AU Core Practitioner** profile. The resource includes the practitioner's official name and identifier details. |
| [Practitioner - Dr. Sallie Sutherland](Practitioner-sallie-sutherland.md) | Shows an example of a practitioner resource for Dr. Sallie Sutherland with a HPI-I for the **AU Core Practitioner** profile. The resource includes the practitioner's official name and identifier details. |
| [PractitionerRole - Cardiologist](PractitionerRole-cardiologist-sallie-sutherland.md) | Shows an example of a Cardiologist role for the **AU Core PractitionerRole** profile, including a Medicare Provider Number identifier, contact details, and references to the associated Practitioner, Organization, and Location. |
| [PractitionerRole - General practitioner](PractitionerRole-bobrester-bob-gp.md) | Shows an example of a General Practitioner role for the **AU Core PractitionerRole** profile, including an employee number identifier, contact details and references to the associated Practitioner and Organization. |
| [PractitionerRole - Nephrologist](PractitionerRole-nephrologist-darleen-mackay.md) | Shows an example of a nephrologist for the **AU Core PractitionerRole** profile, using a local employee number as the role identifier and including a reference to the Practitioner. |
| [PractitionerRole - Surgeon](PractitionerRole-surgeon-chau-fryer.md) | Shows an example of a Surgeon role for the **AU Core PractitionerRole** profile, including a Medicare Provider Number identifier, contact details, and references to the associated Practitioner, Organization, and Location. |
| [Procedure - Dialysis](Procedure-dialysis.md) | Shows an example of a completed haemodialysis procedure for the **AU Core Procedure** profile, with reason as a reference to a Condition resource. Patient: Ronny Lawrence Irvine. |
| [Procedure - Stent insertion](Procedure-stentinsertion.md) | Shows an example of a completed stent placement procedure for the **AU Core Procedure** profile, demonstrating performed date, body site, reason, and focal device. Patient: Mr. Li Wang. |
| [RelatedPerson - Father of Mia Leanne Banks](RelatedPerson-banks-mia-leanne-father.md) | Shows an example of a related person resource for the **AU Core RelatedPerson** profile, demonstrating relationship of father with name. Patient: Mia Leanne Banks. |
| [RelatedPerson - Friend of Mr. Li Wang](RelatedPerson-wang-li-friend.md) | Shows an example of a related person resource for the **AU Core RelatedPerson** profile, demonstrating relationship of friend who is also an emergency contact, with name and telecom and address. Patient: Mr. Li Wang. |
| [Specimen - Naso swab (COVID test)](Specimen-nasoswab.md) | Shows an example of a nasopharyngeal swab specimen referenced by the [Observation - COVID Pathology Result (Not detected)](Observation-pathresult-covid-1.md) example for the **AU Core Pathology Result Observation** profile. Patient: Mr. Li Wang. |

