# AU Core Smoking Status - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **AU Core Smoking Status**

## Resource Profile: AU Core Smoking Status 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org.au/fhir/core/StructureDefinition/au-core-smokingstatus | *Version*:2.0.0 | |
| * Standards status: *[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](https://hl7.org.au/fhir/6.0.0/generalguidance.html#maturity-levels): 2 | *Computable Name*:AUCoreSmokingStatus |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2022+; Licensed Under Creative Commons No Rights Reserved. | | |

 
This profile sets minimum expectations for an Observation resource to record, search, and fetch observations that represent a patient’s smoking status, i.e. current behaviour for all types of tobacco smoking, with standard coding. It is based on the FHIR [Observation](http://hl7.org/fhir/R4/observation.html) resource and identifies the **additional** mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Observation resource when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context. 

See [Comparison with other national and international IGs](comparison.md) for a comparison between AU Core profiles and profiles in other implementation guides.

### Usage Scenarios

The following are supported usage scenarios for this profile:

* Query for observations of smoking status associated with a patient
* Record or update an observation of smoking status associated with a patient

### Profile Specific Implementation Guidance

* `Observation.category` provides an efficient way of supporting system interactions, e.g. restricting searches. Implementers need to understand that data categorisation is somewhat subjective. The categorisation applied by the source may not align with a receiver’s expectations.
* Additional codes that translate or map to the Observation code or category codes are allowed. For example, providing both a local code and the required code.

**Usages:**

* Examples for this Profile: [Observation/smokingstatus-current-smoker](Observation-smokingstatus-current-smoker.md)
* CapabilityStatements using this Profile: [AU Core Requester CapabilityStatement](CapabilityStatement-au-core-requester.md) and [AU Core Responder CapabilityStatement](CapabilityStatement-au-core-responder.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.au.core|current/StructureDefinition/au-core-smokingstatus)

**Changes since version 1.0.0:**

* The resource metadata has changed (description)

* The data elements list has changed

* One or more text definitions, invariants or bindings have changed

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-au-core-smokingstatus.csv), [Excel](StructureDefinition-au-core-smokingstatus.xlsx), [Schematron](StructureDefinition-au-core-smokingstatus.sch) 

### Notes:

Below is an overview of the mandatory and optional search parameters and combined search parameters. See the [AU Core CapabilityStatements](capability-statements.md) for a complete list of supported RESTful interactions for this IG.

FHIR search operations are described [here](http://hl7.org/fhir/R4/search.html) and the syntax used to describe AU Core interactions is defined [here](general-guidance.md#readsearch-syntax).

Any search parameter defined in FHIR may be 'allowed' by the system unless explicitly marked as "**SHALL NOT**". A few items are marked as **MAY** in this implementation guide to highlight their potential relevance.

* Parameter(s): patient+category
  * Conformance: **SHALL**
  * Type(s): `reference`+`token`
  * Requirements (when used alone or in combination): 
* Parameter(s): patient+category+date
  * Conformance: **SHALL**
  * Type(s): `reference`+`token`+`date`
  * Requirements (when used alone or in combination): 
* Parameter(s): patient+code
  * Conformance: **SHALL**
  * Type(s): `reference`+`token`
  * Requirements (when used alone or in combination): 
* Parameter(s): patient+category+status
  * Conformance: **SHOULD**
  * Type(s): `reference`+`token`+`token`
  * Requirements (when used alone or in combination): 
* Parameter(s): patient+code+date
  * Conformance: **SHOULD**
  * Type(s): `reference`+`token`+`date`
  * Requirements (when used alone or in combination): 
* Parameter(s): patient
  * Conformance: **MAY**
  * Type(s): `reference`
  * Requirements (when used alone or in combination): The requester**SHALL**provide at least an id value and**MAY**provide both the Type and id values. The responder**SHALL**support both.The requester**SHOULD**support chained search patient.identifier using IHI, Medicare Number, and DVA Number identifiers as defined in the AU Core Patient profile. The responder**SHOULD**support chained search patient.identifier using IHI, Medicare Number, and DVA Number identifiers as defined in the AU Core Patient profile.
* Parameter(s): category
  * Conformance: **MAY**
  * Type(s): `token`
  * Requirements (when used alone or in combination): The requester**SHALL**provide at least a code value and**MAY**provide both the system and code values. The responder**SHALL**support both.The requester**SHALL**support search using the category code defined in this profile. The responder**SHALL**support search using the category code defined in this profile.
* Parameter(s): code
  * Conformance: **MAY**
  * Type(s): `token`
  * Requirements (when used alone or in combination): The requester**SHALL**provide at least a code value and**MAY**provide both the system and code values. The responder**SHALL**support both.The requester**SHALL**support search using the LOINC codes defined in this profile. The responder**SHALL**support search using the LOINC codes defined in this profile.The requester**SHALL**support`multipleOr`. The responder**SHALL**support`multipleOr`.
* Parameter(s): date
  * Conformance: **MAY**
  * Type(s): `date`
  * Requirements (when used alone or in combination): A requester**SHALL**provide a value precise to the second + time offset. A responder**SHALL**support a value precise to the second + time offset.The requester**SHALL**support these search comparators`gt`,`lt`,`ge`,`le`. The responder**SHALL**support these search comparators`gt`,`lt`,`ge`,`le`.The requester**SHOULD**support`multipleAnd`, and if`multipleAnd`is supported,**SHALL**support the search comparators`gt`,`lt`,`ge`,`le`. The responder**SHOULD**support`multipleAnd`, and if`multipleAnd`is supported,**SHALL**support the search comparators`gt`,`lt`,`ge`,`le`.
* Parameter(s): status
  * Conformance: **MAY**
  * Type(s): `token`
  * Requirements (when used alone or in combination): The requester**SHALL**provide at least a code value and**MAY**provide both the system and code values. The responder**SHALL**support both.The requester**SHALL**support`multipleOr`.The responder**SHALL**support`multipleOr`.

#### Mandatory Search Parameters

The following search parameters and search parameter combinations **SHALL** be supported:

1. **SHALL**support searching using the combination of the**[`patient`](https://hl7.org/fhir/R4/observation.html#search)**and**[`category`](https://hl7.org/fhir/R4/observation.html#search)**search parameters:
* **SHOULD** support chained searching of patient canonical identifier `patient.identifier` (e.g. `patient.identifier=[system|][code]`)
`GET [base]/Observation?patient={Type/}[id]&category={system|}[code]`Example:
1. GET [base]/Observation?patient=5678&category=http://terminology.hl7.org/CodeSystem/observation-category|social-history
1. GET [base]/Observation?patient.identifier=http://ns.electronichealth.net.au/id/hi/ihi/1.0|8003608833357361&category=http://terminology.hl7.org/CodeSystem/observation-category|social-history
**Implementation Notes:** Fetches a bundle of all Observation resources for the specified patient and category ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference) and [how to search by token](http://hl7.org/fhir/R4/search.html#token))
1. **SHALL**support searching using the combination of the**[`patient`](https://hl7.org/fhir/R4/observation.html#search)**and**[`category`](https://hl7.org/fhir/R4/observation.html#search)**and**[`date`](https://hl7.org/fhir/R4/observation.html#search)**search parameters:
* **SHOULD** support chained searching of patient canonical identifier `patient.identifier` (e.g. `patient.identifier=[system|][code]`)
* **SHALL** support these `date` comparators: `gt,lt,ge,le`
* **SHOULD** support **[multipleAnd](http://hl7.org/fhir/R4/searchparameter-definitions.html#SearchParameter.multipleAnd)** search on `date` (e.g. `date=[date]&date=[date]]&...`), and if **[multipleAnd](http://hl7.org/fhir/R4/searchparameter-definitions.html#SearchParameter.multipleAnd)** is supported, **SHALL** support the search comparators `gt,lt,ge,le`
`GET [base]/Observation?patient={Type/}[id]&category={system|}[code]&date={gt|lt|ge|le}[date]{&date={gt|lt|ge|le}[date]&...}`Example:
1. GET [base]/Observation?patient=5678&category=http://terminology.hl7.org/CodeSystem/observation-category|social-history&date=ge2020-01-01T00:00:00Z
**Implementation Notes:** Fetches a bundle of all Observation resources for the specified patient and date and a category code = `social-history` ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference) and [how to search by token](http://hl7.org/fhir/R4/search.html#token) and [how to search by date](http://hl7.org/fhir/R4/search.html#date))
1. **SHALL**support searching using the combination of the**[`patient`](https://hl7.org/fhir/R4/observation.html#search)**and**[`code`](https://hl7.org/fhir/R4/observation.html#search)**search parameters:
* **SHOULD** support chained searching of patient canonical identifier `patient.identifier` (e.g. `patient.identifier=[system|][code]`)
* **SHOULD** support **[multipleOr](http://hl7.org/fhir/R4/searchparameter-definitions.html#SearchParameter.multipleOr)** search on `code` (e.g. `code={system|}[code],{system|}[code],...`)
`GET [base]/Observation?patient={Type/}[id]&code={system|}[code]{,{system|}[code],...}`Example:
1. GET [base]/Observation?patient=5678&code=http://snomed.info/sct|1747861000168109
**Implementation Notes:** Fetches a bundle of all Observation resources for the specified patient and observation code(s). The Observation `code` parameter searches `Observation.code` only. ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference) and [how to search by token](http://hl7.org/fhir/R4/search.html#token))

#### Optional Search Parameters:

The following search parameters and search parameter combinations **SHOULD** be supported:

1. **SHOULD** support chained searching of patient canonical identifier `patient.identifier` (e.g. `patient.identifier=[system|][code]`)`GET [base]/Observation?patient.identifier=[system|][code]`Example:
1. GET [base]/Observation?patient.identifier=http://ns.electronichealth.net.au/id/medicare-number|32788511952
1. GET [base]/Observation?patient.identifier=http://ns.electronichealth.net.au/id/hi/ihi/1.0|8003608833357361
**Implementation Notes:** Fetches a bundle of all Observation resources for the specified patient ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference) and [how to search by token](http://hl7.org/fhir/R4/search.html#token))
1. **SHOULD**support searching using the combination of the**[`patient`](https://hl7.org/fhir/R4/observation.html#search)**and**[`category`](https://hl7.org/fhir/R4/observation.html#search)**and**[`status`](https://hl7.org/fhir/R4/observation.html#search)**search parameters:
* **SHOULD** support chained searching of patient canonical identifier `patient.identifier` (e.g. `patient.identifier=[system|][code]`)
* **SHALL** support **[multipleOr](http://hl7.org/fhir/R4/searchparameter-definitions.html#SearchParameter.multipleOr)** search on `status` (e.g. `status={system|}[code],{system|}[code],...`)
`GET [base]/Observation?patient={Type/}[id]&category={system|}[code]&status={system|}[code]{,{system|}[code],...}`Example:
1. GET [base]/Observation?patient=5678&category=http://terminology.hl7.org/CodeSystem/observation-category|social-history&status=final
**Implementation Notes:** Fetches a bundle of all Observation resources for the specified patient and category and status ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference) and [how to search by token](http://hl7.org/fhir/R4/search.html#token))
1. **SHOULD**support searching using the combination of the**[`patient`](https://hl7.org/fhir/R4/observation.html#search)**and**[`code`](https://hl7.org/fhir/R4/observation.html#search)**and**[`date`](https://hl7.org/fhir/R4/observation.html#search)**search parameters:
* **SHOULD** support chained searching of patient canonical identifier `patient.identifier` (e.g. `patient.identifier=[system|][code]`
* **SHOULD** support **[multipleOr](http://hl7.org/fhir/R4/searchparameter-definitions.html#SearchParameter.multipleOr)** search on `code` (e.g. `code={system|}[code],{system|}[code],...`)
* **SHALL** support these `date` comparators: `gt,lt,ge,le`
* **SHOULD** support **[multipleAnd](http://hl7.org/fhir/R4/searchparameter-definitions.html#SearchParameter.multipleAnd)** search on `date` (e.g. `date=[date]&date=[date]]&...`), and if **[multipleAnd](http://hl7.org/fhir/R4/searchparameter-definitions.html#SearchParameter.multipleAnd)** is supported, **SHALL** support the search comparators `gt,lt,ge,le`
`GET [base]/Observation?patient={Type/}[id]&code={system|}[code]{,{system|}[code],...}&date={gt|lt|ge|le}[date]{&date={gt|lt|ge|le}[date]&...}`Example:
1. GET [base]/Observation?patient=5678&code=http://snomed.info/sct|1747861000168109&date=ge2020-01-01T00:00:00Z
1. GET [base]/Observation?patient.identifier=http://example.org/fhir/mrn|12345&code=http://snomed.info/sct|1747861000168109&date=ge2020-01-01T00:00:00Z
**Implementation Notes:** Fetches a bundle of all Observation resources for the specified patient and date and observation code(s) ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference) and [how to search by token](http://hl7.org/fhir/R4/search.html#token) and [how to search by date](http://hl7.org/fhir/R4/search.html#date))



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "au-core-smokingstatus",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org.au/fhir/core/ImplementationGuide/hl7.fhir.au.core"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-smokingstatus",
  "version" : "2.0.0",
  "name" : "AUCoreSmokingStatus",
  "title" : "AU Core Smoking Status",
  "status" : "active",
  "date" : "2026-01-28T05:31:23+00:00",
  "publisher" : "HL7 Australia",
  "contact" : [
    {
      "name" : "HL7 Australia FHIR Work Group",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.hl7.org/display/HAFWG",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This profile sets minimum expectations for an Observation resource to record, search, and fetch observations that represent a patient’s smoking status, i.e. current behaviour for all types of tobacco smoking, with standard coding. It is based on the FHIR [Observation](http://hl7.org/fhir/R4/observation.html) resource and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Observation resource when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2022+; Licensed Under Creative Commons No Rights Reserved.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "short" : "Smoking status",
        "definition" : "An observation of smoking status, i.e. current behaviour for all types of tobacco smoking, at a point in time.",
        "constraint" : [
          {
            "key" : "au-core-obs-01",
            "severity" : "error",
            "human" : "At least value or data absent reason shall be present",
            "expression" : "dataAbsentReason.exists() or value.exists()",
            "xpath" : "exists(f:*[starts-with(local-name(.), 'value')]) or exists(f:dataAbsentReason)",
            "source" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-smokingstatus"
          }
        ]
      },
      {
        "id" : "Observation.status",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Observation.status",
        "mustSupport" : true
      },
      {
        "id" : "Observation.category",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Observation.category",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Observation.category:socialHistory",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Observation.category",
        "sliceName" : "socialHistory",
        "min" : 1,
        "max" : "1",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
              "code" : "social-history"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Observation.code",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Observation.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "1747861000168109"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Observation.code.coding",
        "path" : "Observation.code.coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code"
            },
            {
              "type" : "value",
              "path" : "system"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.code.coding:loincSmokingStatus",
        "path" : "Observation.code.coding",
        "sliceName" : "loincSmokingStatus",
        "short" : "LOINC Smoking Status",
        "max" : "1"
      },
      {
        "id" : "Observation.code.coding:loincSmokingStatus.system",
        "path" : "Observation.code.coding.system",
        "min" : 1,
        "fixedUri" : "http://loinc.org"
      },
      {
        "id" : "Observation.code.coding:loincSmokingStatus.code",
        "path" : "Observation.code.coding.code",
        "min" : 1,
        "fixedCode" : "72166-2"
      },
      {
        "id" : "Observation.subject",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Observation.subject",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org.au/fhir/core/StructureDefinition/au-core-patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.effective[x]",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Observation.effective[x]",
        "short" : "Date, and optionally time, the observation was performed",
        "definition" : "Date, and optionally time, the observation was performed.",
        "min" : 1,
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "condition" : ["au-core-obs-02"],
        "constraint" : [
          {
            "key" : "au-core-obs-02",
            "severity" : "error",
            "human" : "Date shall be at least to day or, if not available, the Data Absent Reason extension shall be present",
            "expression" : "(($this is dateTime implies $this.toString().length() >= 10) and extension('http://hl7.org/fhir/StructureDefinition/data-absent-reason').value.exists().not()) xor ($this is dateTime implies ($this.hasValue().not() and extension('http://hl7.org/fhir/StructureDefinition/data-absent-reason').value.exists()))",
            "xpath" : "((self::dateTime and string-length(.) >= 10 and not(extension[@url='http://hl7.org/fhir/StructureDefinition/data-absent-reason'])) xor (self::dateTime and not(.) and extension[@url='http://hl7.org/fhir/StructureDefinition/data-absent-reason']))",
            "source" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-smokingstatus"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.value[x]",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Observation.value[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "condition" : ["au-core-obs-01"],
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "https://healthterminologies.gov.au/fhir/ValueSet/smoking-status-1"
        }
      },
      {
        "id" : "Observation.dataAbsentReason",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Observation.dataAbsentReason",
        "condition" : ["au-core-obs-01"],
        "mustSupport" : true
      }
    ]
  }
}

```
