# AU Core PractitionerRole - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **AU Core PractitionerRole**

## Resource Profile: AU Core PractitionerRole 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitionerrole | *Version*:2.0.0 | |
| * Standards status: *[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](https://hl7.org.au/fhir/6.0.0/generalguidance.html#maturity-levels): 2 | *Computable Name*:AUCorePractitionerRole |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2022+; Licensed Under Creative Commons No Rights Reserved. | | |

 
This profile sets minimum expectations for a PractitionerRole resource to record, search, and fetch a practitioner role for a practitioner associated with a patient. It is based on the [AU Base PractitionerRole](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-practitionerrole.html) profile and identifies the **additional** mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the PractitionerRole resource when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context. 

See [Comparison with other national and international IGs](comparison.md) for a comparison between AU Core profiles and profiles in other implementation guides.

### Usage Scenarios

The following are supported usage scenarios for this profile:

* Record or update information about a practitioner in a role referenced by another resource
* Read information about a practitioner in a role referenced by another resource

### Profile Specific Implementation Guidance

* Even though AU Core Profiles allow both PractitionerRole and Practitioner to be referenced, because PractitionerRole supplies a provider’s location, contact information, and reference to the Practitioner, it **SHOULD** be referenced instead of the Practitioner resource.
* If a system only supports Practitioner, the system **SHALL** provide implementation specific guidance how to access a provider’s location and contact information using only the Practitioner resource.
* Requesters can request responders return the Practitioner resource using `_include`, see the Notes section below.
* See guidance on the construction of an identifier on the relevant Identifier profile page and the section on [Business Identifiers](https://hl7.org.au/fhir/6.0.0/generalguidance.html#business-identifiers) in AU Base.

**Usages:**

* Refer to this Profile: [AU Core Pathology Result Observation](StructureDefinition-au-core-diagnosticresult-path.md), [AU Core Diagnostic Result Observation](StructureDefinition-au-core-diagnosticresult.md), [AU Core Encounter](StructureDefinition-au-core-encounter.md) and [AU Core MedicationRequest](StructureDefinition-au-core-medicationrequest.md)
* Examples for this Profile: [PractitionerRole/bobrester-bob-gp](PractitionerRole-bobrester-bob-gp.md), [PractitionerRole/cardiologist-sallie-sutherland](PractitionerRole-cardiologist-sallie-sutherland.md), [PractitionerRole/nephrologist-darleen-mackay](PractitionerRole-nephrologist-darleen-mackay.md) and [PractitionerRole/surgeon-chau-fryer](PractitionerRole-surgeon-chau-fryer.md)
* CapabilityStatements using this Profile: [AU Core Requester CapabilityStatement](CapabilityStatement-au-core-requester.md) and [AU Core Responder CapabilityStatement](CapabilityStatement-au-core-responder.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.au.core|current/StructureDefinition/au-core-practitionerrole)

**Changes since version 1.0.0:**

* The resource metadata has changed (description)

* The data elements list has changed

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-au-core-practitionerrole.csv), [Excel](StructureDefinition-au-core-practitionerrole.xlsx), [Schematron](StructureDefinition-au-core-practitionerrole.sch) 

### Notes:

Below is an overview of the mandatory and optional search parameters and combined search parameters. See the [AU Core CapabilityStatements](capability-statements.md) for a complete list of supported RESTful interactions for this IG.

FHIR search operations are described [here](http://hl7.org/fhir/R4/search.html) and the syntax used to describe AU Core interactions is defined [here](general-guidance.md#readsearch-syntax).

Any search parameter defined in FHIR may be 'allowed' by the system unless explicitly marked as "**SHALL NOT**". A few items are marked as **MAY** in this implementation guide to highlight their potential relevance.

* Parameter(s): identifier
  * Conformance: **SHALL**
  * Type(s): `token`
  * Requirements (when used alone or in combination): The requester**SHALL**provide both the system and code values. The responder**SHALL**support both.The requester**SHOULD**support search using a Medicare Provider Number identifier as defined in the profile. The responder**SHOULD**support search using a Medicare Provider Number identifier as defined in the profile.
* Parameter(s): practitioner
  * Conformance: **SHALL**
  * Type(s): `reference`
  * Requirements (when used alone or in combination): The requester**SHALL**provide at least an id value and**MAY**provide both the Type and id values. The responder**SHALL**support both.The requester**SHALL**provide at least a code value and**SHOULD**provide both the system and code values.The requester**SHOULD**support chained search practitioner.identifier using a HPI-I identifier as defined in the AU Core Practitioner profile. The responder**SHOULD**support chained search practitioner.identifier using a HPI-I identifier as defined in the AU Core Practitioner profile.
* Parameter(s): _id
  * Conformance: **SHOULD**
  * Type(s): `token`
  * Requirements (when used alone or in combination): 
* Parameter(s): specialty
  * Conformance: **SHOULD**
  * Type(s): `token`
  * Requirements (when used alone or in combination): The requester**SHALL**provide at least a code value and**MAY**provide both the system and code values. The responder**SHALL**support both.
* Parameter(s): role
  * Conformance: **SHOULD**
  * Type(s): `token`
  * Requirements (when used alone or in combination): The requester**SHALL**provide at least a code value and**MAY**provide both the system and code values. The responder**SHALL**support both.
* Parameter(s): organization
  * Conformance: **MAY**
  * Type(s): `reference`
  * Requirements (when used alone or in combination): The requester**SHALL**provide at least an id value and**MAY**provide both the Type and id values. The responder**SHALL**support both.

#### Mandatory Search Parameters

The following search parameters **SHALL** be supported:

1. **SHALL**support searching using the**[`identifier`](https://hl7.org/fhir/R4/practitionerrole.html#search)**search parameter:
* **SHOULD** support these **[`_include`](http://hl7.org/fhir/R4/search.html#include)** parameters: `PractitionerRole:practitioner`
`GET [base]/PractitionerRole?identifier=[system|][code]`Example:
1. GET [base]/PractitionerRole?identifier=http://ns.electronichealth.net.au/id/medicare-provider-number|2426621B&_include=PractitionerRole:practitioner
1. GET [base]/PractitionerRole?identifier=http://ns.electronichealth.net.au/id/medicare-provider-number|2426621B
**Implementation Notes:** Fetches a bundle containing all PractitionerRole resources matching the identifier ([how to search by token](http://hl7.org/fhir/R4/search.html#token))
1. **SHALL**support searching using the**[`practitioner`](https://hl7.org/fhir/R4/practitionerrole.html#search)**search parameters:
* **SHOULD** support chained searching of practitioner canonical identifier `practitioner.identifier` (e.g. `practitioner.identifier=[system|][code]`)
* **SHOULD** support these **[`_include`](http://hl7.org/fhir/R4/search.html#include)** parameters: `PractitionerRole:practitioner`
`GET [base]/PractitionerRole?practitioner={Type/}[id]` or optionally `GET [base]/PractitionerRole?practitioner.identifier=[system|][code]`Example:
1. GET [base]/PractitionerRole?practitioner=Practitioner/sandyson-sandy
1. GET [base]/PractitionerRole?practitioner=Practitioner/sandyson-sandy&_include=PractitionerRole:practitioner
1. GET [base]/PractitionerRole?practitioner.identifier=http://ns.electronichealth.net.au/id/medicare-provider-number|2426621B
**Implementation Notes:** Fetches a bundle of all PractitionerRole resources matching the specified practitioner ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference) and [how to search by token](http://hl7.org/fhir/R4/search.html#token))

#### Optional Search Parameters

The following search parameters and search parameter combinations **SHOULD** be supported:

1. **SHOULD**support searching using the**[`_id`](https://hl7.org/fhir/R4/practitionerrole.html#search)**search parameter:
* **SHOULD** support these **[`_include`](http://hl7.org/fhir/R4/search.html#include)** parameters: `PractitionerRole:practitioner`
`GET [base]/PractitionerRole?_id=[id]`Example:
1. GET [base]/PractitionerRole/_id=5678
1. GET [base]/PractitionerRole?_id=5678&_include=PractitionerRole:practitioner
**Implementation Notes:** Fetches a bundle with the requested PractitionerRole, instead of just the resource itself, and allows for the inclusion of additional search parameters such as _include, _revinclude, or _lastUpdated ([how to search by id of the resource](https://hl7.org/fhir/r4/search.html#id))
1. **SHOULD**support searching using the**[`specialty`](https://hl7.org/fhir/R4/practitionerrole.html#search)**search parameter:
* **SHOULD** support these **[`_include`](http://hl7.org/fhir/R4/search.html#include)** parameters: `PractitionerRole:practitioner`
`GET [base]/PractitionerRole?specialty={system|}[code]`Example:
1. GET [base]/PractitionerRole?specialty=http://snomed.info/sct|408443003
1. GET [base]/PractitionerRole?specialty=http://snomed.info/sct|408443003&_include=PractitionerRole:practitioner
**Implementation Notes:** Fetches a bundle of all PractitionerRole resources for the specified specialty ([how to search by token](http://hl7.org/fhir/R4/search.html#token))
1. **SHOULD**support searching using the**[`role`](https://hl7.org/fhir/R4/practitionerrole.html#search)**search parameter:
* **SHOULD** support these **[`_include`](http://hl7.org/fhir/R4/search.html#include)** parameters: `PractitionerRole:practitioner`
`GET [base]/PractitionerRole?role={system|}[code]`Example:
1. GET [base]/PractitionerRole?role=http://snomed.info/sct|304292004
1. GET [base]/PractitionerRole?role=http://snomed.info/sct|304292004&_include=PractitionerRole:practitioner
**Implementation Notes:** Fetches a bundle of all PractitionerRole resources for the specified role ([how to search by token](http://hl7.org/fhir/R4/search.html#token))



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "au-core-practitionerrole",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org.au/fhir/core/ImplementationGuide/hl7.fhir.au.core"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitionerrole",
  "version" : "2.0.0",
  "name" : "AUCorePractitionerRole",
  "title" : "AU Core PractitionerRole",
  "status" : "active",
  "date" : "2026-01-28T05:31:23+00:00",
  "publisher" : "HL7 Australia",
  "contact" : [
    {
      "name" : "HL7 Australia FHIR Work Group",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.hl7.org/display/HAFWG",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This profile sets minimum expectations for a PractitionerRole resource to record, search, and fetch a practitioner role for a practitioner associated with a patient. It is based on the [AU Base PractitionerRole](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-practitionerrole.html) profile and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the PractitionerRole resource when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2022+; Licensed Under Creative Commons No Rights Reserved.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "PractitionerRole",
  "baseDefinition" : "http://hl7.org.au/fhir/StructureDefinition/au-practitionerrole",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "PractitionerRole",
        "path" : "PractitionerRole",
        "short" : "A person with formal responsibility in a role providing one or more services"
      },
      {
        "id" : "PractitionerRole.identifier",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "PractitionerRole.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "type"
            }
          ],
          "rules" : "open"
        },
        "definition" : "Business Identifiers that are specific to a role/location.",
        "mustSupport" : true
      },
      {
        "id" : "PractitionerRole.identifier:medicareProvider",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "PractitionerRole.identifier",
        "sliceName" : "medicareProvider",
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier",
            "profile" : [
              "http://hl7.org.au/fhir/StructureDefinition/au-medicareprovidernumber"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "PractitionerRole.practitioner",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "PractitionerRole.practitioner",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitioner"
            ]
          }
        ],
        "condition" : ["au-core-prarol-01"],
        "constraint" : [
          {
            "key" : "au-core-prarol-01",
            "severity" : "error",
            "human" : "At least a reference, identifier or display shall be present, or, if neither is available, the Data Absent Reason extension shall be present",
            "expression" : "(reference.exists() or identifier.exists() or display.exists()) xor extension('http://hl7.org/fhir/StructureDefinition/data-absent-reason').exists()",
            "xpath" : "(exists(f:reference) or exists(f:display) or exists(f:identifier)) and not(exists(f:extension[@url='http://hl7.org/fhir/StructureDefinition/data-absent-reason'])) or not(exists(f:reference) or exists(f:display) or exists(f:identifier)) and exists(f:extension[@url='http://hl7.org/fhir/StructureDefinition/data-absent-reason'])",
            "source" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitionerrole"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "PractitionerRole.organization",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "PractitionerRole.organization",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org.au/fhir/core/StructureDefinition/au-core-organization"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "PractitionerRole.code",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "PractitionerRole.code",
        "mustSupport" : true
      },
      {
        "id" : "PractitionerRole.specialty",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "PractitionerRole.specialty",
        "mustSupport" : true
      },
      {
        "id" : "PractitionerRole.telecom",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "PractitionerRole.telecom",
        "mustSupport" : true
      },
      {
        "id" : "PractitionerRole.telecom.system",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "PractitionerRole.telecom.system",
        "mustSupport" : true
      },
      {
        "id" : "PractitionerRole.telecom.value",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "PractitionerRole.telecom.value",
        "mustSupport" : true
      }
    ]
  }
}

```
