# AU Core Diagnostic Result Observation - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **AU Core Diagnostic Result Observation**

## Resource Profile: AU Core Diagnostic Result Observation 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org.au/fhir/core/StructureDefinition/au-core-diagnosticresult | *Version*:2.0.0 | |
| * Standards status: *[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](https://hl7.org.au/fhir/6.0.0/generalguidance.html#maturity-levels): 2 | *Computable Name*:AUCoreDiagnosticResult |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2022+; Licensed Under Creative Commons No Rights Reserved. | | |

 
This profile sets minimum expectations for an Observation resource to record, search, and fetch specialist or other diagnostic (non-imaging or non-pathology) results for a patient. It is based on the [AU Base Diagnostic Result](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-diagnosticresult.html) profile and identifies the **additional** mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Observation when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context. 

See [Comparison with other national and international IGs](comparison.md) for a comparison between AU Core profiles and profiles in other implementation guides.

### Usage Scenarios

The following are supported usage scenarios for this profile:

* Query for specialist or other diagnostic results for a patient
* Query for category of specialist or other diagnostic results (e.g. all cardiology results)
* Record or update a specialist or other diagnostic result for a patient

There is currently no profile for diagnostic imaging results in AU Core. Implementers can refer to the
[AU Base Diagnostic Imaging Result](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-imagingresult.html)profile for guidance on exchanging diagnostic imaging results. Support for imaging result observations may be added to AU Core in the future.

### Profile Specific Implementation Guidance

* `Observation.category` provides an efficient way of supporting system interactions, e.g. restricting searches. Implementers need to understand that data categorisation is somewhat subjective. The categorisation applied by the source may not align with a receiver’s expectations.
* The observations **MAY** have additional codes that translate or map to the Observation code or category codes. For example: 
* providing a local code
* providing a more specific code
 
* The use of coding can vary significantly across systems, requesters need to understand that they may encounter codes they do not recognise and be prepared to handle those resources appropriately. Responders **SHOULD** populate `Observation.code.text` and/or `Observation.code.coding.display` so that the requester can at least display the observation even if the requester does not recognise the code supplied.
* The Observation resource can represent a result using a single value in `Observation.value`, or can represent a set of results using either `Observation.component.value` or `Observation.hasMember`. 
* Although all are marked as **Must Support**, responders are not required to support all choices, but they **SHALL** support **at least one** of these elements
* A requester **SHALL** support all elements (`Observation.value`, `Observation.component.value`, `Observation.hasMember`)
* for further guidance, see the [Observation Grouping](https://hl7.org/fhir/R4/observation.html#obsgrouping) section in the FHIR standard.
 
* `Observation.identifier` may contain the same identifier as in the order or report connecting the resources that are related to a single request fulfilment workflow.
* Source system identifiers that identify the business process (order ids and reporting identifiers) **MAY** be included as [AU Local Order Identifier](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-localorderidentifier.html) and [AU Local Report Identifier](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-localreportidentifier.html) to support workflow and deduplication of Observation resources.
* See guidance on the construction of an identifier on the relevant Identifier profile page and the section on [Business Identifiers](https://hl7.org.au/fhir/6.0.0/generalguidance.html#business-identifiers) in AU Base.
* To represent the result of a pathology test, see the [AU Core Pathology Result Observation](StructureDefinition-au-core-diagnosticresult-path.md) profile.

**Usages:**

* Refer to this Profile: [AU Core Diagnostic Result Observation](StructureDefinition-au-core-diagnosticresult.md)
* Examples for this Profile: [Observation/hearing-threshold-1](Observation-hearing-threshold-1.md) and [Observation/observation-masked](Observation-observation-masked.md)
* CapabilityStatements using this Profile: [AU Core Requester CapabilityStatement](CapabilityStatement-au-core-requester.md) and [AU Core Responder CapabilityStatement](CapabilityStatement-au-core-responder.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.au.core|current/StructureDefinition/au-core-diagnosticresult)

**Changes since version 1.0.0:**

* The resource metadata has changed (description)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-au-core-diagnosticresult.csv), [Excel](StructureDefinition-au-core-diagnosticresult.xlsx), [Schematron](StructureDefinition-au-core-diagnosticresult.sch) 

### Notes:

Below is an overview of the mandatory and optional search parameters and combined search parameters. See the [AU Core CapabilityStatements](capability-statements.md) for a complete list of supported RESTful interactions for this IG.

FHIR search operations are described [here](http://hl7.org/fhir/R4/search.html) and the syntax used to describe AU Core interactions is defined [here](general-guidance.md#readsearch-syntax).

Any search parameter defined in FHIR may be 'allowed' by the system unless explicitly marked as "**SHALL NOT**". A few items are marked as **MAY** in this implementation guide to highlight their potential relevance.

* Parameter(s): patient+category
  * Conformance: **SHALL**
  * Type(s): `reference`+`token`
  * Requirements (when used alone or in combination): 
* Parameter(s): patient+category+date
  * Conformance: **SHALL**
  * Type(s): `reference`+`token`+`date`
  * Requirements (when used alone or in combination): 
* Parameter(s): patient+code
  * Conformance: **SHALL**
  * Type(s): `reference`+`token`
  * Requirements (when used alone or in combination): 
* Parameter(s): patient+category+status
  * Conformance: **SHOULD**
  * Type(s): `reference`+`token`+`token`
  * Requirements (when used alone or in combination): 
* Parameter(s): patient+code+date
  * Conformance: **SHOULD**
  * Type(s): `reference`+`token`+`date`
  * Requirements (when used alone or in combination): 
* Parameter(s): patient
  * Conformance: **MAY**
  * Type(s): `reference`
  * Requirements (when used alone or in combination): The requester**SHALL**provide at least an id value and**MAY**provide both the Type and id values. The responder**SHALL**support both.The requester**SHOULD**support chained search patient.identifier using IHI, Medicare Number, and DVA Number identifiers as defined in the AU Core Patient profile. The responder**SHOULD**support chained search patient.identifier using IHI, Medicare Number, and DVA Number identifiers as defined in the AU Core Patient profile.
* Parameter(s): category
  * Conformance: **MAY**
  * Type(s): `token`
  * Requirements (when used alone or in combination): The requester**SHALL**provide at least a code value and**MAY**provide both the system and code values. The responder**SHALL**support both.The requester**SHALL**support search using the category code defined in this profile. The responder**SHALL**support search using the category code defined in this profile.
* Parameter(s): code
  * Conformance: **MAY**
  * Type(s): `token`
  * Requirements (when used alone or in combination): The requester**SHALL**provide at least a code value and**MAY**provide both the system and code values. The responder**SHALL**support both.The requester**SHALL**support search using the LOINC codes defined in this profile. The responder**SHALL**support search using the LOINC codes defined in this profile.The requester**SHALL**support`multipleOr`. The responder**SHALL**support`multipleOr`.
* Parameter(s): date
  * Conformance: **MAY**
  * Type(s): `date`
  * Requirements (when used alone or in combination): A requester**SHALL**provide a value precise to the second + time offset. A responder**SHALL**support a value precise to the second + time offset.The requester**SHALL**support these search comparators`gt`,`lt`,`ge`,`le`. The responder**SHALL**support these search comparators`gt`,`lt`,`ge`,`le`.The requester**SHOULD**support`multipleAnd`, and if`multipleAnd`is supported,**SHALL**support the search comparators`gt`,`lt`,`ge`,`le`. The responder**SHOULD**support`multipleAnd`, and if`multipleAnd`is supported,**SHALL**support the search comparators`gt`,`lt`,`ge`,`le`.
* Parameter(s): status
  * Conformance: **MAY**
  * Type(s): `token`
  * Requirements (when used alone or in combination): The requester**SHALL**provide at least a code value and**MAY**provide both the system and code values. The responder**SHALL**support both.The requester**SHALL**support`multipleOr`.The responder**SHALL**support`multipleOr`.

#### Mandatory Search Parameters:

The following search parameters and search parameter combinations **SHALL** be supported:

1. **SHALL**support searching using the combination of the**[`patient`](https://hl7.org/fhir/R4/observation.html#search)**and**[`category`](https://hl7.org/fhir/R4/observation.html#search)**search parameters:
* **SHOULD** support chained searching of patient canonical identifier `patient.identifier` (e.g. `patient.identifier=[system|][code]`)
`GET [base]/Observation?patient={Type/}[id]&category={system|}[code]`Example:
1. GET [base]/Observation?patient=5678&category=http://terminology.hl7.org/CodeSystem/observation-category|survey
**Implementation Notes:** Fetches a bundle of all Observation resources for the specified patient and a category code = `survey` ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference) and [how to search by token](http://hl7.org/fhir/R4/search.html#token))
1. **SHALL**support searching using the combination of the**[`patient`](https://hl7.org/fhir/R4/observation.html#search)**and**[`code`](https://hl7.org/fhir/R4/observation.html#search)**search parameters:
* **SHOULD** support chained searching of patient canonical identifier `patient.identifier` (e.g. `patient.identifier=[system|][code]`)
* **SHOULD** support **[multipleOr](http://hl7.org/fhir/R4/searchparameter-definitions.html#SearchParameter.multipleOr)** search on `code` (e.g. `code={system|}[code],{system|}[code],...`)
`GET [base]/Observation?patient={Type/}[id]&code={system|}[code]{,{system|}[code],...}`Example:
1. GET [base]/Observation?patient=5678&code=http://snomed.info/sct|89240007,http://loinc.org|14683-7,http://loinc.org|85354-9
**Implementation Notes:** Fetches a bundle of all Observation resources for the specified patient and observation code(s). The Observation `code` parameter searches `Observation.code` only. ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference) and [how to search by token](http://hl7.org/fhir/R4/search.html#token))
1. **SHALL**support searching using the combination of the**[`patient`](https://hl7.org/fhir/R4/observation.html#search)**and**[`category`](https://hl7.org/fhir/R4/observation.html#search)**and**[`date`](https://hl7.org/fhir/R4/observation.html#search)**search parameters:
* **SHOULD** support chained searching of patient canonical identifier `patient.identifier` (e.g. `patient.identifier=[system|][code]`)
* **SHALL** support these `date` comparators: `gt,lt,ge,le`
* **SHOULD** support **[multipleAnd](http://hl7.org/fhir/R4/searchparameter-definitions.html#SearchParameter.multipleAnd)** search on `date` (e.g. `date=[date]&date=[date]]&...`), and if **[multipleAnd](http://hl7.org/fhir/R4/searchparameter-definitions.html#SearchParameter.multipleAnd)** is supported, **SHALL** support the search comparators `gt,lt,ge,le`
`GET [base]/Observation?patient={Type/}[id]&category={system|}[code]&date={gt|lt|ge|le}[date]{&date={gt|lt|ge|le}[date]&...}`Example:
1. GET [base]/Observation?patient=5678&category=http://terminology.hl7.org/CodeSystem/observation-category|survey&date=ge2020-01-01T00:00:00Z
**Implementation Notes:** Fetches a bundle of all Observation resources for the specified patient and date and category ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference) and [how to search by token](http://hl7.org/fhir/R4/search.html#token) and [how to search by date](http://hl7.org/fhir/R4/search.html#date))

#### Optional Search Parameters:

The following search parameters and search parameter combinations **SHOULD** be supported:

1. **SHOULD** support chained searching of patient canonical identifier `patient.identifier` (e.g. `patient.identifier=[system|][code]`)`GET [base]/Observation?patient.identifier=[system|][code]`Example:
1. GET [base]/Observation?patient.identifier=http://ns.electronichealth.net.au/id/medicare-number|32788511952
1. GET [base]/Observation?patient.identifier=http://ns.electronichealth.net.au/id/hi/ihi/1.0|8003608833357361
**Implementation Notes:** Fetches a bundle of all Observation resources for the specified patient ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference) and [how to search by token](http://hl7.org/fhir/R4/search.html#token))
1. **SHOULD**support searching using the combination of the**[`patient`](https://hl7.org/fhir/R4/observation.html#search)**and**[`category`](https://hl7.org/fhir/R4/observation.html#search)**and**[`status`](https://hl7.org/fhir/R4/observation.html#search)**search parameters:
* **SHOULD** support chained searching of patient canonical identifier `patient.identifier` (e.g. `patient.identifier=[system|][code]`)
* **SHALL** support **[multipleOr](http://hl7.org/fhir/R4/searchparameter-definitions.html#SearchParameter.multipleOr)** search on `status` (e.g. `status={system|}[code],{system|}[code],...`)
`GET [base]/Observation?patient={Type/}[id]&category={system|}[code]&status={system|}[code]{,{system|}[code],...}`Example:
1. GET [base]/Observation?patient=5678&category=http://terminology.hl7.org/CodeSystem/observation-category|survey&status=final
**Implementation Notes:** Fetches a bundle of all Observation resources for the specified patient and category and status ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference) and [how to search by token](http://hl7.org/fhir/R4/search.html#token))
1. **SHOULD**support searching using the combination of the**[`patient`](https://hl7.org/fhir/R4/observation.html#search)**and**[`code`](https://hl7.org/fhir/R4/observation.html#search)**and**[`date`](https://hl7.org/fhir/R4/observation.html#search)**search parameters:
* **SHOULD** support chained searching of patient canonical identifier `patient.identifier` (e.g. `patient.identifier=[system|][code]`
* **SHOULD** support **[multipleOr](http://hl7.org/fhir/R4/searchparameter-definitions.html#SearchParameter.multipleOr)** search on `code` (e.g. `code={system|}[code],{system|}[code],...`)
* **SHALL** support these `date` comparators: `gt,lt,ge,le`
* **SHOULD** support **[multipleAnd](http://hl7.org/fhir/R4/searchparameter-definitions.html#SearchParameter.multipleAnd)** search on `date` (e.g. `date=[date]&date=[date]]&...`), and if **[multipleAnd](http://hl7.org/fhir/R4/searchparameter-definitions.html#SearchParameter.multipleAnd)** is supported, **SHALL** support the search comparators `gt,lt,ge,le`
`GET [base]/Observation?patient={Type/}[id]&code={system|}[code]{,{system|}[code],...}&date={gt|lt|ge|le}[date]{&date={gt|lt|ge|le}[date]&...}`Example:
1. GET [base]/Observation?patient=5678&code=http://snomed.info/sct|89240007,http://loinc.org|14683-7,http://loinc.org|85354-9&date=ge2020-01-01T00:00:00Z
1. GET [base]/Observation?patient.identifier=http://example.org/fhir/mrn|12345&code=http://snomed.info/sct|89240007,http://loinc.org|14683-7,http://loinc.org|85354-9&date=ge2020-01-01T00:00:00Z
**Implementation Notes:** Fetches a bundle of all Observation resources for the specified patient and date and observation code(s). **SHOULD** support search by multiple codes. ([how to search by reference](http://hl7.org/fhir/R4/search.html#reference) and [how to search by token](http://hl7.org/fhir/R4/search.html#token) and [how to search by date](http://hl7.org/fhir/R4/search.html#date))



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "au-core-diagnosticresult",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 2
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org.au/fhir/core/ImplementationGuide/hl7.fhir.au.core"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-diagnosticresult",
  "version" : "2.0.0",
  "name" : "AUCoreDiagnosticResult",
  "title" : "AU Core Diagnostic Result Observation",
  "status" : "active",
  "date" : "2026-01-28T05:31:23+00:00",
  "publisher" : "HL7 Australia",
  "contact" : [
    {
      "name" : "HL7 Australia FHIR Work Group",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://confluence.hl7.org/display/HAFWG",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This profile sets minimum expectations for an Observation resource to record, search, and fetch specialist or other diagnostic (non-imaging or non-pathology) results for a patient. It is based on the [AU Base Diagnostic Result](https://hl7.org.au/fhir/6.0.0/StructureDefinition-au-diagnosticresult.html) profile and identifies the *additional* mandatory core elements, extensions, vocabularies and value sets that **SHALL** be present in the Observation when conforming to this profile. It provides the floor for standards development for specific uses cases in an Australian context.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "AU"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License. HL7 Australia© 2022+; Licensed Under Creative Commons No Rights Reserved.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org.au/fhir/StructureDefinition/au-diagnosticresult",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "constraint" : [
          {
            "key" : "au-core-obs-01",
            "severity" : "error",
            "human" : "If there is no component or hasMember element then at least value or data absent reason shall be present",
            "expression" : "(component.empty() and hasMember.empty()) implies (dataAbsentReason.exists() or value.exists())",
            "xpath" : "exists(f:component) or exists(f:hasMember) or exists(f:*[starts-with(local-name(.), 'value')]) or exists(f:dataAbsentReason)",
            "source" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-diagnosticresult"
          }
        ]
      },
      {
        "id" : "Observation.status",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Observation.status",
        "mustSupport" : true
      },
      {
        "id" : "Observation.category",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Observation.category",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Observation.code",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Observation.code",
        "mustSupport" : true
      },
      {
        "id" : "Observation.subject",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Observation.subject",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org.au/fhir/core/StructureDefinition/au-core-patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.effective[x]",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Observation.effective[x]",
        "min" : 1,
        "condition" : ["au-core-obs-02"],
        "constraint" : [
          {
            "key" : "au-core-obs-02",
            "severity" : "error",
            "human" : "Date shall be at least to day or, if not available, the Data Absent Reason extension shall be present",
            "expression" : "(($this is dateTime implies $this.toString().length() >= 10) and extension('http://hl7.org/fhir/StructureDefinition/data-absent-reason').value.exists().not()) xor ($this is dateTime implies ($this.hasValue().not() and extension('http://hl7.org/fhir/StructureDefinition/data-absent-reason').value.exists()))",
            "xpath" : "((self::dateTime and string-length(.) >= 10 and not(extension[@url='http://hl7.org/fhir/StructureDefinition/data-absent-reason'])) xor (self::dateTime and not(.) and extension[@url='http://hl7.org/fhir/StructureDefinition/data-absent-reason']))",
            "source" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-diagnosticresult"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.performer",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Observation.performer",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitioner",
              "http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitionerrole",
              "http://hl7.org.au/fhir/core/StructureDefinition/au-core-organization",
              "http://hl7.org.au/fhir/core/StructureDefinition/au-core-patient",
              "http://hl7.org.au/fhir/core/StructureDefinition/au-core-relatedperson"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.value[x]",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Observation.value[x]",
        "condition" : ["au-core-obs-01"],
        "mustSupport" : true
      },
      {
        "id" : "Observation.dataAbsentReason",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Observation.dataAbsentReason",
        "condition" : ["au-core-obs-01"],
        "mustSupport" : true
      },
      {
        "id" : "Observation.bodySite",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Observation.bodySite",
        "condition" : ["au-core-obs-04"],
        "constraint" : [
          {
            "key" : "au-core-obs-04",
            "severity" : "error",
            "human" : "If a coded body site is provided, at least one coding shall be from SNOMED CT",
            "expression" : "coding.exists() implies coding.where(system='http://snomed.info/sct').exists()",
            "xpath" : "not(exists(f:coding/f:system)) or exists(f:coding/f:system[@value='http://snomed.info/sct'])",
            "source" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-diagnosticresult"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "https://healthterminologies.gov.au/fhir/ValueSet/body-site-1"
        }
      },
      {
        "id" : "Observation.hasMember",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Observation.hasMember",
        "short" : "Individual observations in a group, study, or panel",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org.au/fhir/core/StructureDefinition/au-core-diagnosticresult",
              "http://hl7.org.au/fhir/StructureDefinition/au-imagingresult",
              "http://hl7.org.au/fhir/core/StructureDefinition/au-core-diagnosticresult-path"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.component",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Observation.component",
        "constraint" : [
          {
            "key" : "au-core-obs-03",
            "severity" : "error",
            "human" : "The component shall at least have a value or a data absent reason",
            "expression" : "value.exists() or dataAbsentReason.exists()",
            "source" : "http://hl7.org.au/fhir/core/StructureDefinition/au-core-diagnosticresult"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.component.code",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Observation.component.code",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component.value[x]",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Observation.component.value[x]",
        "condition" : ["au-core-obs-03"],
        "mustSupport" : true
      },
      {
        "id" : "Observation.component.dataAbsentReason",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:populate-if-known"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-responder"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:no-error"
              },
              {
                "url" : "actor",
                "valueCanonical" : "http://hl7.org.au/fhir/core/ActorDefinition/au-core-actor-requester"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Observation.component.dataAbsentReason",
        "condition" : ["au-core-obs-03"],
        "mustSupport" : true
      }
    ]
  }
}

```
