# Specimen - Naso swab (COVID test) - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Specimen - Naso swab (COVID test)**

## Example Specimen: Specimen - Naso swab (COVID test)

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

**type**: Swab

**subject**: [Li Wang Male, DoB: 1975-05-03 ( Medical Record Number: 22421441)](Patient-wang-li.md)

### Collections

| | | |
| :--- | :--- | :--- |
| - | **Collected[x]** | **BodySite** |
| * | 2021-02-15 12:00:00+1000 | Nasopharyngeal |

**note**: 

> 

Collection Setting COVID HSC Assessment Clinic




## Resource Content

```json
{
  "resourceType" : "Specimen",
  "id" : "nasoswab",
  "type" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "257261003",
        "display" : "Swab"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/wang-li"
  },
  "collection" : {
    "collectedDateTime" : "2021-02-15T12:00:00+10:00",
    "bodySite" : {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "71836000",
          "display" : "Nasopharyngeal structure"
        }
      ],
      "text" : "Nasopharyngeal"
    }
  },
  "note" : [
    {
      "text" : "Collection Setting COVID HSC Assessment Clinic"
    }
  ]
}

```
