# RelatedPerson - Father of Mia Leanne Banks - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **RelatedPerson - Father of Mia Leanne Banks**

## Example RelatedPerson: RelatedPerson - Father of Mia Leanne Banks

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core RelatedPerson](StructureDefinition-au-core-relatedperson.md)

**patient**: [Mia Leanne Banks Female, DoB: 1983-08-25 ( IHI: Austalian Healthcare Identifier - Individual#8003608333647261)](Patient-banks-mia-leanne.md)

**relationship**: Father

**name**: Bob Banks 



## Resource Content

```json
{
  "resourceType" : "RelatedPerson",
  "id" : "banks-mia-leanne-father",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-relatedperson"
    ]
  },
  "patient" : {
    "reference" : "Patient/banks-mia-leanne"
  },
  "relationship" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
          "code" : "FTH"
        }
      ],
      "text" : "Father"
    }
  ],
  "name" : [
    {
      "family" : "Banks",
      "given" : ["Bob"]
    }
  ]
}

```
