# Procedure - Stent insertion - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Procedure - Stent insertion**

## Example Procedure: Procedure - Stent insertion

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core Procedure](StructureDefinition-au-core-procedure.md)

**status**: Completed

**code**: Placement of stent in right coronary artery

**subject**: [Li Wang Male, DoB: 1975-05-03 ( Medical Record Number: 22421441)](Patient-wang-li.md)

**performed**: 2021-09-25

### Performers

| | |
| :--- | :--- |
| - | **Actor** |
| * | [PractitionerRole Surgeon (General)](PractitionerRole-surgeon-chau-fryer.md) |

**location**: [Location Murrabit Public Hospital](Location-murrabit-hospital.md)

**reasonCode**: Occlusion of right coronary artery

**bodySite**: Right coronary artery

### FocalDevices

| | | |
| :--- | :--- | :--- |
| - | **Action** | **Manipulated** |
| * | Surgical insertion - action | coronary stent |



## Resource Content

```json
{
  "resourceType" : "Procedure",
  "id" : "stentinsertion",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-procedure"
    ]
  },
  "status" : "completed",
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "36969009",
        "display" : "Placement of stent in coronary artery"
      }
    ],
    "text" : "Placement of stent in right coronary artery"
  },
  "subject" : {
    "reference" : "Patient/wang-li"
  },
  "performedDateTime" : "2021-09-25",
  "performer" : [
    {
      "actor" : {
        "reference" : "PractitionerRole/surgeon-chau-fryer"
      }
    }
  ],
  "location" : {
    "reference" : "Location/murrabit-hospital"
  },
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "876856005",
          "display" : "Stenosis of right coronary artery"
        }
      ],
      "text" : "Occlusion of right coronary artery"
    }
  ],
  "bodySite" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "13647002",
          "display" : "Right coronary artery structure"
        }
      ],
      "text" : "Right coronary artery"
    }
  ],
  "focalDevice" : [
    {
      "action" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "425362007",
            "display" : "Surgical insertion - action"
          }
        ]
      },
      "manipulated" : {
        "display" : "coronary stent"
      }
    }
  ]
}

```
