# PractitionerRole - Nephrologist - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **PractitionerRole - Nephrologist**

## Example PractitionerRole: PractitionerRole - Nephrologist

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core PractitionerRole](StructureDefinition-au-core-practitionerrole.md)

**identifier**: Employee number/N765009-mackay-darleen

**practitioner**: [Practitioner MACKAY Darleen ](Practitioner-darleen-mackay.md)

**code**: Nephrologist

**telecom**: ph: (03) 7010 8625



## Resource Content

```json
{
  "resourceType" : "PractitionerRole",
  "id" : "nephrologist-darleen-mackay",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitionerrole"
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "EI"
          }
        ],
        "text" : "Employee number"
      },
      "system" : "http://nephrologyclinic.org.example.com/employee-id",
      "value" : "N765009-mackay-darleen",
      "assigner" : {
        "display" : "Docker River Nephrology Clinic"
      }
    }
  ],
  "practitioner" : {
    "reference" : "Practitioner/darleen-mackay"
  },
  "code" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "11911009",
          "display" : "Nephrologist"
        },
        {
          "system" : "http://www.abs.gov.au/ausstats/abs@.nsf/mf/1220.0",
          "code" : "253322",
          "display" : "Renal Medicine Specialist"
        }
      ],
      "text" : "Nephrologist"
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "(03) 7010 8625"
    }
  ]
}

```
