# PractitionerRole - Cardiologist - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **PractitionerRole - Cardiologist**

## Example PractitionerRole: PractitionerRole - Cardiologist

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core PractitionerRole](StructureDefinition-au-core-practitionerrole.md)

**identifier**: Medicare Provider Number/2449001X

**practitioner**: [Practitioner Sallie Sutherland (official)](Practitioner-sallie-sutherland.md)

**organization**: [Organization Murrabit Public Hospital](Organization-murrabit-hospital.md)

**code**: Cardiologist

**location**: [Location Murrabit Public Hospital](Location-murrabit-hospital.md)

**telecom**: ph: 0370102880, [sallie.sutherland@murrabitph.example.com.au](mailto:sallie.sutherland@murrabitph.example.com.au)



## Resource Content

```json
{
  "resourceType" : "PractitionerRole",
  "id" : "cardiologist-sallie-sutherland",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-practitionerrole"
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org.au/CodeSystem/v2-0203",
            "code" : "UPIN"
          }
        ],
        "text" : "Medicare Provider Number"
      },
      "system" : "http://ns.electronichealth.net.au/id/medicare-provider-number",
      "value" : "2449001X"
    }
  ],
  "practitioner" : {
    "reference" : "Practitioner/sallie-sutherland"
  },
  "organization" : {
    "reference" : "Organization/murrabit-hospital"
  },
  "code" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "17561000",
          "display" : "Cardiologist"
        }
      ],
      "text" : "Cardiologist"
    }
  ],
  "location" : [
    {
      "reference" : "Location/murrabit-hospital"
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "0370102880"
    },
    {
      "system" : "email",
      "value" : "sallie.sutherland@murrabitph.example.com.au",
      "use" : "work"
    }
  ]
}

```
