# Patient - Mr. Li Wang - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Patient - Mr. Li Wang**

## Example Patient: Patient - Mr. Li Wang

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core Patient](StructureDefinition-au-core-patient.md)

Li Wang Male, DoB: 1975-05-03 ( Medical Record Number: 22421441)

-------

| | |
| :--- | :--- |
| Contact Detail | 29 Gadsby Street Blacktown NSW 2148 AU (home) |
| Language: | Cantonese(preferred) |
| [Australian Indigenous Status](http://hl7.org.au/fhir/6.0.0/StructureDefinition-indigenous-status.html) | australian-indigenous-status-1: 4 (Neither Aboriginal nor Torres Strait Islander origin) |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "wang-li",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-patient"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org.au/fhir/StructureDefinition/indigenous-status",
      "valueCoding" : {
        "system" : "https://healthterminologies.gov.au/fhir/CodeSystem/australian-indigenous-status-1",
        "code" : "4",
        "display" : "Neither Aboriginal nor Torres Strait Islander origin"
      }
    }
  ],
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MR",
            "display" : "Medical record number"
          }
        ],
        "text" : "Medical Record Number"
      },
      "system" : "http://ns.electronichealth.net.au/id/hpio-scoped/medicalrecord/1.0/8003626566699734",
      "value" : "22421441",
      "assigner" : {
        "display" : "Mount Mitchell Private Hospital"
      }
    }
  ],
  "name" : [
    {
      "family" : "Wang",
      "given" : ["Li"],
      "prefix" : ["Mr"]
    }
  ],
  "gender" : "male",
  "birthDate" : "1975-05-03",
  "address" : [
    {
      "use" : "home",
      "line" : ["29 Gadsby Street"],
      "city" : "Blacktown",
      "state" : "NSW",
      "postalCode" : "2148",
      "country" : "AU"
    }
  ],
  "communication" : [
    {
      "language" : {
        "coding" : [
          {
            "system" : "urn:ietf:bcp:47",
            "code" : "yue"
          }
        ],
        "text" : "Cantonese"
      },
      "preferred" : true
    }
  ]
}

```
