# Patient - Ronny Lawrence Irvine - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Patient - Ronny Lawrence Irvine**

## Example Patient: Patient - Ronny Lawrence Irvine

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core Patient](StructureDefinition-au-core-patient.md)

Ronny Lawrence Irvine Male, DoB: ( DVA Number: QX827261)

-------

| | |
| :--- | :--- |
| Contact Detail | * [ronny.irvine@myownpersonaldomain.com](mailto:ronny.irvine@myownpersonaldomain.com)
* 180 Hermann Rd Belmore River NSW 2440 Australia (home)
 |
| [Australian Indigenous Status](http://hl7.org.au/fhir/6.0.0/StructureDefinition-indigenous-status.html) | australian-indigenous-status-1: 2 (Torres Strait Islander but not Aboriginal origin) |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "ronny-irvine",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-patient"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org.au/fhir/StructureDefinition/indigenous-status",
      "valueCoding" : {
        "system" : "https://healthterminologies.gov.au/fhir/CodeSystem/australian-indigenous-status-1",
        "code" : "2",
        "display" : "Torres Strait Islander but not Aboriginal origin"
      }
    }
  ],
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org.au/CodeSystem/v2-0203",
            "code" : "DVAU",
            "display" : "DVA Number"
          }
        ],
        "text" : "DVA Number"
      },
      "system" : "http://ns.electronichealth.net.au/id/dva",
      "value" : "QX827261"
    }
  ],
  "name" : [
    {
      "use" : "usual",
      "family" : "Irvine",
      "given" : ["Ronny", "Lawrence"]
    }
  ],
  "telecom" : [
    {
      "system" : "email",
      "value" : "ronny.irvine@myownpersonaldomain.com",
      "use" : "home"
    }
  ],
  "gender" : "male",
  "_birthDate" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
        "valueCode" : "unknown"
      }
    ]
  },
  "address" : [
    {
      "use" : "home",
      "line" : ["180 Hermann Rd"],
      "city" : "Belmore River",
      "state" : "NSW",
      "postalCode" : "2440",
      "country" : "Australia"
    }
  ]
}

```
