# Patient - Deangelo HOWE - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Patient - Deangelo HOWE**

## Example Patient: Patient - Deangelo HOWE

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core Patient](StructureDefinition-au-core-patient.md)

Deangelo HOWE Male, DoB: 1975-06-21 ( IHI: Austalian Healthcare Identifier - Individual#8003608000311621)

-------

| | |
| :--- | :--- |
| Contact Detail | * ph: 0770105770(Work)
* ph: 0491570156(Mobile)
* [deangelo.howe@example.net](mailto:deangelo.howe@example.net)
* ph: 0770109269(Home)
* 134 Copper Hts Curra QLD 4570 AU 
 |
| [Australian Indigenous Status](http://hl7.org.au/fhir/6.0.0/StructureDefinition-indigenous-status.html) | australian-indigenous-status-1: 4 (Neither Aboriginal nor Torres Strait Islander origin) |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "howe-deangelo",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-patient"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org.au/fhir/StructureDefinition/indigenous-status",
      "valueCoding" : {
        "system" : "https://healthterminologies.gov.au/fhir/CodeSystem/australian-indigenous-status-1",
        "code" : "4",
        "display" : "Neither Aboriginal nor Torres Strait Islander origin"
      }
    }
  ],
  "identifier" : [
    {
      "extension" : [
        {
          "url" : "http://hl7.org.au/fhir/StructureDefinition/ihi-status",
          "valueCoding" : {
            "system" : "https://healthterminologies.gov.au/fhir/CodeSystem/ihi-status-1",
            "code" : "active"
          }
        },
        {
          "url" : "http://hl7.org.au/fhir/StructureDefinition/ihi-record-status",
          "valueCoding" : {
            "system" : "https://healthterminologies.gov.au/fhir/CodeSystem/ihi-record-status-1",
            "code" : "verified",
            "display" : "verified"
          }
        }
      ],
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "NI"
          }
        ],
        "text" : "IHI"
      },
      "system" : "http://ns.electronichealth.net.au/id/hi/ihi/1.0",
      "value" : "8003608000311621"
    }
  ],
  "name" : [
    {
      "use" : "usual",
      "family" : "HOWE",
      "given" : ["Deangelo"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "0770105770",
      "use" : "work"
    },
    {
      "system" : "phone",
      "value" : "0491570156",
      "use" : "mobile"
    },
    {
      "system" : "email",
      "value" : "deangelo.howe@example.net"
    },
    {
      "system" : "phone",
      "value" : "0770109269",
      "use" : "home"
    }
  ],
  "gender" : "male",
  "birthDate" : "1975-06-21",
  "address" : [
    {
      "line" : ["134 Copper Hts"],
      "city" : "Curra",
      "state" : "QLD",
      "postalCode" : "4570",
      "country" : "AU"
    }
  ]
}

```
