# Organization - Mitchells Hill Audiology - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Organization - Mitchells Hill Audiology**

## Example Organization: Organization - Mitchells Hill Audiology

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core Organization](StructureDefinition-au-core-organization.md)

**identifier**: HPI-O/8003626566707032, ABN/81129842694

**type**: Audiology clinic

**name**: Mitchells Hill Audiology

**telecom**: ph: (03) 5550 3095, [reception@mitchellshillaudiology.example.com.au](mailto:reception@mitchellshillaudiology.example.com.au)

**address**: 87 Freedom Pnt Mitchells Hill VIC 3478 AU 



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "mitchells-hill-audiology",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-organization"
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org.au/CodeSystem/v2-0203",
            "code" : "NOI",
            "display" : "National Organisation Identifier"
          }
        ],
        "text" : "HPI-O"
      },
      "system" : "http://ns.electronichealth.net.au/id/hi/hpio/1.0",
      "value" : "8003626566707032"
    },
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "XX"
          }
        ],
        "text" : "ABN"
      },
      "system" : "http://hl7.org.au/id/abn",
      "value" : "81129842694"
    }
  ],
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "702824005",
          "display" : "Audiology clinic"
        },
        {
          "system" : "http://www.abs.gov.au/ausstats/abs@.nsf/mf/1292.0",
          "code" : "8539",
          "display" : "Other Allied Health Services"
        }
      ]
    }
  ],
  "name" : "Mitchells Hill Audiology",
  "telecom" : [
    {
      "system" : "phone",
      "value" : "(03) 5550 3095"
    },
    {
      "system" : "email",
      "value" : "reception@mitchellshillaudiology.example.com.au",
      "use" : "work"
    }
  ],
  "address" : [
    {
      "type" : "physical",
      "line" : ["87 Freedom Pnt"],
      "city" : "Mitchells Hill",
      "state" : "VIC",
      "postalCode" : "3478",
      "country" : "AU"
    }
  ]
}

```
