# Organization - Bobrester Medical Centre - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Organization - Bobrester Medical Centre**

## Example Organization: Organization - Bobrester Medical Centre

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core Organization](StructureDefinition-au-core-organization.md)

**identifier**: ABN/12345678901

**type**: Medical Center

**name**: Bobrester Medical Center

**telecom**: [info@bobrestermedical.example.com](mailto:info@bobrestermedical.example.com), ph: (07) 5550 2427(Work)

**address**: 87 Western Esp Tindal RAAF QLD 4655 AU 



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "bobrester-medical-center",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-organization"
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "XX"
          }
        ],
        "text" : "ABN"
      },
      "system" : "http://hl7.org.au/id/abn",
      "value" : "12345678901"
    }
  ],
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "288565001",
          "display" : "Medical centre"
        }
      ],
      "text" : "Medical Center"
    }
  ],
  "name" : "Bobrester Medical Center",
  "telecom" : [
    {
      "system" : "email",
      "value" : "info@bobrestermedical.example.com",
      "use" : "work"
    },
    {
      "system" : "phone",
      "value" : "(07) 5550 2427",
      "use" : "work"
    }
  ],
  "address" : [
    {
      "line" : ["87 Western Esp"],
      "city" : "Tindal RAAF",
      "state" : "QLD",
      "postalCode" : "4655",
      "country" : "AU"
    }
  ]
}

```
