# Observation - Current smoker - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Observation - Current smoker**

## Example Observation: Observation - Current smoker

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core Smoking Status](StructureDefinition-au-core-smokingstatus.md)

**status**: Final

**category**: Social History

**code**: Smoking status

**subject**: [Li Wang Male, DoB: 1975-05-03 ( Medical Record Number: 22421441)](Patient-wang-li.md)

**effective**: 2016-07-02

**value**: Smoker



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "smokingstatus-current-smoker",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-smokingstatus"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "social-history",
          "display" : "Social History"
        }
      ],
      "text" : "Social History"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "1747861000168109"
      },
      {
        "system" : "http://loinc.org",
        "code" : "72166-2"
      }
    ],
    "text" : "Smoking status"
  },
  "subject" : {
    "reference" : "Patient/wang-li"
  },
  "effectiveDateTime" : "2016-07-02",
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "77176002",
        "display" : "Current smoker"
      },
      {
        "system" : "http://loinc.org",
        "code" : "LA18979-7"
      }
    ],
    "text" : "Smoker"
  }
}

```
