# Observation - Respiration rate - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Observation - Respiration rate**

## Example Observation: Observation - Respiration rate

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core Respiration Rate](StructureDefinition-au-core-resprate.md)

**status**: Final

**category**: Vital Signs

**code**: Respiratory rate

**subject**: [Mia Leanne Banks Female, DoB: 1983-08-25 ( IHI: Austalian Healthcare Identifier - Individual#8003608333647261)](Patient-banks-mia-leanne.md)

**effective**: 2022-02-17

**value**: 22 breaths/minute (Details: UCUM code/min = '/min')



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "resprate-1",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-resprate"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "vital-signs",
          "display" : "Vital Signs"
        }
      ],
      "text" : "Vital Signs"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "9279-1",
        "display" : "Respiratory rate"
      },
      {
        "system" : "http://snomed.info/sct",
        "code" : "86290005"
      }
    ],
    "text" : "Respiratory rate"
  },
  "subject" : {
    "reference" : "Patient/banks-mia-leanne"
  },
  "effectiveDateTime" : "2022-02-17",
  "valueQuantity" : {
    "value" : 22,
    "unit" : "breaths/minute",
    "system" : "http://unitsofmeasure.org",
    "code" : "/min"
  }
}

```
