# Observation - COVID Pathology Result (Not detected) - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Observation - COVID Pathology Result (Not detected)**

## Example Observation: Observation - COVID Pathology Result (Not detected)

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core Pathology Result Observation](StructureDefinition-au-core-diagnosticresult-path.md)

**status**: Final

**category**: Laboratory, Microbiology

**code**: 2019-Novel Coronavirus PCR

**subject**: [Li Wang Male, DoB: 1975-05-03 ( Medical Record Number: 22421441)](Patient-wang-li.md)

**effective**: 2021-02-15 12:00:00+1000

**performer**: PATHOLOGY LAB

**value**: Not detected

**specimen**: [Specimen: type = Swab; note = Collection Setting COVID HSC Assessment Clinic](Specimen-nasoswab.md)



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "pathresult-covid-1",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-diagnosticresult-path"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "MB"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "94309-2"
      }
    ],
    "text" : "2019-Novel Coronavirus PCR"
  },
  "subject" : {
    "reference" : "Patient/wang-li"
  },
  "effectiveDateTime" : "2021-02-15T12:00:00+10:00",
  "performer" : [
    {
      "display" : "PATHOLOGY LAB"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "260415000",
        "display" : "Not detected"
      }
    ],
    "text" : "Not detected"
  },
  "specimen" : {
    "reference" : "Specimen/nasoswab"
  }
}

```
