# Observation - Heart rate - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Observation - Heart rate**

## Example Observation: Observation - Heart rate

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core Heart Rate](StructureDefinition-au-core-heartrate.md)

**status**: Final

**category**: Vital Signs

**code**: Heart rate

**subject**: [Li Wang Male, DoB: 1975-05-03 ( Medical Record Number: 22421441)](Patient-wang-li.md)

**effective**: 2016-07-02

**performer**: [PractitionerRole General practitioner](PractitionerRole-bobrester-bob-gp.md)

**value**: 80 beats/minute (Details: UCUM code/min = '/min')



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "heartrate-1",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-heartrate"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "vital-signs",
          "display" : "Vital Signs"
        }
      ],
      "text" : "Vital Signs"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "8867-4",
        "display" : "Heart rate"
      },
      {
        "system" : "http://snomed.info/sct",
        "code" : "364075005",
        "display" : "Heart rate"
      }
    ],
    "text" : "Heart rate"
  },
  "subject" : {
    "reference" : "Patient/wang-li"
  },
  "effectiveDateTime" : "2016-07-02",
  "performer" : [
    {
      "reference" : "PractitionerRole/bobrester-bob-gp"
    }
  ],
  "valueQuantity" : {
    "value" : 80,
    "unit" : "beats/minute",
    "system" : "http://unitsofmeasure.org",
    "code" : "/min"
  }
}

```
