# Observation - Hearing threshold Ear (left) 500 Hz - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Observation - Hearing threshold Ear (left) 500 Hz**

## Example Observation: Observation - Hearing threshold Ear (left) 500 Hz

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profiles: [AU Core Diagnostic Result Observation](StructureDefinition-au-core-diagnosticresult.md), [AU Base Diagnostic Result](http://hl7.org.au/fhir/6.0.0/StructureDefinition-au-diagnosticresult.html)

**status**: Final

**category**: Audiology

**code**: Hearing threshold Ear - left --500 Hz

**subject**: [Ronny Lawrence Irvine Male, DoB: ( DVA Number: QX827261)](Patient-ronny-irvine.md)

**effective**: 2020-11-06 10:45:00-0500

**performer**: [Organization Mitchells Hill Audiology](Organization-mitchells-hill-audiology.md)

**value**: 45 dB (Details: UCUM codedB = 'dB')



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "hearing-threshold-1",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-diagnosticresult",
      "http://hl7.org.au/fhir/StructureDefinition/au-diagnosticresult"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0074",
          "code" : "AU",
          "display" : "Audiology"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "89024-4",
        "display" : "Hearing threshold Ear - left --500 Hz"
      }
    ],
    "text" : "Hearing threshold Ear - left --500 Hz"
  },
  "subject" : {
    "reference" : "Patient/ronny-irvine"
  },
  "effectiveDateTime" : "2020-11-06T10:45:00-05:00",
  "performer" : [
    {
      "reference" : "Organization/mitchells-hill-audiology"
    }
  ],
  "valueQuantity" : {
    "value" : 45,
    "unit" : "dB",
    "system" : "http://unitsofmeasure.org",
    "code" : "dB"
  }
}

```
