# Observation - Blood Pressure (data absent for diastolic) - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Observation - Blood Pressure (data absent for diastolic)**

## Example Observation: Observation - Blood Pressure (data absent for diastolic)

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core Blood Pressure](StructureDefinition-au-core-bloodpressure.md)

**status**: Final

**category**: Vital Signs

**code**: Blood pressure systolic and diastolic

**subject**: [Ronny Lawrence Irvine Male, DoB: ( DVA Number: QX827261)](Patient-ronny-irvine.md)

**encounter**: [Encounter: status = finished; class = emergency (ActCode#EMER); period = 2023-02-20 06:15:00+1000 --> 2023-02-20 18:19:00+1000](Encounter-discharge-1.md)

**effective**: 2023-02-20 06:20:00+1000

> **component****code**: Systolic blood pressure**value**: 109 mmHg (Details: UCUM codemm[Hg] = 'mm[Hg]')

> **component****code**: Diastolic blood pressure**dataAbsentReason**: Unknown



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "bloodpressure-data-absent",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-bloodpressure"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "vital-signs",
          "display" : "Vital Signs"
        }
      ],
      "text" : "Vital Signs"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "85354-9",
        "display" : "Blood pressure panel with all children optional"
      },
      {
        "system" : "http://snomed.info/sct",
        "code" : "75367002"
      }
    ],
    "text" : "Blood pressure systolic and diastolic"
  },
  "subject" : {
    "reference" : "Patient/ronny-irvine"
  },
  "encounter" : {
    "reference" : "Encounter/discharge-1"
  },
  "effectiveDateTime" : "2023-02-20T06:20:00+10:00",
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "8480-6",
            "display" : "Systolic blood pressure"
          },
          {
            "system" : "http://snomed.info/sct",
            "code" : "271649006"
          }
        ],
        "text" : "Systolic blood pressure"
      },
      "valueQuantity" : {
        "value" : 109,
        "unit" : "mmHg",
        "system" : "http://unitsofmeasure.org",
        "code" : "mm[Hg]"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "8462-4",
            "display" : "Diastolic blood pressure"
          },
          {
            "system" : "http://snomed.info/sct",
            "code" : "271650006"
          }
        ],
        "text" : "Diastolic blood pressure"
      },
      "dataAbsentReason" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/data-absent-reason",
            "code" : "unknown",
            "display" : "Unknown"
          }
        ],
        "text" : "Unknown"
      }
    }
  ]
}

```
