# Observation - Blood Pressure (systolic and diastolic) - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Observation - Blood Pressure (systolic and diastolic)**

## Example Observation: Observation - Blood Pressure (systolic and diastolic)

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core Blood Pressure](StructureDefinition-au-core-bloodpressure.md)

**status**: Final

**category**: Vital Signs

**code**: Blood pressure systolic and diastolic

**subject**: [Li Wang Male, DoB: 1975-05-03 ( Medical Record Number: 22421441)](Patient-wang-li.md)

**effective**: 2016-07-02

**performer**: [PractitionerRole General practitioner](PractitionerRole-bobrester-bob-gp.md)

> **component****code**: Systolic blood pressure**value**: 109 mmHg (Details: UCUM codemm[Hg] = 'mm[Hg]')

> **component****code**: Diastolic blood pressure**value**: 44 mmHg (Details: UCUM codemm[Hg] = 'mm[Hg]')



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "bloodpressure-1",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-bloodpressure"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "vital-signs",
          "display" : "Vital Signs"
        }
      ],
      "text" : "Vital Signs"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "85354-9",
        "display" : "Blood pressure panel with all children optional"
      },
      {
        "system" : "http://snomed.info/sct",
        "code" : "75367002"
      }
    ],
    "text" : "Blood pressure systolic and diastolic"
  },
  "subject" : {
    "reference" : "Patient/wang-li"
  },
  "effectiveDateTime" : "2016-07-02",
  "performer" : [
    {
      "reference" : "PractitionerRole/bobrester-bob-gp"
    }
  ],
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "8480-6",
            "display" : "Systolic blood pressure"
          },
          {
            "system" : "http://snomed.info/sct",
            "code" : "271649006"
          }
        ],
        "text" : "Systolic blood pressure"
      },
      "valueQuantity" : {
        "value" : 109,
        "unit" : "mmHg",
        "system" : "http://unitsofmeasure.org",
        "code" : "mm[Hg]"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "8462-4",
            "display" : "Diastolic blood pressure"
          },
          {
            "system" : "http://snomed.info/sct",
            "code" : "271650006"
          }
        ],
        "text" : "Diastolic blood pressure"
      },
      "valueQuantity" : {
        "value" : 44,
        "unit" : "mmHg",
        "system" : "http://unitsofmeasure.org",
        "code" : "mm[Hg]"
      }
    }
  ]
}

```
