# MedicationStatement - completed use of Chloramphenicol 1% eye ointment - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **MedicationStatement - completed use of Chloramphenicol 1% eye ointment**

## Example MedicationStatement: MedicationStatement - completed use of Chloramphenicol 1% eye ointment

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core MedicationStatement](StructureDefinition-au-core-medicationstatement.md)

**status**: Completed

**medication**: Chloramphenicol 1% eye ointment

**subject**: [Mia Leanne Banks Female, DoB: 1983-08-25 ( IHI: Austalian Healthcare Identifier - Individual#8003608333647261)](Patient-banks-mia-leanne.md)

**dateAsserted**: 2019-02-05

**reasonCode**: Adult gonococcal conjunctivitis



## Resource Content

```json
{
  "resourceType" : "MedicationStatement",
  "id" : "completed-chloramphenicol",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-medicationstatement"
    ]
  },
  "status" : "completed",
  "medicationCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "22717011000036101",
        "display" : "Chloramphenicol 1% eye ointment"
      }
    ],
    "text" : "Chloramphenicol 1% eye ointment"
  },
  "subject" : {
    "reference" : "Patient/banks-mia-leanne"
  },
  "dateAsserted" : "2019-02-05",
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "719755001"
        }
      ],
      "text" : "Adult gonococcal conjunctivitis"
    }
  ]
}

```
