# MedicationRequest - active prescription, Simvastatin - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **MedicationRequest - active prescription, Simvastatin**

## Example MedicationRequest: MedicationRequest - active prescription, Simvastatin

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core MedicationRequest](StructureDefinition-au-core-medicationrequest.md)

**status**: Active

**intent**: Order

**medication**: [Medication Simvastatin 40 mg tablet](Medication-simvastatin.md)

**subject**: [Li Wang Male, DoB: 1975-05-03 ( Medical Record Number: 22421441)](Patient-wang-li.md)

**authoredOn**: 2020-07-15

**requester**: [PractitionerRole Surgeon (General)](PractitionerRole-surgeon-chau-fryer.md)

**reasonCode**: High cholesterol

> **dosageInstruction****text**: Take one tablet daily**timing**: Once per 1 day**asNeeded**: true**route**: Oral route

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 1 TAB (Details: Orderable Drug Form codeTAB = 'Tablet') |




## Resource Content

```json
{
  "resourceType" : "MedicationRequest",
  "id" : "simvastatin",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-medicationrequest"
    ]
  },
  "status" : "active",
  "intent" : "order",
  "medicationReference" : {
    "reference" : "Medication/simvastatin"
  },
  "subject" : {
    "reference" : "Patient/wang-li"
  },
  "authoredOn" : "2020-07-15",
  "requester" : {
    "reference" : "PractitionerRole/surgeon-chau-fryer"
  },
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "13644009",
          "display" : "Hypercholesterolaemia"
        }
      ],
      "text" : "High cholesterol"
    }
  ],
  "dosageInstruction" : [
    {
      "text" : "Take one tablet daily",
      "timing" : {
        "repeat" : {
          "frequency" : 1,
          "period" : 1,
          "periodUnit" : "d"
        }
      },
      "asNeededBoolean" : true,
      "route" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "26643006",
            "display" : "Oral route"
          }
        ]
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 1,
            "unit" : "TAB",
            "system" : "http://terminology.hl7.org/CodeSystem/v3-orderableDrugForm",
            "code" : "TAB"
          }
        }
      ]
    }
  ]
}

```
