# MedicationRequest - prescription, paracetamol 500 mg + codeine phosphate hemihydrate 30 mg - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **MedicationRequest - prescription, paracetamol 500 mg + codeine phosphate hemihydrate 30 mg**

## Example MedicationRequest: MedicationRequest - prescription, paracetamol 500 mg + codeine phosphate hemihydrate 30 mg

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core MedicationRequest](StructureDefinition-au-core-medicationrequest.md)

**status**: Unknown

**intent**: Order

**medication**: Paracetamol 500 mg + codeine phosphate hemihydrate 30 mg tablet

**subject**: [Mrs. Anne Mary Bennelong(official) Female, DoB: 1968-10-11 ( Medical record number)](Patient-bennelong-anne.md)

**authoredOn**: 2018-07-15

**requester**: ?rref?

**reasonCode**: Pain management

> **dosageInstruction****text**: 1-2 tablets every 4-6 hours as needed for pain**timing**: 1-2 per 4-6 hours**asNeeded**: true**route**: Oral route

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 1 TAB (Details: Orderable Drug Form codeTAB = 'Tablet') |




## Resource Content

```json
{
  "resourceType" : "MedicationRequest",
  "id" : "paracetamol-codeine",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-medicationrequest"
    ]
  },
  "status" : "unknown",
  "intent" : "order",
  "medicationCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "79115011000036100",
        "display" : "Paracetamol 500 mg + codeine phosphate hemihydrate 30 mg tablet"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/bennelong-anne"
  },
  "authoredOn" : "2018-07-15",
  "requester" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/data-absent-reason",
        "valueCode" : "unknown"
      }
    ]
  },
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "278414003",
          "display" : "Pain management"
        }
      ],
      "text" : "Pain management"
    }
  ],
  "dosageInstruction" : [
    {
      "text" : "1-2 tablets every 4-6 hours as needed for pain",
      "timing" : {
        "repeat" : {
          "frequency" : 1,
          "frequencyMax" : 2,
          "period" : 4,
          "periodMax" : 6,
          "periodUnit" : "h"
        }
      },
      "asNeededBoolean" : true,
      "route" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "26643006",
            "display" : "Oral route"
          }
        ]
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 1,
            "unit" : "TAB",
            "system" : "http://terminology.hl7.org/CodeSystem/v3-orderableDrugForm",
            "code" : "TAB"
          }
        }
      ]
    }
  ]
}

```
