# Location - Patient home - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Location - Patient home**

## Example Location: Location - Patient home

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core Location](StructureDefinition-au-core-location.md)

**status**: Active

**name**: Patient's home

**mode**: Kind

**type**: Patient's Residence

**physicalType**: House



## Resource Content

```json
{
  "resourceType" : "Location",
  "id" : "patient-home",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-location"
    ]
  },
  "status" : "active",
  "name" : "Patient's home",
  "mode" : "kind",
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
          "code" : "PTRES",
          "display" : "Patient's Residence"
        },
        {
          "system" : "http://snomed.info/sct",
          "code" : "394778007",
          "display" : "Client's or patient's home"
        }
      ]
    }
  ],
  "physicalType" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/location-physical-type",
        "code" : "ho",
        "display" : "House"
      }
    ]
  }
}

```
