# Location - Murrabit Public Hospital - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Location - Murrabit Public Hospital**

## Example Location: Location - Murrabit Public Hospital

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core Location](StructureDefinition-au-core-location.md)

**name**: Murrabit Public Hospital

**type**: Hospital

**telecom**: ph: (03) 5550 3333

**address**: 144 Central Gdns Murrabit VIC 3579 AU 

**physicalType**: Site



## Resource Content

```json
{
  "resourceType" : "Location",
  "id" : "murrabit-hospital",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-location"
    ]
  },
  "name" : "Murrabit Public Hospital",
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
          "code" : "HOSP",
          "display" : "Hospital"
        },
        {
          "system" : "http://snomed.info/sct",
          "code" : "22232009",
          "display" : "Hospital"
        }
      ]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "(03) 5550 3333"
    }
  ],
  "address" : {
    "line" : ["144 Central Gdns"],
    "city" : "Murrabit",
    "state" : "VIC",
    "postalCode" : "3579",
    "country" : "AU"
  },
  "physicalType" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/location-physical-type",
        "code" : "si",
        "display" : "Site"
      }
    ]
  }
}

```
