# Location - Tindal Building - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Location - Tindal Building**

## Example Location: Location - Tindal Building

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core Location](StructureDefinition-au-core-location.md)

**status**: Active

**name**: Tindal Building

**alias**: Bobrester Medical Center

**type**: Family medicine clinic

**address**: 87 Western Esp Tindal RAAF QLD 4655 AU 

**physicalType**: Building



## Resource Content

```json
{
  "resourceType" : "Location",
  "id" : "bobrester-medical-center",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-location"
    ]
  },
  "status" : "active",
  "name" : "Tindal Building",
  "alias" : ["Bobrester Medical Center"],
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
          "code" : "FMC",
          "display" : "Family medicine clinic"
        },
        {
          "system" : "http://snomed.info/sct",
          "code" : "288565001",
          "display" : "Medical centre"
        }
      ]
    }
  ],
  "address" : {
    "line" : ["87 Western Esp"],
    "city" : "Tindal RAAF",
    "state" : "QLD",
    "postalCode" : "4655",
    "country" : "AU"
  },
  "physicalType" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/location-physical-type",
        "code" : "bu",
        "display" : "Building"
      }
    ]
  }
}

```
