# Immunization - Administration of Zoster vaccination refused - AU Core Implementation Guide v2.0.0

* [**Table of Contents**](toc.md)
* [**FHIR Artefacts**](fhirartefacts.md)
* [**Artefacts Summary**](artifacts.md)
* **Immunization - Administration of Zoster vaccination refused**

## Example Immunization: Immunization - Administration of Zoster vaccination refused

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [AU Core Immunization](StructureDefinition-au-core-immunization.md)

**status**: Not Done

**vaccineCode**: Varicella-zoster live vaccine

**patient**: [Deangelo HOWE](Patient-howe-deangelo.md)

**occurrence**: 2017-08-15

**primarySource**: true

**note**: 

> 

Patient refused administration of Zostavax




## Resource Content

```json
{
  "resourceType" : "Immunization",
  "id" : "zoster-notgiven",
  "meta" : {
    "profile" : [
      "http://hl7.org.au/fhir/core/StructureDefinition/au-core-immunization"
    ]
  },
  "status" : "not-done",
  "vaccineCode" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "830851000168105",
        "display" : "Varicella-zoster live vaccine"
      }
    ]
  },
  "patient" : {
    "reference" : "Patient/howe-deangelo",
    "display" : "Deangelo HOWE"
  },
  "occurrenceDateTime" : "2017-08-15",
  "primarySource" : true,
  "note" : [
    {
      "text" : "Patient refused administration of Zostavax"
    }
  ]
}

```
